/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.extension;

import com.soebes.itf.jupiter.extension.MavenGoal;
import com.soebes.itf.jupiter.extension.MavenOption;
import com.soebes.itf.jupiter.extension.MavenPredefinedRepository;
import com.soebes.itf.jupiter.extension.MavenProfile;
import com.soebes.itf.jupiter.extension.MavenProject;
import com.soebes.itf.jupiter.extension.MavenProjectLocation;
import com.soebes.itf.jupiter.extension.MavenProjectSources;
import com.soebes.itf.jupiter.extension.MavenRepository;
import com.soebes.itf.jupiter.extension.SystemProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.platform.commons.support.AnnotationSupport;

class AnnotationHelper {
    private AnnotationHelper() {
    }

    static boolean hasProfiles(ExtensionContext context) {
        return !AnnotationHelper.profiles(context).isEmpty();
    }

    static List<String> profiles(ExtensionContext context) {
        Method method = (Method)context.getTestMethod().orElseThrow(IllegalStateException::new);
        ArrayList profiles = new ArrayList(AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)method, MavenProfile.class));
        List allInstances = ((TestInstances)context.getTestInstances().orElseThrow(IllegalStateException::new)).getAllInstances();
        for (int i = allInstances.size() - 1; i >= 0; --i) {
            List repeatableAnnotations = AnnotationSupport.findRepeatableAnnotations(allInstances.get(i).getClass(), MavenProfile.class);
            profiles.addAll(repeatableAnnotations);
        }
        return profiles.stream().flatMap(profile -> Stream.of(profile.value())).collect(Collectors.toList());
    }

    static boolean hasGoals(ExtensionContext context) {
        return !AnnotationHelper.goals(context).isEmpty();
    }

    static List<String> goals(ExtensionContext context) {
        Method method = (Method)context.getTestMethod().orElseThrow(IllegalStateException::new);
        ArrayList goalAnnotations = new ArrayList(AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)method, MavenGoal.class));
        List allInstances = ((TestInstances)context.getTestInstances().orElseThrow(IllegalStateException::new)).getAllInstances();
        for (int i = allInstances.size() - 1; i >= 0; --i) {
            goalAnnotations.addAll(AnnotationSupport.findRepeatableAnnotations(allInstances.get(i).getClass(), MavenGoal.class));
        }
        return goalAnnotations.stream().flatMap(goal -> Stream.of(goal.value())).collect(Collectors.toList());
    }

    static boolean hasOptions(ExtensionContext context) {
        return !AnnotationHelper.options(context).isEmpty();
    }

    static List<String> options(ExtensionContext context) {
        Method method = (Method)context.getTestMethod().orElseThrow(IllegalStateException::new);
        ArrayList options = new ArrayList(AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)method, MavenOption.class));
        List allInstances = ((TestInstances)context.getTestInstances().orElseThrow(IllegalStateException::new)).getAllInstances();
        for (int i = allInstances.size() - 1; i >= 0; --i) {
            options.addAll(AnnotationSupport.findRepeatableAnnotations(allInstances.get(i).getClass(), MavenOption.class));
        }
        return options.stream().flatMap(option -> option.parameter().isEmpty() ? Stream.of(option.value()) : Stream.of(option.value(), option.parameter())).collect(Collectors.toList());
    }

    static boolean hasSystemProperties(ExtensionContext context) {
        return !AnnotationHelper.systemProperties(context).isEmpty();
    }

    private static Optional<Class<?>> findAnnotation(ExtensionContext context, Class<? extends Annotation> annotationClass) {
        Optional current = Optional.of(context);
        while (current.isPresent()) {
            Class testClass;
            Optional testClassNumber1 = current.get().getTestClass();
            if (testClassNumber1.isPresent() && (testClass = (Class)testClassNumber1.get()).isAnnotationPresent(annotationClass)) {
                return Optional.of(testClass);
            }
            current = current.get().getParent();
        }
        return Optional.empty();
    }

    static Optional<Class<?>> findMavenRepositoryAnnotation(ExtensionContext context) {
        return AnnotationHelper.findAnnotation(context, MavenRepository.class);
    }

    static Optional<Class<?>> findMavenProjectAnnotation(ExtensionContext context) {
        return AnnotationHelper.findAnnotation(context, MavenProject.class);
    }

    static Optional<MavenProjectSources> findMavenProjectSourcesAnnotation(ExtensionContext context) {
        Method method = (Method)context.getTestMethod().orElseThrow(IllegalStateException::new);
        boolean methodAnnotationPresent = method.isAnnotationPresent(MavenProjectSources.class);
        if (methodAnnotationPresent) {
            return Optional.of(method.getAnnotation(MavenProjectSources.class));
        }
        Optional<Class<?>> firstFinding = AnnotationHelper.findAnnotation(context, MavenProjectSources.class);
        if (firstFinding.isPresent()) {
            MavenProjectSources annotation = firstFinding.get().getAnnotation(MavenProjectSources.class);
            return Optional.of(annotation);
        }
        Optional mavenProjectLocationAnnotation = AnnotationSupport.findAnnotation((Optional)context.getTestClass(), MavenProjectSources.class);
        if (mavenProjectLocationAnnotation.isPresent()) {
            MavenProjectSources annotation = (MavenProjectSources)mavenProjectLocationAnnotation.get();
            return Optional.of(annotation);
        }
        return Optional.empty();
    }

    static List<SystemProperty> systemProperties(ExtensionContext context) {
        Method method = (Method)context.getTestMethod().orElseThrow(IllegalStateException::new);
        ArrayList<SystemProperty> properties = new ArrayList<SystemProperty>(AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)method, SystemProperty.class));
        List allInstances = ((TestInstances)context.getTestInstances().orElseThrow(IllegalStateException::new)).getAllInstances();
        for (int i = allInstances.size() - 1; i >= 0; --i) {
            properties.addAll(AnnotationSupport.findRepeatableAnnotations(allInstances.get(i).getClass(), SystemProperty.class));
        }
        return properties;
    }

    static Optional<Class<?>> findMavenPredefinedRepositoryAnnotation(ExtensionContext context) {
        return AnnotationHelper.findAnnotation(context, MavenPredefinedRepository.class);
    }

    static Optional<MavenProjectLocation> findMavenProjectLocationAnnotation(ExtensionContext context) {
        Method method = (Method)context.getTestMethod().orElseThrow(IllegalStateException::new);
        boolean methodAnnotationPresent = method.isAnnotationPresent(MavenProjectLocation.class);
        if (methodAnnotationPresent) {
            return Optional.of(method.getAnnotation(MavenProjectLocation.class));
        }
        Optional<Class<?>> mavenProjectLocationAnnotation = AnnotationHelper.findAnnotation(context, MavenProjectLocation.class);
        if (mavenProjectLocationAnnotation.isPresent()) {
            MavenProjectLocation annotation = mavenProjectLocationAnnotation.get().getAnnotation(MavenProjectLocation.class);
            return Optional.of(annotation);
        }
        return Optional.empty();
    }
}

