/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.extension;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="0.13.0")
public final class MavenVersionComparator
implements Comparable<MavenVersionComparator> {
    private static final int NOT_DEFINED = -1;
    private static final String NOT_DEFINE_QUALIFIER = "";
    private static final String NOT_DEFINED_STRING = "ND";
    private final int major;
    private final int minor;
    private final int patch;
    private final String qualifier;
    private final int qualifierNumber;
    private static final List<String> QUALIFIER_LIST = Arrays.asList("alpha", "beta", "rc");

    private MavenVersionComparator(int major, int minor, int patch, String qualifier, int qualifierNumber) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = Objects.requireNonNull(qualifier, "qualifier is not allowed to be null.");
        this.qualifierNumber = qualifierNumber;
    }

    public static MavenVersionComparator of() {
        return MavenVersionComparator.of(-1);
    }

    public static MavenVersionComparator of(int major) {
        return MavenVersionComparator.of(major, -1);
    }

    public static MavenVersionComparator of(int major, int minor) {
        return MavenVersionComparator.of(major, minor, -1);
    }

    public static MavenVersionComparator of(int major, int minor, int patch) {
        return MavenVersionComparator.of(major, minor, patch, NOT_DEFINE_QUALIFIER, -1);
    }

    public static MavenVersionComparator of(int major, int minor, int patch, String qualifier, int qualifierNumber) {
        return new MavenVersionComparator(major, minor, patch, qualifier, qualifierNumber);
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public int qualifierNumber() {
        return this.qualifierNumber;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MavenVersionComparator that = (MavenVersionComparator)obj;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && Objects.equals(this.qualifier, that.qualifier) && this.qualifierNumber == that.qualifierNumber;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.qualifier, this.qualifierNumber);
    }

    public String toString() {
        String q = this.qualifier.isEmpty() ? NOT_DEFINE_QUALIFIER : "-" + this.qualifier + "-" + this.qualifierNumber;
        String majorStr = this.major == -1 ? NOT_DEFINED_STRING : Integer.toString(this.major);
        String minorStr = this.minor == -1 ? NOT_DEFINED_STRING : Integer.toString(this.minor);
        String patchStrg = this.patch == -1 ? NOT_DEFINED_STRING : Integer.toString(this.patch);
        return "{" + majorStr + "." + minorStr + "." + patchStrg + q + "}";
    }

    @Override
    public int compareTo(MavenVersionComparator rhs) {
        if (this.major() == -1 || rhs.major() == -1) {
            return 0;
        }
        int majorComparison = Integer.compare(this.major(), rhs.major());
        if (majorComparison != 0) {
            return majorComparison;
        }
        if (this.minor() == -1 || rhs.minor() == -1) {
            return 0;
        }
        int minorComparison = Integer.compare(this.minor(), rhs.minor());
        if (minorComparison != 0) {
            return minorComparison;
        }
        if (this.patch() == -1 || rhs.patch() == -1) {
            return 0;
        }
        int patchComparison = Integer.compare(this.patch(), rhs.patch());
        if (patchComparison != 0) {
            return patchComparison;
        }
        boolean lhsContained = QUALIFIER_LIST.contains(this.qualifier());
        boolean rhsContained = QUALIFIER_LIST.contains(rhs.qualifier());
        if (lhsContained && rhsContained) {
            int qualifierComparison = Integer.compare(QUALIFIER_LIST.indexOf(this.qualifier()), QUALIFIER_LIST.indexOf(rhs.qualifier()));
            if (qualifierComparison != 0) {
                return qualifierComparison;
            }
            return Integer.compare(this.qualifierNumber(), rhs.qualifierNumber());
        }
        return lhsContained ? -1 : (rhsContained ? 1 : Boolean.compare(this.qualifier().isEmpty(), rhs.qualifier().isEmpty()));
    }
}

