/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.extension;

import com.soebes.itf.jupiter.extension.Preconditions;
import com.soebes.itf.jupiter.extension.StringInterpolator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class PropertiesFilter {
    private final Map<String, String> keyValues;
    private final List<String> items;

    public PropertiesFilter(Map<String, String> keyValues, List<String> items) {
        this.keyValues = Preconditions.requireNotNull(keyValues, "keyValues is not allowed to be null.");
        this.items = Preconditions.requireNotNull(items, "items not allowed to be null.");
    }

    List<String> filter() {
        return this.items.stream().map(StringInterpolator.interpolate(this.keyValues)).collect(Collectors.toList());
    }
}

