/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.extension;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

interface StringInterpolator {
    public static final Pattern PLACEHOLDER_PATTERN = Pattern.compile(Pattern.quote("${") + "(.*?)" + Pattern.quote("}"));

    public static Function<String, String> interpolate(Map<String, String> mapping) {
        Objects.requireNonNull(mapping, "mapping is not allowed to be null.");
        return s -> {
            Matcher matcher = PLACEHOLDER_PATTERN.matcher((CharSequence)s);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                if (!mapping.containsKey(matcher.group(1))) continue;
                String escaped = Matcher.quoteReplacement((String)mapping.get(matcher.group(1)));
                matcher.appendReplacement(sb, escaped);
            }
            matcher.appendTail(sb);
            return sb.toString();
        };
    }
}

