/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.extension.condition;

import com.soebes.itf.jupiter.extension.MavenVersion;
import com.soebes.itf.jupiter.extension.Preconditions;
import com.soebes.itf.jupiter.extension.condition.EnabledForMavenVersion;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

class EnabledForMavenVersionCondition
implements ExecutionCondition {
    static final ConditionEvaluationResult ENABLED_ON_CURRENT_MAVEN_VERSION = ConditionEvaluationResult.enabled((String)("Enabled on Maven version: " + System.getProperty("maven.version")));
    static final ConditionEvaluationResult DISABLED_ON_CURRENT_MAVEN_VERSION = ConditionEvaluationResult.disabled((String)("Disabled on Maven version: " + System.getProperty("maven.version")));
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@EnabledForMavenVersion is not present");

    EnabledForMavenVersionCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional optional = AnnotationSupport.findAnnotation((Optional)context.getElement(), EnabledForMavenVersion.class);
        if (optional.isPresent()) {
            MavenVersion[] versions = ((EnabledForMavenVersion)optional.get()).value();
            Preconditions.requireGreaterZero(versions, "You must declare at least one version in @EnabledForMavenVersion");
            return Stream.of(versions).anyMatch(MavenVersion::isCurrentVersion) ? ENABLED_ON_CURRENT_MAVEN_VERSION : DISABLED_ON_CURRENT_MAVEN_VERSION;
        }
        return ENABLED_BY_DEFAULT;
    }
}

