/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.mlv;

import com.soebes.maven.plugins.mlv.LicenseInformation;
import com.soebes.maven.plugins.mlv.filter.PatternExcludeFilter;
import com.soebes.maven.plugins.mlv.licenses.LicenseValidator;
import com.soebes.maven.plugins.mlv.licenses.LicensesFile;
import com.soebes.maven.plugins.mlv.model.LicensesContainer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLicenseVerifierPlugIn
extends AbstractMojo {
    protected MavenProject project;
    protected MavenProjectBuilder projectBuilder;
    protected ArtifactRepository localRepository;
    protected List<ArtifactRepository> remoteRepositories;
    private boolean verbose;
    private boolean stricktChecking;
    protected boolean failOnValid;
    protected boolean failOnInvalid;
    protected boolean failOnWarning;
    protected boolean failOnUnknown;
    protected File licenseFile;
    protected List<String> excludes;
    private ArrayList<LicenseInformation> licenseInformations = new ArrayList();
    private HashMap<String, LicenseInformation> licenseList = new HashMap();
    protected LicenseValidator licenseValidator = null;
    protected LicensesContainer licensesContainer = null;

    protected void getDependArtifacts(Set<?> set) throws MojoExecutionException {
        PatternExcludeFilter patternExcludeFilter = new PatternExcludeFilter();
        ArtifactFilter artifactFilter = patternExcludeFilter.createFilter(this.excludes);
        for (Artifact artifact : set) {
            if (!artifactFilter.include(artifact)) {
                if (!this.isVerbose()) continue;
                this.getLog().warn((CharSequence)("The artifact: " + artifact.getId() + " has been execluded by the configuration."));
                continue;
            }
            LicenseInformation licenseInformation = new LicenseInformation();
            licenseInformation.setArtifact(artifact);
            MavenProject mavenProject = null;
            try {
                mavenProject = this.projectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository, true);
            }
            catch (ProjectBuildingException projectBuildingException) {
                throw new MojoExecutionException("Unable to build project: " + artifact.getDependencyConflictId(), (Exception)((Object)projectBuildingException));
            }
            licenseInformation.setProject(mavenProject);
            List list = mavenProject.getLicenses();
            for (License license : list) {
                licenseInformation.addLicense(license);
            }
            this.licenseInformations.add(licenseInformation);
        }
    }

    public HashMap<String, LicenseInformation> getLicenseList() {
        return this.licenseList;
    }

    public ArrayList<LicenseInformation> getLicenseInformations() {
        return this.licenseInformations;
    }

    protected void loadLicensesFile() throws MojoExecutionException {
        if (this.licenseFile == null) {
            return;
        }
        try {
            this.getLog().debug((CharSequence)("Trying to find " + this.licenseFile.getAbsolutePath() + " in file system."));
            if (this.licenseFile.exists()) {
                this.getLog().debug((CharSequence)"Found licenses file in file system.");
                this.getLog().info((CharSequence)("Loading " + this.licenseFile.getAbsolutePath() + " licenses file."));
                this.licensesContainer = LicensesFile.getLicenses(this.licenseFile);
            } else {
                this.getLog().info((CharSequence)"Loading license file via classpath.");
                URL uRL = ((Object)((Object)this)).getClass().getResource(this.licenseFile.getPath());
                InputStream inputStream = null;
                if (uRL == null) {
                    inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/licenses/licenses.xml");
                    uRL = ((Object)((Object)this)).getClass().getResource("/licenses/licenses.xml");
                } else {
                    inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(this.licenseFile.getPath());
                    uRL = ((Object)((Object)this)).getClass().getResource(this.licenseFile.getPath());
                }
                this.getLog().debug((CharSequence)("Loading licenses.xml from " + uRL));
                this.licensesContainer = LicensesFile.getLicenses(inputStream);
            }
            this.licenseValidator = new LicenseValidator(this.licensesContainer);
            this.licenseValidator.setStrictChecking(this.stricktChecking);
        }
        catch (IOException iOException) {
            throw new MojoExecutionException("The LicenseFile configuration is wrong, cause we couldn't find the " + this.licenseFile.getAbsolutePath());
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new MojoExecutionException("The LicenseFile is wrong, cause we couldn't read it " + (Object)((Object)xmlPullParserException));
        }
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }
}

