/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.mlv;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.append(stringBuffer, "com.soebes.maven.plugins.mlv:maven-license-verifier-plugin:0.4", 0);
        this.append(stringBuffer, "", 0);
        this.append(stringBuffer, "Maven License Verifier Plugin", 0);
        this.append(stringBuffer, "The Maven License Verifier Plugin is intented to check the different artifacts of a project.", 1);
        this.append(stringBuffer, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(stringBuffer, "This plugin has 3 goals:", 0);
            this.append(stringBuffer, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(stringBuffer, "license-verifier:help", 0);
            this.append(stringBuffer, "Display help information on maven-license-verifier-plugin.\nCall\n\u00a0\u00a0mvn\u00a0license-verifier:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(stringBuffer, "", 0);
            if (this.detail) {
                this.append(stringBuffer, "Available parameters:", 1);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "detail (Default: false)", 2);
                this.append(stringBuffer, "If true, display all settable properties for each goal.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "goal", 2);
                this.append(stringBuffer, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "indentSize (Default: 2)", 2);
                this.append(stringBuffer, "The number of spaces per indentation level, should be positive.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "lineLength (Default: 80)", 2);
                this.append(stringBuffer, "The maximum length of a display line, should be positive.", 3);
                this.append(stringBuffer, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "report".equals(this.goal)) {
            this.append(stringBuffer, "license-verifier:report", 0);
            this.append(stringBuffer, "Generate a report about the license verifier report.", 1);
            this.append(stringBuffer, "", 0);
            if (this.detail) {
                this.append(stringBuffer, "Available parameters:", 1);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "excludes", 2);
                this.append(stringBuffer, "By using excludes you can exclude particular artifacts from being checked by the Maven Licenses Verifier Plugin.\n\u00a0\u00a0<excludes>\n\u00a0\u00a0\u00a0\u00a0\u00a0<exclude>groupId:artifactId:type:version</exclude>\n\u00a0\u00a0\u00a0\u00a0\u00a0..\n\u00a0\u00a0</excludes>\n", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "failOnInvalid (Default: false)", 2);
                this.append(stringBuffer, "The build will fail if a license with the category Invalid has been found.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "failOnUnknown (Default: false)", 2);
                this.append(stringBuffer, "The build will fail if a license can not be categorized in any of the categories.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "failOnValid (Default: false)", 2);
                this.append(stringBuffer, "The build will fail if a license with the category Valid has been found.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "failOnWarning (Default: false)", 2);
                this.append(stringBuffer, "The build will fail if a license with the category Warning has been found.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "licenseFile (Default: ${project.basedir}/src/licenses/licenses.xml)", 2);
                this.append(stringBuffer, "The name of the licenses.xml file which will be used to categorize the licenses of the artifacts.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "stricktChecking (Default: false)", 2);
                this.append(stringBuffer, "This will turn on strictChecking behavior which will check URL and Name of a license instead of only URL or Name.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "verbose (Default: false)", 2);
                this.append(stringBuffer, "This will turn on verbose behavior and will print out all information about the artifacts.", 3);
                this.append(stringBuffer, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "verify".equals(this.goal)) {
            this.append(stringBuffer, "license-verifier:verify", 0);
            this.append(stringBuffer, "This goal is intended to check the artifacts during the prepare-package phase and print out warnings etc. based on the given configuration for the plugin.", 1);
            this.append(stringBuffer, "", 0);
            if (this.detail) {
                this.append(stringBuffer, "Available parameters:", 1);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "excludes", 2);
                this.append(stringBuffer, "By using excludes you can exclude particular artifacts from being checked by the Maven Licenses Verifier Plugin.\n\u00a0\u00a0<excludes>\n\u00a0\u00a0\u00a0\u00a0\u00a0<exclude>groupId:artifactId:type:version</exclude>\n\u00a0\u00a0\u00a0\u00a0\u00a0..\n\u00a0\u00a0</excludes>\n", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "failOnInvalid (Default: false)", 2);
                this.append(stringBuffer, "The build will fail if a license with the category Invalid has been found.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "failOnUnknown (Default: false)", 2);
                this.append(stringBuffer, "The build will fail if a license can not be categorized in any of the categories.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "failOnValid (Default: false)", 2);
                this.append(stringBuffer, "The build will fail if a license with the category Valid has been found.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "failOnWarning (Default: false)", 2);
                this.append(stringBuffer, "The build will fail if a license with the category Warning has been found.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "licenseFile (Default: ${project.basedir}/src/licenses/licenses.xml)", 2);
                this.append(stringBuffer, "The name of the licenses.xml file which will be used to categorize the licenses of the artifacts.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "stricktChecking (Default: false)", 2);
                this.append(stringBuffer, "This will turn on strictChecking behavior which will check URL and Name of a license instead of only URL or Name.", 3);
                this.append(stringBuffer, "", 0);
                this.append(stringBuffer, "verbose (Default: false)", 2);
                this.append(stringBuffer, "This will turn on verbose behavior and will print out all information about the artifacts.", 3);
                this.append(stringBuffer, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)stringBuffer.toString());
        }
    }

    private static String repeat(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(n * string.length());
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void append(StringBuffer stringBuffer, String string, int n) {
        Iterator iterator = HelpMojo.toLines(string, n, this.indentSize, this.lineLength).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString()).append('\n');
        }
    }

    private static List toLines(String string, int n, int n2, int n3) {
        ArrayList arrayList = new ArrayList();
        String string2 = HelpMojo.repeat("\t", n);
        String[] stringArray = string.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < stringArray.length; ++i) {
            HelpMojo.toLines(arrayList, string2 + stringArray[i], n2, n3);
        }
        return arrayList;
    }

    private static void toLines(List list, String string, int n, int n2) {
        int n3 = HelpMojo.getIndentLevel(string);
        StringBuffer stringBuffer = new StringBuffer(256);
        String[] stringArray = string.split(" +");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (i > 0) {
                if (stringBuffer.length() + string2.length() >= n2) {
                    list.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    stringBuffer.append(HelpMojo.repeat(" ", n3 * n));
                } else {
                    stringBuffer.append(' ');
                }
            }
            for (int j = 0; j < string2.length(); ++j) {
                char c = string2.charAt(j);
                if (c == '\t') {
                    stringBuffer.append(HelpMojo.repeat(" ", n - stringBuffer.length() % n));
                    continue;
                }
                if (c == '\u00a0') {
                    stringBuffer.append(' ');
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        list.add(stringBuffer.toString());
    }

    private static int getIndentLevel(String string) {
        int n;
        int n2 = 0;
        for (n = 0; n < string.length() && string.charAt(n) == '\t'; ++n) {
            ++n2;
        }
        for (n = n2 + 1; n <= n2 + 4 && n < string.length(); ++n) {
            if (string.charAt(n) != '\t') continue;
            ++n2;
            break;
        }
        return n2;
    }
}

