/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.mlv;

import com.soebes.maven.plugins.mlv.AbstractLicenseVerifierPlugIn;
import com.soebes.maven.plugins.mlv.ArtifactComperator;
import com.soebes.maven.plugins.mlv.LicenseInformation;
import com.soebes.maven.plugins.mlv.model.LicenseItem;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.model.License;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseVerifierReport
extends AbstractLicenseVerifierPlugIn
implements MavenReport {
    private File outputDirectory;
    private File reportOutputDirectory;

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            this.getLog().info((CharSequence)"LicenseVerifierReport:executeReport()");
            RenderingContext renderingContext = new RenderingContext(this.getOutputDirectory(), this.getOutputName() + ".html");
            SiteRendererSink siteRendererSink = new SiteRendererSink(renderingContext);
            this.generate((Sink)siteRendererSink, locale);
        }
        catch (MavenReportException mavenReportException) {
            this.getLog().error((CharSequence)("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation:" + mavenReportException.getMessage()), (Throwable)mavenReportException);
        }
        catch (RuntimeException runtimeException) {
            this.getLog().error((CharSequence)runtimeException.getMessage(), (Throwable)runtimeException);
        }
    }

    protected File getOutputDirectory() {
        if (!this.outputDirectory.isAbsolute()) {
            this.outputDirectory = new File(this.project.getBasedir(), this.outputDirectory.getPath());
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return this.outputDirectory.getAbsoluteFile();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getDescription(Locale locale) {
        return "Generated License Verifier Report";
    }

    public String getName(Locale locale) {
        return "License Verifier Report";
    }

    public String getOutputName() {
        return "licenseverifierreport";
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("mlvp", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void doGenerateEmptyReport(ResourceBundle resourceBundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(resourceBundle.getString("report.mlvp.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(resourceBundle.getString("report.mlvp.mainTitle"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text("No artifacts found to create and licesen verifier report.");
        sink.paragraph_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void doGenerateReport(ResourceBundle resourceBundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(resourceBundle.getString("report.mlvp.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        this.doGenerateLicenseCategories(resourceBundle, sink);
        sink.section1_();
        sink.section1();
        this.doGenerateItemReport(resourceBundle, sink);
        sink.section1_();
        if (this.hasScope("compile")) {
            sink.section1();
            this.doGenerateArtifactCategories(resourceBundle, sink, "compile");
            sink.section1_();
        }
        if (this.hasScope("test")) {
            sink.section1();
            this.doGenerateArtifactCategories(resourceBundle, sink, "test");
            sink.section1_();
        }
        if (this.hasScope("provided")) {
            sink.section1();
            this.doGenerateArtifactCategories(resourceBundle, sink, "provided");
            sink.section1_();
        }
        if (this.hasScope("runtime")) {
            sink.section1();
            this.doGenerateArtifactCategories(resourceBundle, sink, "runtime");
            sink.section1_();
        }
        sink.body_();
        sink.flush();
        sink.close();
    }

    private boolean hasScope(String string) {
        boolean bl = false;
        for (LicenseInformation licenseInformation : this.getLicenseInformations()) {
            if (!string.equals(licenseInformation.getArtifact().getScope())) continue;
            bl = true;
        }
        return bl;
    }

    private boolean hasValidEntries(String string) {
        boolean bl = false;
        for (LicenseInformation licenseInformation : this.getLicenseInformations()) {
            if (!string.equals(licenseInformation.getArtifact().getScope()) || !this.licenseValidator.isValid(licenseInformation.getLicenses())) continue;
            bl = true;
        }
        return bl;
    }

    private boolean hasInvalidEntries(String string) {
        boolean bl = false;
        for (LicenseInformation licenseInformation : this.getLicenseInformations()) {
            if (!string.equals(licenseInformation.getArtifact().getScope()) || !this.licenseValidator.isInvalid(licenseInformation.getLicenses())) continue;
            bl = true;
        }
        return bl;
    }

    private boolean hasWarningEntries(String string) {
        boolean bl = false;
        for (LicenseInformation licenseInformation : this.getLicenseInformations()) {
            if (!string.equals(licenseInformation.getArtifact().getScope()) || !this.licenseValidator.isWarning(licenseInformation.getLicenses())) continue;
            bl = true;
        }
        return bl;
    }

    private boolean hasUnknownEntries(String string) {
        boolean bl = false;
        for (LicenseInformation licenseInformation : this.getLicenseInformations()) {
            if (!string.equals(licenseInformation.getArtifact().getScope()) || !this.licenseValidator.isUnknown(licenseInformation.getLicenses())) continue;
            bl = true;
        }
        return bl;
    }

    private void doGenerateLicenseCategories(ResourceBundle resourceBundle, Sink sink) {
        sink.sectionTitle1();
        sink.text("License Categories (Configured)");
        sink.sectionTitle1_();
        this.doGenerateReportLicensesConfiguration(resourceBundle, sink, "Valid", this.licenseValidator.getValid());
        this.doGenerateReportLicensesConfiguration(resourceBundle, sink, "Warning", this.licenseValidator.getWarning());
        this.doGenerateReportLicensesConfiguration(resourceBundle, sink, "Invalid", this.licenseValidator.getInvalid());
    }

    private void doGenerateArtifactCategories(ResourceBundle resourceBundle, Sink sink, String string) {
        sink.sectionTitle1();
        sink.text("Artifact Categories (" + string + ")");
        sink.sectionTitle1_();
        if (this.hasValidEntries(string)) {
            this.doGenerateValidReport(resourceBundle, sink, string);
        }
        if (this.hasWarningEntries(string)) {
            this.doGenerateWarningReport(resourceBundle, sink, string);
        }
        if (this.hasInvalidEntries(string)) {
            this.doGenerateInvalidReport(resourceBundle, sink, string);
        }
        if (this.hasUnknownEntries(string)) {
            this.doGenerateUnknownReport(resourceBundle, sink, string);
        }
    }

    private void doGenerateReportLicensesConfiguration(ResourceBundle resourceBundle, Sink sink, String string, List<LicenseItem> list) {
        sink.sectionTitle2();
        sink.text(string);
        sink.sectionTitle2_();
        sink.table();
        sink.tableRow();
        this.headerCell(sink, "Id");
        this.headerCell(sink, "Description");
        this.headerCell(sink, "Names");
        this.headerCell(sink, "URL's");
        sink.tableRow_();
        for (LicenseItem licenseItem : list) {
            sink.tableRow();
            this.cell(sink, licenseItem.getId());
            this.cell(sink, licenseItem.getDescription());
            sink.tableCell();
            sink.list();
            for (String string2 : licenseItem.getNames()) {
                sink.listItem();
                sink.text(string2);
                sink.listItem_();
            }
            sink.list_();
            sink.tableCell_();
            sink.tableCell();
            sink.list();
            for (String string2 : licenseItem.getUrls()) {
                sink.listItem();
                sink.link(string2);
                sink.text(string2);
                sink.link_();
                sink.listItem_();
            }
            sink.list_();
            sink.tableCell_();
            sink.tableRow_();
        }
        sink.table_();
    }

    private void createEmptyCell(Sink sink) {
        sink.tableCell();
        sink.tableCell_();
    }

    private void createFigure(Sink sink, boolean bl) {
        sink.tableCell();
        sink.figure();
        if (bl) {
            sink.figureGraphics("images/icon_success_sml.gif");
        } else {
            sink.figureGraphics("images/icon_warning_sml.gif");
        }
        sink.figure_();
        sink.tableCell_();
    }

    private void doGenerateItemReport(ResourceBundle resourceBundle, Sink sink) {
        sink.sectionTitle1();
        sink.text("Artifact License Categories");
        sink.sectionTitle1_();
        sink.sectionTitle2();
        sink.text("Overview");
        sink.sectionTitle2_();
        sink.table();
        sink.tableRow();
        this.headerCell(sink, "Id");
        this.headerCell(sink, "Scope");
        this.headerCell(sink, "Valid");
        this.headerCell(sink, "Warning");
        this.headerCell(sink, "Invalid");
        this.headerCell(sink, "Unknown");
        sink.tableRow_();
        for (LicenseInformation licenseInformation : this.getLicenseInformations()) {
            sink.tableRow();
            this.cell(sink, licenseInformation.getArtifact().getId());
            boolean bl = this.licenseValidator.isValid(licenseInformation.getLicenses());
            boolean bl2 = this.licenseValidator.isWarning(licenseInformation.getLicenses());
            boolean bl3 = this.licenseValidator.isInvalid(licenseInformation.getLicenses());
            boolean bl4 = this.licenseValidator.isUnknown(licenseInformation.getLicenses());
            sink.tableCell();
            sink.text(licenseInformation.getArtifact().getScope());
            sink.tableCell_();
            this.createFigure(sink, bl);
            if (bl2) {
                this.createFigure(sink, false);
            } else {
                this.createEmptyCell(sink);
            }
            if (bl3) {
                this.createFigure(sink, false);
            } else {
                this.createEmptyCell(sink);
            }
            if (bl4) {
                this.createFigure(sink, false);
            } else {
                this.createEmptyCell(sink);
            }
            sink.tableRow_();
        }
        sink.table_();
    }

    private void doGenerateValidReport(ResourceBundle resourceBundle, Sink sink, String string) {
        sink.sectionTitle2();
        sink.text("Artifacts Catagorized as Valid");
        sink.sectionTitle2_();
        sink.table();
        sink.tableRow();
        this.headerCell(sink, "Id");
        this.headerCell(sink, "Scope");
        this.headerCell(sink, "Name");
        this.headerCell(sink, "URL");
        sink.tableRow_();
        for (LicenseInformation licenseInformation : this.getLicenseInformations()) {
            if (!string.equals(licenseInformation.getArtifact().getScope()) || !this.licenseValidator.isValid(licenseInformation.getLicenses())) continue;
            sink.tableRow();
            this.cell(sink, licenseInformation.getArtifact().getId());
            sink.tableCell();
            sink.text(licenseInformation.getArtifact().getScope());
            sink.tableCell_();
            if (licenseInformation.getLicenses().isEmpty()) {
                this.cell(sink, "");
                this.cell(sink, "");
            } else {
                for (License license : licenseInformation.getLicenses()) {
                    this.cell(sink, license.getName());
                    this.cell(sink, license.getUrl());
                }
            }
            sink.tableRow_();
        }
        sink.table_();
    }

    private void doGenerateWarningReport(ResourceBundle resourceBundle, Sink sink, String string) {
        sink.sectionTitle2();
        sink.text("Artifacts Catagorized as Warning");
        sink.sectionTitle2_();
        sink.table();
        sink.tableRow();
        this.headerCell(sink, "Id");
        this.headerCell(sink, "Scope");
        this.headerCell(sink, "Name");
        this.headerCell(sink, "URL");
        sink.tableRow_();
        for (LicenseInformation licenseInformation : this.getLicenseInformations()) {
            if (!string.equals(licenseInformation.getArtifact().getScope()) || !this.licenseValidator.isWarning(licenseInformation.getLicenses())) continue;
            sink.tableRow();
            this.cell(sink, licenseInformation.getArtifact().getId());
            sink.tableCell();
            sink.text(licenseInformation.getArtifact().getScope());
            sink.tableCell_();
            if (licenseInformation.getLicenses().isEmpty()) {
                this.cell(sink, "");
                this.cell(sink, "");
            } else {
                for (License license : licenseInformation.getLicenses()) {
                    this.cell(sink, license.getName());
                    this.cell(sink, license.getUrl());
                }
            }
            sink.tableRow_();
        }
        sink.table_();
    }

    private void doGenerateInvalidReport(ResourceBundle resourceBundle, Sink sink, String string) {
        sink.sectionTitle2();
        sink.text("Artifacts Catagorized as Invalid");
        sink.sectionTitle2_();
        sink.table();
        sink.tableRow();
        this.headerCell(sink, "Id");
        this.headerCell(sink, "Scope");
        this.headerCell(sink, "Name");
        this.headerCell(sink, "URL");
        sink.tableRow_();
        for (LicenseInformation licenseInformation : this.getLicenseInformations()) {
            if (!string.equals(licenseInformation.getArtifact().getScope()) || !this.licenseValidator.isInvalid(licenseInformation.getLicenses())) continue;
            sink.tableRow();
            this.cell(sink, licenseInformation.getArtifact().getId());
            sink.tableCell();
            sink.text(licenseInformation.getArtifact().getScope());
            sink.tableCell_();
            if (licenseInformation.getLicenses().isEmpty()) {
                this.cell(sink, "");
                this.cell(sink, "");
            } else {
                for (License license : licenseInformation.getLicenses()) {
                    this.cell(sink, license.getName());
                    this.cell(sink, license.getUrl());
                }
            }
            sink.tableRow_();
        }
        sink.table_();
    }

    private void doGenerateUnknownReport(ResourceBundle resourceBundle, Sink sink, String string) {
        sink.sectionTitle2();
        sink.text("Artifacts Catagorized as Unknown");
        sink.sectionTitle2_();
        sink.table();
        sink.tableRow();
        this.headerCell(sink, "Id");
        this.headerCell(sink, "Scope");
        this.headerCell(sink, "Name");
        this.headerCell(sink, "URL");
        sink.tableRow_();
        for (LicenseInformation licenseInformation : this.getLicenseInformations()) {
            if (!string.equals(licenseInformation.getArtifact().getScope()) || !this.licenseValidator.isUnknown(licenseInformation.getLicenses())) continue;
            sink.tableRow();
            this.cell(sink, licenseInformation.getArtifact().getId());
            sink.tableCell();
            sink.text(licenseInformation.getArtifact().getScope());
            sink.tableCell_();
            if (licenseInformation.getLicenses().isEmpty()) {
                this.cell(sink, "");
                this.cell(sink, "");
            } else {
                for (License license : licenseInformation.getLicenses()) {
                    this.cell(sink, license.getName());
                    this.cell(sink, license.getUrl());
                }
            }
            sink.tableRow_();
        }
        sink.table_();
    }

    private void headerCell(Sink sink, String string) {
        sink.tableHeaderCell();
        sink.text(string);
        sink.tableHeaderCell_();
    }

    private void cell(Sink sink, String string) {
        sink.tableCell();
        sink.text(string);
        sink.tableCell_();
    }

    public void setProject(MavenProject mavenProject) {
        this.project = mavenProject;
    }

    public void setOutputDirectory(File file) {
        this.outputDirectory = file;
    }

    public boolean canGenerateReport() {
        return true;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.getLog().info((CharSequence)"LicenseVerifierReport:generate()");
        if (this.project.getArtifacts().isEmpty()) {
            this.doGenerateEmptyReport(this.getBundle(locale), sink);
        } else {
            try {
                this.loadLicensesFile();
            }
            catch (MojoExecutionException mojoExecutionException) {
                throw new MavenReportException("Failure during load of the license.xml file", (Exception)((Object)mojoExecutionException));
            }
            Set set = this.project.getArtifacts();
            try {
                this.getDependArtifacts(set);
                Collections.sort(this.getLicenseInformations(), new ArtifactComperator());
                this.doGenerateReport(this.getBundle(locale), sink);
            }
            catch (MojoExecutionException mojoExecutionException) {
                this.getLog().error((CharSequence)"Something wrong (BETTER MESSAGE): ", (Throwable)mojoExecutionException);
            }
        }
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public boolean isExternalReport() {
        return false;
    }

    public void setReportOutputDirectory(File file) {
        this.reportOutputDirectory = file;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)"LicenseVerifierReport:execute()");
            RenderingContext renderingContext = new RenderingContext(this.getOutputDirectory(), this.getOutputName() + ".html");
            SiteRendererSink siteRendererSink = new SiteRendererSink(renderingContext);
            Locale locale = Locale.getDefault();
            this.generate((Sink)siteRendererSink, locale);
        }
        catch (MavenReportException mavenReportException) {
            this.getLog().error((CharSequence)("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation:" + mavenReportException.getMessage()), (Throwable)mavenReportException);
        }
        catch (RuntimeException runtimeException) {
            this.getLog().error((CharSequence)runtimeException.getMessage(), (Throwable)runtimeException);
        }
    }
}

