/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.mlv.licenses;

import com.soebes.maven.plugins.mlv.model.LicenseItem;
import com.soebes.maven.plugins.mlv.model.LicensesContainer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.License;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseValidator {
    private final LicensesContainer licensesContainer;
    private boolean strictChecking = false;

    public LicenseValidator(LicensesContainer licensesContainer) {
        this.licensesContainer = licensesContainer;
    }

    public List<LicenseItem> getValid() {
        if (this.licensesContainer.getValid() == null) {
            return new ArrayList<LicenseItem>();
        }
        return this.licensesContainer.getValid().getLicenses();
    }

    public void setValid(List<LicenseItem> list) {
        this.licensesContainer.getInvalid().setLicenses(list);
    }

    public List<LicenseItem> getInvalid() {
        if (this.licensesContainer.getInvalid() == null) {
            return new ArrayList<LicenseItem>();
        }
        return this.licensesContainer.getInvalid().getLicenses();
    }

    public void setInvalid(ArrayList<LicenseItem> arrayList) {
        this.licensesContainer.getInvalid().setLicenses(arrayList);
    }

    public List<LicenseItem> getWarning() {
        if (this.licensesContainer.getWarning() == null) {
            return new ArrayList<LicenseItem>();
        }
        return this.licensesContainer.getWarning().getLicenses();
    }

    public void setWarning(ArrayList<LicenseItem> arrayList) {
        this.licensesContainer.getWarning().setLicenses(arrayList);
    }

    private boolean checkNamesAndURLs(LicenseItem licenseItem, License license) {
        boolean bl = false;
        if (this.checkNames(licenseItem, license) && this.checkUrls(licenseItem, license)) {
            bl = true;
        }
        return bl;
    }

    private boolean checkNamesOrURLs(LicenseItem licenseItem, License license) {
        boolean bl = false;
        if (this.checkNames(licenseItem, license)) {
            bl = true;
        }
        if (this.checkUrls(licenseItem, license)) {
            bl = true;
        }
        return bl;
    }

    private boolean check(List<LicenseItem> list, License license) {
        boolean bl = false;
        for (LicenseItem licenseItem : list) {
            if (this.isStrictChecking()) {
                if (!this.checkNamesAndURLs(licenseItem, license)) continue;
                bl = true;
                continue;
            }
            if (!this.checkNamesOrURLs(licenseItem, license)) continue;
            bl = true;
        }
        return bl;
    }

    private String checkId(List<LicenseItem> list, License license) {
        String string = null;
        for (LicenseItem licenseItem : list) {
            if (this.isStrictChecking()) {
                if (!this.checkNamesAndURLs(licenseItem, license)) continue;
                string = licenseItem.getId();
                continue;
            }
            if (!this.checkNamesOrURLs(licenseItem, license)) continue;
            string = licenseItem.getId();
        }
        return string;
    }

    public boolean isValid(License license) {
        return this.check(this.getValid(), license);
    }

    public String getValidId(License license) {
        return this.checkId(this.getValid(), license);
    }

    public boolean isValid(ArrayList<License> arrayList) {
        boolean bl = true;
        if (arrayList.isEmpty()) {
            bl = false;
        } else {
            for (License license : arrayList) {
                if (this.isValid(license)) continue;
                bl = false;
            }
        }
        return bl;
    }

    public ArrayList<String> getValidIds(ArrayList<License> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (arrayList.isEmpty()) {
            return arrayList2;
        }
        for (License license : arrayList) {
            String string = this.getValidId(license);
            if (string == null || arrayList2.contains(string)) continue;
            arrayList2.add(string);
        }
        return arrayList2;
    }

    public ArrayList<String> getInvalidIds(ArrayList<License> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (arrayList.isEmpty()) {
            return arrayList2;
        }
        for (License license : arrayList) {
            String string = this.getInvalidId(license);
            if (string == null || arrayList2.contains(string)) continue;
            arrayList2.add(string);
        }
        return arrayList2;
    }

    public ArrayList<String> getWarningIds(ArrayList<License> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (arrayList.isEmpty()) {
            return arrayList2;
        }
        for (License license : arrayList) {
            String string = this.getWarningId(license);
            if (string == null || arrayList2.contains(string)) continue;
            arrayList2.add(string);
        }
        return arrayList2;
    }

    public boolean isInvalid(ArrayList<License> arrayList) {
        boolean bl = true;
        if (arrayList.isEmpty()) {
            bl = false;
        } else {
            for (License license : arrayList) {
                if (this.isInvalid(license)) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isWarning(ArrayList<License> arrayList) {
        boolean bl = true;
        if (arrayList.isEmpty()) {
            bl = false;
        } else {
            for (License license : arrayList) {
                if (this.isWarning(license)) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean isUnknown(ArrayList<License> arrayList) {
        boolean bl = false;
        if (arrayList.isEmpty()) {
            bl = true;
        } else {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (License license : arrayList) {
                if (this.isValid(license)) {
                    ++n;
                }
                if (this.isInvalid(license)) {
                    ++n2;
                }
                if (!this.isWarning(license)) continue;
                ++n3;
            }
            bl = n == arrayList.size() ? false : (n2 == arrayList.size() ? false : n3 != arrayList.size());
        }
        return bl;
    }

    public boolean isUnknown(License license) {
        boolean bl = true;
        if (this.isValid(license)) {
            bl = false;
        } else if (this.isInvalid(license)) {
            bl = false;
        } else if (this.isWarning(license)) {
            bl = false;
        }
        return bl;
    }

    public boolean isInvalid(License license) {
        return this.check(this.getInvalid(), license);
    }

    public String getInvalidId(License license) {
        return this.checkId(this.getInvalid(), license);
    }

    public boolean isWarning(License license) {
        return this.check(this.getWarning(), license);
    }

    public String getWarningId(License license) {
        return this.checkId(this.getWarning(), license);
    }

    private boolean checkUrls(LicenseItem licenseItem, License license) {
        boolean bl = false;
        for (String string : licenseItem.getUrls()) {
            if (!string.equals(license.getUrl())) continue;
            bl = true;
        }
        return bl;
    }

    private boolean checkNames(LicenseItem licenseItem, License license) {
        boolean bl = false;
        for (String string : licenseItem.getNames()) {
            if (!string.equals(license.getName())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isCategory(ArrayList<License> arrayList, Category category) {
        boolean bl = false;
        switch (category) {
            case INVALID: {
                bl = this.isInvalid(arrayList);
                break;
            }
            case VALID: {
                bl = this.isValid(arrayList);
                break;
            }
            case UNKNOWN: {
                bl = this.isUnknown(arrayList);
                break;
            }
            case WARNING: {
                bl = this.isWarning(arrayList);
            }
        }
        return bl;
    }

    public void setStrictChecking(boolean bl) {
        this.strictChecking = bl;
    }

    public boolean isStrictChecking() {
        return this.strictChecking;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category {
        VALID,
        INVALID,
        WARNING,
        UNKNOWN;

    }
}

