/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.mlv.model.io.xpp3;

import com.soebes.maven.plugins.mlv.model.LicenseItem;
import com.soebes.maven.plugins.mlv.model.LicensesContainer;
import com.soebes.maven.plugins.mlv.model.LicensesList;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class LicensesXpp3Reader {
    private boolean addDefaultEntities = true;

    private boolean checkFieldWithDuplicate(XmlPullParser xmlPullParser, String string, String string2, Set set) throws XmlPullParserException {
        if (!xmlPullParser.getName().equals(string) && !xmlPullParser.getName().equals(string2)) {
            return false;
        }
        if (!set.add(string)) {
            throw new XmlPullParserException("Duplicated tag: '" + string + "'", xmlPullParser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser xmlPullParser, String string, String string2, boolean bl) throws XmlPullParserException, IOException {
        if (bl) {
            throw new XmlPullParserException("Unknown attribute '" + string + "' for tag '" + string2 + "'", xmlPullParser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser xmlPullParser, boolean bl) throws XmlPullParserException, IOException {
        if (bl) {
            throw new XmlPullParserException("Unrecognised tag: '" + xmlPullParser.getName() + "'", xmlPullParser, null);
        }
        int n = 1;
        while (n > 0) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                ++n;
                continue;
            }
            if (n2 != 3) continue;
            --n;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String string, String string2, XmlPullParser xmlPullParser) throws XmlPullParserException {
        return this.getBooleanValue(string, string2, xmlPullParser, null);
    }

    private boolean getBooleanValue(String string, String string2, XmlPullParser xmlPullParser, String string3) throws XmlPullParserException {
        if (string != null && string.length() != 0) {
            return Boolean.valueOf(string);
        }
        if (string3 != null) {
            return Boolean.valueOf(string3);
        }
        return false;
    }

    private byte getByteValue(String string, String string2, XmlPullParser xmlPullParser, boolean bl) throws XmlPullParserException {
        block3: {
            if (string != null) {
                try {
                    return Byte.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!bl) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + string2 + "', must be a byte", xmlPullParser, (Throwable)numberFormatException);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String string, String string2, XmlPullParser xmlPullParser) throws XmlPullParserException {
        if (string != null) {
            return string.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String string, String string2, XmlPullParser xmlPullParser) throws XmlPullParserException {
        return this.getDateValue(string, string2, null, xmlPullParser);
    }

    private Date getDateValue(String string, String string2, String string3, XmlPullParser xmlPullParser) throws XmlPullParserException {
        if (string != null) {
            String string4 = string3;
            if (string3 == null) {
                string4 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(string4)) {
                try {
                    return new Date(Long.parseLong(string));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XmlPullParserException(numberFormatException.getMessage(), xmlPullParser, (Throwable)numberFormatException);
                }
            }
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string4, Locale.US);
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                throw new XmlPullParserException(parseException.getMessage(), xmlPullParser, (Throwable)parseException);
            }
        }
        return null;
    }

    private double getDoubleValue(String string, String string2, XmlPullParser xmlPullParser, boolean bl) throws XmlPullParserException {
        block3: {
            if (string != null) {
                try {
                    return Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!bl) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + string2 + "', must be a floating point number", xmlPullParser, (Throwable)numberFormatException);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String string, String string2, XmlPullParser xmlPullParser, boolean bl) throws XmlPullParserException {
        block3: {
            if (string != null) {
                try {
                    return Float.valueOf(string).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    if (!bl) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + string2 + "', must be a floating point number", xmlPullParser, (Throwable)numberFormatException);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String string, String string2, XmlPullParser xmlPullParser, boolean bl) throws XmlPullParserException {
        block3: {
            if (string != null) {
                try {
                    return Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!bl) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + string2 + "', must be an integer", xmlPullParser, (Throwable)numberFormatException);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String string, String string2, XmlPullParser xmlPullParser, boolean bl) throws XmlPullParserException {
        block3: {
            if (string != null) {
                try {
                    return Long.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!bl) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + string2 + "', must be a long integer", xmlPullParser, (Throwable)numberFormatException);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String string, String string2, XmlPullParser xmlPullParser, boolean bl) throws XmlPullParserException {
        if (string == null && bl) {
            throw new XmlPullParserException("Missing required value for attribute '" + string2 + "'", xmlPullParser, null);
        }
        return string;
    }

    private short getShortValue(String string, String string2, XmlPullParser xmlPullParser, boolean bl) throws XmlPullParserException {
        block3: {
            if (string != null) {
                try {
                    return Short.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!bl) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + string2 + "', must be a short integer", xmlPullParser, (Throwable)numberFormatException);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String string) {
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    private void initParser(XmlPullParser xmlPullParser) throws XmlPullParserException {
        if (this.addDefaultEntities) {
            xmlPullParser.defineEntityReplacementText("nbsp", "\u00a0");
            xmlPullParser.defineEntityReplacementText("iexcl", "\u00a1");
            xmlPullParser.defineEntityReplacementText("cent", "\u00a2");
            xmlPullParser.defineEntityReplacementText("pound", "\u00a3");
            xmlPullParser.defineEntityReplacementText("curren", "\u00a4");
            xmlPullParser.defineEntityReplacementText("yen", "\u00a5");
            xmlPullParser.defineEntityReplacementText("brvbar", "\u00a6");
            xmlPullParser.defineEntityReplacementText("sect", "\u00a7");
            xmlPullParser.defineEntityReplacementText("uml", "\u00a8");
            xmlPullParser.defineEntityReplacementText("copy", "\u00a9");
            xmlPullParser.defineEntityReplacementText("ordf", "\u00aa");
            xmlPullParser.defineEntityReplacementText("laquo", "\u00ab");
            xmlPullParser.defineEntityReplacementText("not", "\u00ac");
            xmlPullParser.defineEntityReplacementText("shy", "\u00ad");
            xmlPullParser.defineEntityReplacementText("reg", "\u00ae");
            xmlPullParser.defineEntityReplacementText("macr", "\u00af");
            xmlPullParser.defineEntityReplacementText("deg", "\u00b0");
            xmlPullParser.defineEntityReplacementText("plusmn", "\u00b1");
            xmlPullParser.defineEntityReplacementText("sup2", "\u00b2");
            xmlPullParser.defineEntityReplacementText("sup3", "\u00b3");
            xmlPullParser.defineEntityReplacementText("acute", "\u00b4");
            xmlPullParser.defineEntityReplacementText("micro", "\u00b5");
            xmlPullParser.defineEntityReplacementText("para", "\u00b6");
            xmlPullParser.defineEntityReplacementText("middot", "\u00b7");
            xmlPullParser.defineEntityReplacementText("cedil", "\u00b8");
            xmlPullParser.defineEntityReplacementText("sup1", "\u00b9");
            xmlPullParser.defineEntityReplacementText("ordm", "\u00ba");
            xmlPullParser.defineEntityReplacementText("raquo", "\u00bb");
            xmlPullParser.defineEntityReplacementText("frac14", "\u00bc");
            xmlPullParser.defineEntityReplacementText("frac12", "\u00bd");
            xmlPullParser.defineEntityReplacementText("frac34", "\u00be");
            xmlPullParser.defineEntityReplacementText("iquest", "\u00bf");
            xmlPullParser.defineEntityReplacementText("Agrave", "\u00c0");
            xmlPullParser.defineEntityReplacementText("Aacute", "\u00c1");
            xmlPullParser.defineEntityReplacementText("Acirc", "\u00c2");
            xmlPullParser.defineEntityReplacementText("Atilde", "\u00c3");
            xmlPullParser.defineEntityReplacementText("Auml", "\u00c4");
            xmlPullParser.defineEntityReplacementText("Aring", "\u00c5");
            xmlPullParser.defineEntityReplacementText("AElig", "\u00c6");
            xmlPullParser.defineEntityReplacementText("Ccedil", "\u00c7");
            xmlPullParser.defineEntityReplacementText("Egrave", "\u00c8");
            xmlPullParser.defineEntityReplacementText("Eacute", "\u00c9");
            xmlPullParser.defineEntityReplacementText("Ecirc", "\u00ca");
            xmlPullParser.defineEntityReplacementText("Euml", "\u00cb");
            xmlPullParser.defineEntityReplacementText("Igrave", "\u00cc");
            xmlPullParser.defineEntityReplacementText("Iacute", "\u00cd");
            xmlPullParser.defineEntityReplacementText("Icirc", "\u00ce");
            xmlPullParser.defineEntityReplacementText("Iuml", "\u00cf");
            xmlPullParser.defineEntityReplacementText("ETH", "\u00d0");
            xmlPullParser.defineEntityReplacementText("Ntilde", "\u00d1");
            xmlPullParser.defineEntityReplacementText("Ograve", "\u00d2");
            xmlPullParser.defineEntityReplacementText("Oacute", "\u00d3");
            xmlPullParser.defineEntityReplacementText("Ocirc", "\u00d4");
            xmlPullParser.defineEntityReplacementText("Otilde", "\u00d5");
            xmlPullParser.defineEntityReplacementText("Ouml", "\u00d6");
            xmlPullParser.defineEntityReplacementText("times", "\u00d7");
            xmlPullParser.defineEntityReplacementText("Oslash", "\u00d8");
            xmlPullParser.defineEntityReplacementText("Ugrave", "\u00d9");
            xmlPullParser.defineEntityReplacementText("Uacute", "\u00da");
            xmlPullParser.defineEntityReplacementText("Ucirc", "\u00db");
            xmlPullParser.defineEntityReplacementText("Uuml", "\u00dc");
            xmlPullParser.defineEntityReplacementText("Yacute", "\u00dd");
            xmlPullParser.defineEntityReplacementText("THORN", "\u00de");
            xmlPullParser.defineEntityReplacementText("szlig", "\u00df");
            xmlPullParser.defineEntityReplacementText("agrave", "\u00e0");
            xmlPullParser.defineEntityReplacementText("aacute", "\u00e1");
            xmlPullParser.defineEntityReplacementText("acirc", "\u00e2");
            xmlPullParser.defineEntityReplacementText("atilde", "\u00e3");
            xmlPullParser.defineEntityReplacementText("auml", "\u00e4");
            xmlPullParser.defineEntityReplacementText("aring", "\u00e5");
            xmlPullParser.defineEntityReplacementText("aelig", "\u00e6");
            xmlPullParser.defineEntityReplacementText("ccedil", "\u00e7");
            xmlPullParser.defineEntityReplacementText("egrave", "\u00e8");
            xmlPullParser.defineEntityReplacementText("eacute", "\u00e9");
            xmlPullParser.defineEntityReplacementText("ecirc", "\u00ea");
            xmlPullParser.defineEntityReplacementText("euml", "\u00eb");
            xmlPullParser.defineEntityReplacementText("igrave", "\u00ec");
            xmlPullParser.defineEntityReplacementText("iacute", "\u00ed");
            xmlPullParser.defineEntityReplacementText("icirc", "\u00ee");
            xmlPullParser.defineEntityReplacementText("iuml", "\u00ef");
            xmlPullParser.defineEntityReplacementText("eth", "\u00f0");
            xmlPullParser.defineEntityReplacementText("ntilde", "\u00f1");
            xmlPullParser.defineEntityReplacementText("ograve", "\u00f2");
            xmlPullParser.defineEntityReplacementText("oacute", "\u00f3");
            xmlPullParser.defineEntityReplacementText("ocirc", "\u00f4");
            xmlPullParser.defineEntityReplacementText("otilde", "\u00f5");
            xmlPullParser.defineEntityReplacementText("ouml", "\u00f6");
            xmlPullParser.defineEntityReplacementText("divide", "\u00f7");
            xmlPullParser.defineEntityReplacementText("oslash", "\u00f8");
            xmlPullParser.defineEntityReplacementText("ugrave", "\u00f9");
            xmlPullParser.defineEntityReplacementText("uacute", "\u00fa");
            xmlPullParser.defineEntityReplacementText("ucirc", "\u00fb");
            xmlPullParser.defineEntityReplacementText("uuml", "\u00fc");
            xmlPullParser.defineEntityReplacementText("yacute", "\u00fd");
            xmlPullParser.defineEntityReplacementText("thorn", "\u00fe");
            xmlPullParser.defineEntityReplacementText("yuml", "\u00ff");
            xmlPullParser.defineEntityReplacementText("OElig", "\u0152");
            xmlPullParser.defineEntityReplacementText("oelig", "\u0153");
            xmlPullParser.defineEntityReplacementText("Scaron", "\u0160");
            xmlPullParser.defineEntityReplacementText("scaron", "\u0161");
            xmlPullParser.defineEntityReplacementText("Yuml", "\u0178");
            xmlPullParser.defineEntityReplacementText("circ", "\u02c6");
            xmlPullParser.defineEntityReplacementText("tilde", "\u02dc");
            xmlPullParser.defineEntityReplacementText("ensp", "\u2002");
            xmlPullParser.defineEntityReplacementText("emsp", "\u2003");
            xmlPullParser.defineEntityReplacementText("thinsp", "\u2009");
            xmlPullParser.defineEntityReplacementText("zwnj", "\u200c");
            xmlPullParser.defineEntityReplacementText("zwj", "\u200d");
            xmlPullParser.defineEntityReplacementText("lrm", "\u200e");
            xmlPullParser.defineEntityReplacementText("rlm", "\u200f");
            xmlPullParser.defineEntityReplacementText("ndash", "\u2013");
            xmlPullParser.defineEntityReplacementText("mdash", "\u2014");
            xmlPullParser.defineEntityReplacementText("lsquo", "\u2018");
            xmlPullParser.defineEntityReplacementText("rsquo", "\u2019");
            xmlPullParser.defineEntityReplacementText("sbquo", "\u201a");
            xmlPullParser.defineEntityReplacementText("ldquo", "\u201c");
            xmlPullParser.defineEntityReplacementText("rdquo", "\u201d");
            xmlPullParser.defineEntityReplacementText("bdquo", "\u201e");
            xmlPullParser.defineEntityReplacementText("dagger", "\u2020");
            xmlPullParser.defineEntityReplacementText("Dagger", "\u2021");
            xmlPullParser.defineEntityReplacementText("permil", "\u2030");
            xmlPullParser.defineEntityReplacementText("lsaquo", "\u2039");
            xmlPullParser.defineEntityReplacementText("rsaquo", "\u203a");
            xmlPullParser.defineEntityReplacementText("euro", "\u20ac");
            xmlPullParser.defineEntityReplacementText("fnof", "\u0192");
            xmlPullParser.defineEntityReplacementText("Alpha", "\u0391");
            xmlPullParser.defineEntityReplacementText("Beta", "\u0392");
            xmlPullParser.defineEntityReplacementText("Gamma", "\u0393");
            xmlPullParser.defineEntityReplacementText("Delta", "\u0394");
            xmlPullParser.defineEntityReplacementText("Epsilon", "\u0395");
            xmlPullParser.defineEntityReplacementText("Zeta", "\u0396");
            xmlPullParser.defineEntityReplacementText("Eta", "\u0397");
            xmlPullParser.defineEntityReplacementText("Theta", "\u0398");
            xmlPullParser.defineEntityReplacementText("Iota", "\u0399");
            xmlPullParser.defineEntityReplacementText("Kappa", "\u039a");
            xmlPullParser.defineEntityReplacementText("Lambda", "\u039b");
            xmlPullParser.defineEntityReplacementText("Mu", "\u039c");
            xmlPullParser.defineEntityReplacementText("Nu", "\u039d");
            xmlPullParser.defineEntityReplacementText("Xi", "\u039e");
            xmlPullParser.defineEntityReplacementText("Omicron", "\u039f");
            xmlPullParser.defineEntityReplacementText("Pi", "\u03a0");
            xmlPullParser.defineEntityReplacementText("Rho", "\u03a1");
            xmlPullParser.defineEntityReplacementText("Sigma", "\u03a3");
            xmlPullParser.defineEntityReplacementText("Tau", "\u03a4");
            xmlPullParser.defineEntityReplacementText("Upsilon", "\u03a5");
            xmlPullParser.defineEntityReplacementText("Phi", "\u03a6");
            xmlPullParser.defineEntityReplacementText("Chi", "\u03a7");
            xmlPullParser.defineEntityReplacementText("Psi", "\u03a8");
            xmlPullParser.defineEntityReplacementText("Omega", "\u03a9");
            xmlPullParser.defineEntityReplacementText("alpha", "\u03b1");
            xmlPullParser.defineEntityReplacementText("beta", "\u03b2");
            xmlPullParser.defineEntityReplacementText("gamma", "\u03b3");
            xmlPullParser.defineEntityReplacementText("delta", "\u03b4");
            xmlPullParser.defineEntityReplacementText("epsilon", "\u03b5");
            xmlPullParser.defineEntityReplacementText("zeta", "\u03b6");
            xmlPullParser.defineEntityReplacementText("eta", "\u03b7");
            xmlPullParser.defineEntityReplacementText("theta", "\u03b8");
            xmlPullParser.defineEntityReplacementText("iota", "\u03b9");
            xmlPullParser.defineEntityReplacementText("kappa", "\u03ba");
            xmlPullParser.defineEntityReplacementText("lambda", "\u03bb");
            xmlPullParser.defineEntityReplacementText("mu", "\u03bc");
            xmlPullParser.defineEntityReplacementText("nu", "\u03bd");
            xmlPullParser.defineEntityReplacementText("xi", "\u03be");
            xmlPullParser.defineEntityReplacementText("omicron", "\u03bf");
            xmlPullParser.defineEntityReplacementText("pi", "\u03c0");
            xmlPullParser.defineEntityReplacementText("rho", "\u03c1");
            xmlPullParser.defineEntityReplacementText("sigmaf", "\u03c2");
            xmlPullParser.defineEntityReplacementText("sigma", "\u03c3");
            xmlPullParser.defineEntityReplacementText("tau", "\u03c4");
            xmlPullParser.defineEntityReplacementText("upsilon", "\u03c5");
            xmlPullParser.defineEntityReplacementText("phi", "\u03c6");
            xmlPullParser.defineEntityReplacementText("chi", "\u03c7");
            xmlPullParser.defineEntityReplacementText("psi", "\u03c8");
            xmlPullParser.defineEntityReplacementText("omega", "\u03c9");
            xmlPullParser.defineEntityReplacementText("thetasym", "\u03d1");
            xmlPullParser.defineEntityReplacementText("upsih", "\u03d2");
            xmlPullParser.defineEntityReplacementText("piv", "\u03d6");
            xmlPullParser.defineEntityReplacementText("bull", "\u2022");
            xmlPullParser.defineEntityReplacementText("hellip", "\u2026");
            xmlPullParser.defineEntityReplacementText("prime", "\u2032");
            xmlPullParser.defineEntityReplacementText("Prime", "\u2033");
            xmlPullParser.defineEntityReplacementText("oline", "\u203e");
            xmlPullParser.defineEntityReplacementText("frasl", "\u2044");
            xmlPullParser.defineEntityReplacementText("weierp", "\u2118");
            xmlPullParser.defineEntityReplacementText("image", "\u2111");
            xmlPullParser.defineEntityReplacementText("real", "\u211c");
            xmlPullParser.defineEntityReplacementText("trade", "\u2122");
            xmlPullParser.defineEntityReplacementText("alefsym", "\u2135");
            xmlPullParser.defineEntityReplacementText("larr", "\u2190");
            xmlPullParser.defineEntityReplacementText("uarr", "\u2191");
            xmlPullParser.defineEntityReplacementText("rarr", "\u2192");
            xmlPullParser.defineEntityReplacementText("darr", "\u2193");
            xmlPullParser.defineEntityReplacementText("harr", "\u2194");
            xmlPullParser.defineEntityReplacementText("crarr", "\u21b5");
            xmlPullParser.defineEntityReplacementText("lArr", "\u21d0");
            xmlPullParser.defineEntityReplacementText("uArr", "\u21d1");
            xmlPullParser.defineEntityReplacementText("rArr", "\u21d2");
            xmlPullParser.defineEntityReplacementText("dArr", "\u21d3");
            xmlPullParser.defineEntityReplacementText("hArr", "\u21d4");
            xmlPullParser.defineEntityReplacementText("forall", "\u2200");
            xmlPullParser.defineEntityReplacementText("part", "\u2202");
            xmlPullParser.defineEntityReplacementText("exist", "\u2203");
            xmlPullParser.defineEntityReplacementText("empty", "\u2205");
            xmlPullParser.defineEntityReplacementText("nabla", "\u2207");
            xmlPullParser.defineEntityReplacementText("isin", "\u2208");
            xmlPullParser.defineEntityReplacementText("notin", "\u2209");
            xmlPullParser.defineEntityReplacementText("ni", "\u220b");
            xmlPullParser.defineEntityReplacementText("prod", "\u220f");
            xmlPullParser.defineEntityReplacementText("sum", "\u2211");
            xmlPullParser.defineEntityReplacementText("minus", "\u2212");
            xmlPullParser.defineEntityReplacementText("lowast", "\u2217");
            xmlPullParser.defineEntityReplacementText("radic", "\u221a");
            xmlPullParser.defineEntityReplacementText("prop", "\u221d");
            xmlPullParser.defineEntityReplacementText("infin", "\u221e");
            xmlPullParser.defineEntityReplacementText("ang", "\u2220");
            xmlPullParser.defineEntityReplacementText("and", "\u2227");
            xmlPullParser.defineEntityReplacementText("or", "\u2228");
            xmlPullParser.defineEntityReplacementText("cap", "\u2229");
            xmlPullParser.defineEntityReplacementText("cup", "\u222a");
            xmlPullParser.defineEntityReplacementText("int", "\u222b");
            xmlPullParser.defineEntityReplacementText("there4", "\u2234");
            xmlPullParser.defineEntityReplacementText("sim", "\u223c");
            xmlPullParser.defineEntityReplacementText("cong", "\u2245");
            xmlPullParser.defineEntityReplacementText("asymp", "\u2248");
            xmlPullParser.defineEntityReplacementText("ne", "\u2260");
            xmlPullParser.defineEntityReplacementText("equiv", "\u2261");
            xmlPullParser.defineEntityReplacementText("le", "\u2264");
            xmlPullParser.defineEntityReplacementText("ge", "\u2265");
            xmlPullParser.defineEntityReplacementText("sub", "\u2282");
            xmlPullParser.defineEntityReplacementText("sup", "\u2283");
            xmlPullParser.defineEntityReplacementText("nsub", "\u2284");
            xmlPullParser.defineEntityReplacementText("sube", "\u2286");
            xmlPullParser.defineEntityReplacementText("supe", "\u2287");
            xmlPullParser.defineEntityReplacementText("oplus", "\u2295");
            xmlPullParser.defineEntityReplacementText("otimes", "\u2297");
            xmlPullParser.defineEntityReplacementText("perp", "\u22a5");
            xmlPullParser.defineEntityReplacementText("sdot", "\u22c5");
            xmlPullParser.defineEntityReplacementText("lceil", "\u2308");
            xmlPullParser.defineEntityReplacementText("rceil", "\u2309");
            xmlPullParser.defineEntityReplacementText("lfloor", "\u230a");
            xmlPullParser.defineEntityReplacementText("rfloor", "\u230b");
            xmlPullParser.defineEntityReplacementText("lang", "\u2329");
            xmlPullParser.defineEntityReplacementText("rang", "\u232a");
            xmlPullParser.defineEntityReplacementText("loz", "\u25ca");
            xmlPullParser.defineEntityReplacementText("spades", "\u2660");
            xmlPullParser.defineEntityReplacementText("clubs", "\u2663");
            xmlPullParser.defineEntityReplacementText("hearts", "\u2665");
            xmlPullParser.defineEntityReplacementText("diams", "\u2666");
        }
    }

    private int nextTag(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        int n = xmlPullParser.next();
        if (n == 4) {
            n = xmlPullParser.next();
        }
        if (n != 2 && n != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[n], xmlPullParser, null);
        }
        return n;
    }

    private LicenseItem parseLicenseItem(XmlPullParser xmlPullParser, boolean bl) throws IOException, XmlPullParserException {
        ArrayList<String> arrayList;
        String string = xmlPullParser.getName();
        LicenseItem licenseItem = new LicenseItem();
        for (int i = xmlPullParser.getAttributeCount() - 1; i >= 0; --i) {
            arrayList = xmlPullParser.getAttributeName(i);
            String string2 = xmlPullParser.getAttributeValue(i);
            if (((String)((Object)arrayList)).indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(xmlPullParser, (String)((Object)arrayList), string, bl);
        }
        HashSet hashSet = new HashSet();
        while ((bl ? xmlPullParser.nextTag() : this.nextTag(xmlPullParser)) == 2) {
            if (this.checkFieldWithDuplicate(xmlPullParser, "id", null, hashSet)) {
                licenseItem.setId(this.getTrimmedValue(xmlPullParser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlPullParser, "description", null, hashSet)) {
                licenseItem.setDescription(this.getTrimmedValue(xmlPullParser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlPullParser, "names", null, hashSet)) {
                arrayList = new ArrayList();
                licenseItem.setNames((List<String>)arrayList);
                while (xmlPullParser.nextTag() == 2) {
                    if ("name".equals(xmlPullParser.getName())) {
                        arrayList.add(this.getTrimmedValue(xmlPullParser.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(xmlPullParser, bl);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlPullParser, "urls", null, hashSet)) {
                arrayList = new ArrayList<String>();
                licenseItem.setUrls(arrayList);
                while (xmlPullParser.nextTag() == 2) {
                    if ("url".equals(xmlPullParser.getName())) {
                        arrayList.add(this.getTrimmedValue(xmlPullParser.nextText()));
                        continue;
                    }
                    this.checkUnknownElement(xmlPullParser, bl);
                }
                continue;
            }
            this.checkUnknownElement(xmlPullParser, bl);
        }
        return licenseItem;
    }

    private LicensesContainer parseLicensesContainer(XmlPullParser xmlPullParser, boolean bl) throws IOException, XmlPullParserException {
        String string = xmlPullParser.getName();
        LicensesContainer licensesContainer = new LicensesContainer();
        for (int i = xmlPullParser.getAttributeCount() - 1; i >= 0; --i) {
            String string2 = xmlPullParser.getAttributeName(i);
            String string3 = xmlPullParser.getAttributeValue(i);
            if (string2.indexOf(58) >= 0 || "xmlns".equals(string2)) continue;
            this.checkUnknownAttribute(xmlPullParser, string2, string, bl);
        }
        HashSet hashSet = new HashSet();
        while ((bl ? xmlPullParser.nextTag() : this.nextTag(xmlPullParser)) == 2) {
            if (this.checkFieldWithDuplicate(xmlPullParser, "valid", null, hashSet)) {
                licensesContainer.setValid(this.parseLicensesList(xmlPullParser, bl));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlPullParser, "invalid", null, hashSet)) {
                licensesContainer.setInvalid(this.parseLicensesList(xmlPullParser, bl));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlPullParser, "warning", null, hashSet)) {
                licensesContainer.setWarning(this.parseLicensesList(xmlPullParser, bl));
                continue;
            }
            this.checkUnknownElement(xmlPullParser, bl);
        }
        return licensesContainer;
    }

    private LicensesList parseLicensesList(XmlPullParser xmlPullParser, boolean bl) throws IOException, XmlPullParserException {
        List<LicenseItem> list;
        String string = xmlPullParser.getName();
        LicensesList licensesList = new LicensesList();
        for (int i = xmlPullParser.getAttributeCount() - 1; i >= 0; --i) {
            list = xmlPullParser.getAttributeName(i);
            String string2 = xmlPullParser.getAttributeValue(i);
            if (((String)((Object)list)).indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(xmlPullParser, (String)((Object)list), string, bl);
        }
        HashSet hashSet = new HashSet();
        while ((bl ? xmlPullParser.nextTag() : this.nextTag(xmlPullParser)) == 2) {
            if ("license".equals(xmlPullParser.getName())) {
                list = licensesList.getLicenses();
                if (list == null) {
                    list = new ArrayList<LicenseItem>();
                    licensesList.setLicenses(list);
                }
                list.add(this.parseLicenseItem(xmlPullParser, bl));
                continue;
            }
            this.checkUnknownElement(xmlPullParser, bl);
        }
        return licensesList;
    }

    public LicensesContainer read(Reader reader, boolean bl) throws IOException, XmlPullParserException {
        MXParser mXParser = new MXParser();
        mXParser.setInput(reader);
        this.initParser((XmlPullParser)mXParser);
        return this.read((XmlPullParser)mXParser, bl);
    }

    public LicensesContainer read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public LicensesContainer read(InputStream inputStream, boolean bl) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)inputStream), bl);
    }

    public LicensesContainer read(InputStream inputStream) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)inputStream));
    }

    private LicensesContainer read(XmlPullParser xmlPullParser, boolean bl) throws IOException, XmlPullParserException {
        int n = xmlPullParser.getEventType();
        while (n != 1) {
            if (n == 2) {
                if (bl && !"licenses".equals(xmlPullParser.getName())) {
                    throw new XmlPullParserException("Expected root element 'licenses' but found '" + xmlPullParser.getName() + "'", xmlPullParser, null);
                }
                LicensesContainer licensesContainer = this.parseLicensesContainer(xmlPullParser, bl);
                licensesContainer.setModelEncoding(xmlPullParser.getInputEncoding());
                return licensesContainer;
            }
            n = xmlPullParser.next();
        }
        throw new XmlPullParserException("Expected root element 'licenses' but found no element at all: invalid XML document", xmlPullParser, null);
    }

    public void setAddDefaultEntities(boolean bl) {
        this.addDefaultEntities = bl;
    }
}

