/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.messages.RegistryAuth;
import com.spotify.docker.client.messages.RegistryAuthV2;
import com.spotify.docker.client.messages.RegistryConfigs;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import com.spotify.docker.client.shaded.com.google.common.base.Preconditions;
import com.spotify.docker.client.shaded.com.google.common.base.Strings;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerConfigReader {
    private static final Logger LOG = LoggerFactory.getLogger(DockerConfigReader.class);
    private static final ObjectMapper MAPPER = ObjectMapperProvider.objectMapper();
    private static final String AUTHS_ENTRY = "auths";
    private static final String CREDS_STORE = "credsStore";

    public RegistryConfigs fromConfig(Path configPath) throws IOException {
        return this.parseDockerConfig(configPath);
    }

    public RegistryAuth fromConfig(Path configPath, String serverAddress) throws IOException {
        return this.parseDockerConfig(configPath, serverAddress);
    }

    @Deprecated
    public RegistryAuth fromFirstConfig(Path configPath) throws IOException {
        return this.parseDockerConfig(configPath, null);
    }

    private RegistryAuth parseDockerConfig(Path configPath, String serverAddress) throws IOException {
        Preconditions.checkNotNull(configPath);
        ImmutableMap<String, RegistryAuth> configs = this.parseDockerConfig(configPath).configs();
        if (Strings.isNullOrEmpty(serverAddress)) {
            if (configs.isEmpty()) {
                return RegistryAuth.builder().build();
            }
            LOG.warn("Returning first entry from docker config file - use fromConfig(Path) instead, this behavior is deprecated and will soon be removed");
            return (RegistryAuth)configs.values().iterator().next();
        }
        if (configs.containsKey(serverAddress)) {
            return (RegistryAuth)configs.get(serverAddress);
        }
        try {
            URI serverAddressUri = new URI(serverAddress);
            if (serverAddressUri.getScheme() == null) {
                for (String proto : Arrays.asList("https://", "http://")) {
                    String addrWithProto = proto + serverAddress;
                    if (!configs.containsKey(addrWithProto)) continue;
                    return (RegistryAuth)configs.get(addrWithProto);
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        throw new IllegalArgumentException("serverAddress=" + serverAddress + " does not appear in config file at " + configPath);
    }

    private RegistryConfigs parseDockerConfig(Path configPath) throws IOException {
        Preconditions.checkNotNull(configPath);
        ObjectNode authJson = this.extractAuthJson(configPath);
        if (authJson.has(CREDS_STORE) && authJson.has(AUTHS_ENTRY)) {
            String credsStore = authJson.get(CREDS_STORE).textValue();
            HashMap<String, RegistryAuth> registryAuthMap = new HashMap<String, RegistryAuth>();
            ObjectNode auths = (ObjectNode)authJson.get(AUTHS_ENTRY);
            Iterator<String> serverIterator = auths.fieldNames();
            while (serverIterator.hasNext()) {
                Throwable throwable;
                String serverAddress = serverIterator.next();
                Process process = Runtime.getRuntime().exec("docker-credential-" + credsStore + " get");
                try (OutputStreamWriter outStreamWriter = new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8);){
                    throwable = null;
                    try (BufferedWriter writer = new BufferedWriter(outStreamWriter);){
                        writer.write(serverAddress + "\n");
                        writer.flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                InputStreamReader reader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
                var10_11 = null;
                try {
                    BufferedReader input = new BufferedReader(reader);
                    throwable = null;
                    try {
                        String serverAuthDetails = input.readLine();
                        if ("credentials not found in native keychain".equals(serverAuthDetails)) continue;
                        JsonNode serverAuthNode = MAPPER.readTree(serverAuthDetails);
                        RegistryAuthV2 serverAuth = new RegistryAuthV2(serverAuthNode.get("Username").textValue(), serverAuthNode.get("Secret").textValue(), serverAuthNode.get("ServerURL").textValue());
                        registryAuthMap.put(serverAddress, serverAuth);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (input == null) continue;
                        if (throwable != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        input.close();
                    }
                }
                catch (Throwable throwable5) {
                    var10_11 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (reader == null) continue;
                    if (var10_11 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable6) {
                            var10_11.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            return RegistryConfigs.create(registryAuthMap);
        }
        if (authJson.has(AUTHS_ENTRY)) {
            return MAPPER.treeToValue(authJson.get(AUTHS_ENTRY), RegistryConfigs.class);
        }
        try {
            return MAPPER.treeToValue(authJson, RegistryConfigs.class);
        }
        catch (JsonProcessingException e) {
            return RegistryConfigs.empty();
        }
    }

    public Path defaultConfigPath() {
        String home = System.getProperty("user.home");
        Path dockerConfig = Paths.get(home, ".docker", "config.json");
        Path dockerCfg = Paths.get(home, ".dockercfg");
        if (Files.exists(dockerConfig, new LinkOption[0])) {
            LOG.debug("Using configfile: {}", (Object)dockerConfig);
            return dockerConfig;
        }
        LOG.debug("Using configfile: {} ", (Object)dockerCfg);
        return dockerCfg;
    }

    private ObjectNode extractAuthJson(Path configPath) throws IOException {
        File file = configPath.toFile();
        JsonNode config = MAPPER.readTree(file);
        Preconditions.checkState(config.isObject(), "config file contents are not a JSON Object, instead it is a %s", (Object)config.getNodeType());
        if (config.has(AUTHS_ENTRY)) {
            JsonNode auths = config.get(AUTHS_ENTRY);
            Preconditions.checkState(auths.isObject(), "config file contents are not a JSON Object, instead it is a %s", (Object)auths.getNodeType());
        }
        return (ObjectNode)config;
    }
}

