/*
 * Decompiled with CFR 0.152.
 */
package com.springml.sftp.client;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import com.springml.sftp.client.CryptoUtils;
import com.springml.sftp.client.FileNameFilter;
import com.springml.sftp.client.ProgressMonitor;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class SFTPClient {
    private static final Logger LOG = Logger.getLogger(SFTPClient.class.getName());
    private static final String STR_STRICT_HOST_KEY_CHECKING = "StrictHostKeyChecking";
    private static final String STR_SFTP = "sftp";
    private static final String STR_NO = "no";
    private String identity;
    private String username;
    private String password;
    private String host;
    private int port;
    private CryptoUtils cryptoUtils;
    private boolean runCrypto;
    private String passPhrase;

    public SFTPClient(String identity, String username, String password, String host) {
        this(identity, username, password, host, 22);
    }

    public SFTPClient(String identity, String username, String password, String host, int port) {
        this(identity, null, username, password, host, port, false, null);
    }

    public SFTPClient(String identity, String passPhrase, String username, String password, String host, int port) {
        this(identity, passPhrase, username, password, host, port, false, null);
    }

    public SFTPClient(String identity, String passPhrase, String username, String password, String host, boolean runCrypto, String secretKey) {
        this(identity, passPhrase, username, password, host, 22, runCrypto, secretKey);
    }

    public SFTPClient(String identity, String passPhrase, String username, String password, String host, int port, boolean runCrypto, String secretKey) {
        this(identity, passPhrase, username, password, host, port, runCrypto, secretKey, "AES");
    }

    public SFTPClient(String identity, String passPhrase, String username, String password, String host, int port, boolean runCrypto, String secretKey, String algorithm) {
        this.identity = identity;
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.runCrypto = runCrypto;
        this.passPhrase = passPhrase;
        if (runCrypto) {
            this.cryptoUtils = new CryptoUtils(secretKey, algorithm);
        }
    }

    public String copy(String source, String target) throws Exception {
        ChannelSftp sftpChannel = this.createSFTPChannel();
        this.copyInternal(sftpChannel, source, target);
        this.releaseConnection(sftpChannel);
        LOG.info("Copied files successfully...");
        return target;
    }

    public String copyLatest(String source, String target) throws Exception {
        ChannelSftp sftpChannel = this.createSFTPChannel();
        String latestSource = this.getLatestSource(sftpChannel, source);
        this.copyInternal(sftpChannel, latestSource, target);
        this.releaseConnection(sftpChannel);
        LOG.info("Copied files successfully...");
        return this.getCopiedFilePath(latestSource, target);
    }

    public String copyLatestToFTP(String source, String target) throws Exception {
        ChannelSftp sftpChannel = this.createSFTPChannel();
        String latestSource = this.getLatestLocalSource(source);
        this.copyInternalToFTP(sftpChannel, latestSource, target);
        this.releaseConnection(sftpChannel);
        LOG.info("Copied files successfully...");
        return this.getCopiedFilePath(latestSource, target);
    }

    public String copyToFTP(String source, String target) throws Exception {
        ChannelSftp sftpChannel = this.createSFTPChannel();
        this.copyInternalToFTP(sftpChannel, source, target);
        this.releaseConnection(sftpChannel);
        LOG.info("Copied files successfully...");
        return target;
    }

    private String getCopiedFilePath(String latestSource, String target) {
        String copiedFileName = FilenameUtils.getName((String)latestSource);
        return FilenameUtils.concat((String)target, (String)copiedFileName);
    }

    private String getLatestSource(ChannelSftp sftpChannel, String source) throws Exception {
        Vector ls = sftpChannel.ls(source);
        String basePath = FilenameUtils.getPath((String)source);
        if (!basePath.startsWith("/")) {
            basePath = "/" + basePath;
        }
        LOG.fine("Base Path : " + basePath);
        int latestModTime = 0;
        String fileName = FilenameUtils.getBaseName((String)source);
        int size = ls.size();
        for (int i = 0; i < size; ++i) {
            ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)ls.get(i);
            int modTime = entry.getAttrs().getMTime();
            if (latestModTime >= modTime) continue;
            latestModTime = modTime;
            fileName = entry.getFilename();
        }
        return FilenameUtils.concat((String)basePath, (String)fileName);
    }

    private String getLatestLocalSource(String source) throws Exception {
        String fileName = FilenameUtils.getBaseName((String)source);
        String basePath = FilenameUtils.getPath((String)source);
        if (!basePath.startsWith("/")) {
            basePath = "/" + basePath;
        }
        File baseDir = new File(basePath);
        File[] filteredFiles = baseDir.listFiles(new FileNameFilter(fileName));
        LOG.fine("Base Path : " + basePath);
        long latestModTime = 0L;
        for (int i = 0; i < filteredFiles.length; ++i) {
            long modTime = filteredFiles[i].lastModified();
            if (latestModTime >= modTime) continue;
            latestModTime = modTime;
            fileName = filteredFiles[i].getName();
        }
        return FilenameUtils.concat((String)basePath, (String)fileName);
    }

    private void copyInternal(ChannelSftp sftpChannel, String source, String target) throws Exception {
        LOG.info("Copying file from " + source + " to " + target);
        try {
            sftpChannel.cd(source);
            this.copyDir(sftpChannel, source, target);
        }
        catch (Exception e) {
            sftpChannel.get(source, target);
            this.decrypt(target);
        }
    }

    private void copyDir(ChannelSftp sftpChannel, String source, String target) throws Exception {
        LOG.info("Copying files from " + source + " to " + target);
        sftpChannel.cd(source);
        sftpChannel.lcd(target);
        Vector childFiles = sftpChannel.ls(".");
        for (ChannelSftp.LsEntry lsEntry : childFiles) {
            String entryName = lsEntry.getFilename();
            LOG.fine("File Entry " + entryName);
            if (entryName.equals(".") || entryName.equals("..")) continue;
            if (lsEntry.getAttrs().isDir()) {
                this.copyInternal(sftpChannel, source + entryName + "/", target);
                continue;
            }
            LOG.info("Copying file " + entryName);
            sftpChannel.get(entryName, entryName, (SftpProgressMonitor)new ProgressMonitor());
            this.decrypt(target + File.separator + entryName);
        }
    }

    private void decrypt(String fileLocation) throws Exception {
        if (this.runCrypto) {
            LOG.info("Decrypting " + fileLocation);
            String tempFileLocation = fileLocation + ".temp";
            File tempFile = new File(tempFileLocation);
            File actualFile = new File(fileLocation);
            FileUtils.moveFile((File)actualFile, (File)tempFile);
            this.cryptoUtils.decrypt(tempFile, actualFile);
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    private void copyInternalToFTP(ChannelSftp sftpChannel, String source, String target) throws Exception {
        LOG.info("Copying files from " + source + " to " + target);
        try {
            sftpChannel.lcd(source);
            this.copyDirToFTP(sftpChannel, source, target);
        }
        catch (Exception e) {
            this.encrypt(source);
            sftpChannel.put(source, target);
        }
    }

    private void copyDirToFTP(ChannelSftp sftpChannel, String source, String target) throws Exception {
        LOG.info("Copying files from " + source + " to " + target);
        sftpChannel.lcd(source);
        sftpChannel.cd(target);
        Collection childFiles = FileUtils.listFiles((File)new File(source), null, (boolean)false);
        for (File file : childFiles) {
            String entryName = file.getName();
            LOG.fine("File Entry " + entryName);
            if (entryName.equals(".") || entryName.equals("..")) continue;
            if (file.isDirectory()) {
                this.copyInternalToFTP(sftpChannel, source + entryName + "/", target);
                continue;
            }
            LOG.info("Copying file " + entryName);
            this.encrypt(source + File.separator + entryName);
            sftpChannel.put(entryName, entryName, (SftpProgressMonitor)new ProgressMonitor());
        }
    }

    private void encrypt(String fileLocation) throws Exception {
        if (this.runCrypto) {
            LOG.info("Encrypting " + fileLocation);
            String tempFileLocation = fileLocation + ".temp";
            File tempFile = new File(tempFileLocation);
            File actualFile = new File(fileLocation);
            FileUtils.moveFile((File)actualFile, (File)tempFile);
            this.cryptoUtils.encrypt(tempFile, actualFile);
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    private ChannelSftp createSFTPChannel() throws Exception {
        boolean useIdentity;
        JSch jsch = new JSch();
        boolean bl = useIdentity = this.identity != null && !this.identity.isEmpty();
        if (useIdentity) {
            if (this.passPhrase != null) {
                jsch.addIdentity(this.identity, this.passPhrase);
            } else {
                jsch.addIdentity(this.identity);
            }
        }
        Session session = jsch.getSession(this.username, this.host, this.port);
        session.setConfig(STR_STRICT_HOST_KEY_CHECKING, STR_NO);
        if (!useIdentity) {
            session.setPassword(this.password);
        }
        session.connect();
        Channel channel = session.openChannel(STR_SFTP);
        channel.connect();
        return (ChannelSftp)channel;
    }

    private void releaseConnection(ChannelSftp sftpChannel) throws Exception {
        Session session = sftpChannel.getSession();
        sftpChannel.exit();
        session.disconnect();
    }
}

