/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.support.v4.view;

import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.view.AbstractViewGroupAssert;

public class ViewPagerAssert
extends AbstractViewGroupAssert<ViewPagerAssert, ViewPager> {
    public ViewPagerAssert(ViewPager actual) {
        super(actual, ViewPagerAssert.class);
    }

    public ViewPagerAssert hasAdapter(PagerAdapter adapter) {
        this.isNotNull();
        PagerAdapter actualAdapter = ((ViewPager)this.actual).getAdapter();
        ((ObjectAssert)Assertions.assertThat((Object)actualAdapter).overridingErrorMessage("Expected adapter <%s> but was <%s>.", new Object[]{adapter, actualAdapter})).isSameAs((Object)adapter);
        return this;
    }

    public ViewPagerAssert hasCurrentItem(int index) {
        this.isNotNull();
        int actualIndex = ((ViewPager)this.actual).getCurrentItem();
        ((IntegerAssert)Assertions.assertThat((int)actualIndex).overridingErrorMessage("Expected current item <%s> but was <%s>.", new Object[]{index, actualIndex})).isEqualTo(index);
        return this;
    }

    public ViewPagerAssert hasOffscreenPageLimit(int limit) {
        this.isNotNull();
        int actualLimit = ((ViewPager)this.actual).getOffscreenPageLimit();
        ((IntegerAssert)Assertions.assertThat((int)actualLimit).overridingErrorMessage("Expected offscreen page limit <%s> but was <%s>.", new Object[]{limit, actualLimit})).isEqualTo(limit);
        return this;
    }

    public ViewPagerAssert hasPageMargin(int margin) {
        this.isNotNull();
        int actualMargin = ((ViewPager)this.actual).getPageMargin();
        ((IntegerAssert)Assertions.assertThat((int)actualMargin).overridingErrorMessage("Expected page margin <%s> but was <%s>.", new Object[]{margin, actualMargin})).isEqualTo(margin);
        return this;
    }

    public ViewPagerAssert isFakeDragging() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ViewPager)this.actual).isFakeDragging()).overridingErrorMessage("Expected to be fake dragging but was not.", new Object[0])).isTrue();
        return this;
    }

    public ViewPagerAssert isNotFakeDragging() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ViewPager)this.actual).isFakeDragging()).overridingErrorMessage("Expected to not be fake dragging but was.", new Object[0])).isFalse();
        return this;
    }
}

