/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.view.View;
import android.widget.ViewAnimator;
import org.fest.assertions.api.ANDROID;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.view.AbstractViewGroupAssert;

public abstract class AbstractViewAnimatorAssert<S extends AbstractViewAnimatorAssert<S, A>, A extends ViewAnimator>
extends AbstractViewGroupAssert<S, A> {
    public AbstractViewAnimatorAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    private View getDisplayedView() {
        return ((ViewAnimator)this.actual).getChildAt(((ViewAnimator)this.actual).getDisplayedChild());
    }

    public S hasDisplayedChild(View view) {
        this.isNotNull();
        View actualView = this.getDisplayedView();
        ((ObjectAssert)Assertions.assertThat((Object)actualView).overridingErrorMessage("Expected displayed child <%s> but was <%s>.", new Object[]{view, actualView})).isSameAs((Object)view);
        return (S)((Object)((AbstractViewAnimatorAssert)this.myself));
    }

    public S hasDisplayedChildId(int id) {
        this.isNotNull();
        ANDROID.assertThat(this.getDisplayedView()).hasId(id);
        return (S)((Object)((AbstractViewAnimatorAssert)this.myself));
    }

    public S hasDisplayedChild(int index) {
        this.isNotNull();
        int actualIndex = ((ViewAnimator)this.actual).getDisplayedChild();
        ((IntegerAssert)Assertions.assertThat((int)actualIndex).overridingErrorMessage("Expected displayed child index <%s> but was <%s>.", new Object[]{index, actualIndex})).isEqualTo(index);
        return (S)((Object)((AbstractViewAnimatorAssert)this.myself));
    }
}

