/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.widget.DatePicker;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.LongAssert;
import org.fest.assertions.api.android.widget.AbstractFrameLayoutAssert;

public class DatePickerAssert
extends AbstractFrameLayoutAssert<DatePickerAssert, DatePicker> {
    public DatePickerAssert(DatePicker actual) {
        super(actual, DatePickerAssert.class);
    }

    public DatePickerAssert isShowingCalendarView() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((DatePicker)this.actual).getCalendarViewShown()).overridingErrorMessage("Expected calendar view to be showing but was not.", new Object[0])).isTrue();
        return this;
    }

    public DatePickerAssert isNotShowingCalendarView() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((DatePicker)this.actual).getCalendarViewShown()).overridingErrorMessage("Expected calendar view to not be showing but was.", new Object[0])).isFalse();
        return this;
    }

    public DatePickerAssert hasDayOfMonth(int day) {
        this.isNotNull();
        int actualDay = ((DatePicker)this.actual).getDayOfMonth();
        ((IntegerAssert)Assertions.assertThat((int)actualDay).overridingErrorMessage("Expected day of month <%s> but was <%s>.", new Object[]{day, actualDay})).isEqualTo(day);
        return this;
    }

    public DatePickerAssert hasMaxDate(long date) {
        this.isNotNull();
        long actualDate = ((DatePicker)this.actual).getMaxDate();
        ((LongAssert)Assertions.assertThat((long)actualDate).overridingErrorMessage("Expected max date <%s> but was <%s>.", new Object[]{date, actualDate})).isEqualTo(date);
        return this;
    }

    public DatePickerAssert hasMinDate(long date) {
        this.isNotNull();
        long actualDate = ((DatePicker)this.actual).getMinDate();
        ((LongAssert)Assertions.assertThat((long)actualDate).overridingErrorMessage("Expected min date <%s> but was <%s>.", new Object[]{date, actualDate})).isEqualTo(date);
        return this;
    }

    public DatePickerAssert hasMonth(int month) {
        this.isNotNull();
        int actualMonth = ((DatePicker)this.actual).getMonth();
        ((IntegerAssert)Assertions.assertThat((int)actualMonth).overridingErrorMessage("Expected month <%s> but was <%s>.", new Object[]{month, actualMonth})).isEqualTo(month);
        return this;
    }

    public DatePickerAssert isShowingSpinners() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((DatePicker)this.actual).getSpinnersShown()).overridingErrorMessage("Expected to be showing spinners but was not.", new Object[0])).isTrue();
        return this;
    }

    public DatePickerAssert isNotShowingSpinners() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((DatePicker)this.actual).getSpinnersShown()).overridingErrorMessage("Expected to not be showing spinners but was.", new Object[0])).isFalse();
        return this;
    }

    public DatePickerAssert hasYear(int year) {
        this.isNotNull();
        int actualYear = ((DatePicker)this.actual).getYear();
        ((IntegerAssert)Assertions.assertThat((int)actualYear).overridingErrorMessage("Expected year <%s> but was <%s>.", new Object[]{year, actualYear})).isEqualTo(year);
        return this;
    }
}

