//[okhttp](../../../index.md)/[okhttp3](../index.md)/[AsyncDns](index.md)

# AsyncDns

[jvm]\
interface [AsyncDns](index.md)

An async domain name service that resolves IP addresses for host names.

The main implementations will typically be implemented using specific DNS libraries such as

- 
   Android DnsResolver
- 
   OkHttp DnsOverHttps
- 
   dnsjava Resolver

Implementations of this interface must be safe for concurrent use.

## Types

| Name | Summary |
|---|---|
| [Callback](-callback/index.md) | [jvm]<br>interface [Callback](-callback/index.md)<br>Callback to receive results from the DNS Queries. |
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |
| [DnsClass](-dns-class/index.md) | [jvm]<br>enum [DnsClass](-dns-class/index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[AsyncDns.DnsClass](-dns-class/index.md)&gt; <br>Class of DNS addresses, such that clients that treat these differently, such as attempting IPv6 first, can make such decisions. |

## Functions

| Name | Summary |
|---|---|
| [query](query.md) | [jvm]<br>abstract fun [query](query.md)(hostname: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: [AsyncDns.Callback](-callback/index.md))<br>Query DNS records for `hostname`, in the order they are received. |
