//[okhttp](../../../index.md)/[okhttp3](../index.md)/[CertificatePinner](index.md)/[check](check.md)

# check

[jvm]\
fun [check](check.md)(hostname: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), peerCertificates: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Certificate](https://docs.oracle.com/javase/8/docs/api/java/security/cert/Certificate.html)&gt;)

Confirms that at least one of the certificates pinned for `hostname` is in `peerCertificates`. Does nothing if there are no certificates pinned for `hostname`. OkHttp calls this after a successful TLS handshake, but before the connection is used.

#### Throws

| | |
|---|---|
| [SSLPeerUnverifiedException](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLPeerUnverifiedException.html) | if `peerCertificates` don't match the certificates pinned     for `hostname`. |
