/*
 * Decompiled with CFR 0.152.
 */
package mockwebserver3;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import mockwebserver3.Dispatcher;
import mockwebserver3.MockResponse;
import mockwebserver3.MockResponseBody;
import mockwebserver3.MockWebServer;
import mockwebserver3.PushPromise;
import mockwebserver3.QueueDispatcher;
import mockwebserver3.RecordedRequest;
import mockwebserver3.SocketPolicy;
import mockwebserver3.StreamHandler;
import mockwebserver3.internal.SleepKt;
import mockwebserver3.internal.ThrottledSink;
import mockwebserver3.internal.TriggerSink;
import mockwebserver3.internal.duplex.RealStream;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocketListener;
import okhttp3.internal.Internal;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.ws.RealWebSocket;
import okhttp3.internal.ws.WebSocketExtensions;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 {2\u00020\u0001:\u0004{|}~B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010L\u001a\u00020MH\u0002J\b\u0010N\u001a\u00020MH\u0002J\b\u0010O\u001a\u00020MH\u0016J\u0018\u0010P\u001a\u00020M2\u0006\u0010Q\u001a\u00020\u000e2\u0006\u0010R\u001a\u00020\u001eH\u0002J\u000e\u0010S\u001a\u00020M2\u0006\u0010T\u001a\u00020UJ0\u0010V\u001a\u00020M2\u0006\u0010R\u001a\u00020\u001e2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u0002092\u0006\u0010T\u001a\u00020UH\u0002J\u0006\u0010\\\u001a\u00020MJ\u0010\u0010]\u001a\u00020M2\u0006\u0010^\u001a\u00020\u001eH\u0002J\u0010\u0010_\u001a\u00020M2\u0006\u0010W\u001a\u00020XH\u0002J(\u0010`\u001a\u0002092\u0006\u0010R\u001a\u00020\u001e2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010Q\u001a\u00020\u000eH\u0002J\u0006\u0010a\u001a\u00020MJ\u0006\u0010b\u001a\u00020MJ\u0010\u0010c\u001a\u00020M2\u0006\u0010^\u001a\u00020\u001eH\u0002J\u0006\u0010B\u001a\u00020MJ\u0016\u0010d\u001a\u00020M2\u0006\u0010e\u001a\u00020f2\u0006\u0010#\u001a\u00020\u000eJ\u0010\u0010d\u001a\u00020M2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0012\u0010d\u001a\u00020M2\b\b\u0002\u0010#\u001a\u00020\u000eH\u0007J\u0006\u0010g\u001a\u000209J\u0018\u0010g\u001a\u0004\u0018\u0001092\u0006\u0010h\u001a\u00020\b2\u0006\u0010i\u001a\u00020jJ\u0006\u0010k\u001a\u00020lJ\b\u0010m\u001a\u00020\u0016H\u0016J\u000e\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020\u0016J\u000e\u0010q\u001a\u00020M2\u0006\u0010C\u001a\u00020DJ\u0018\u0010r\u001a\u00020M2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010s\u001a\u00020tH\u0002J \u0010u\u001a\u00020M2\u0006\u0010R\u001a\u00020\u001e2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010T\u001a\u00020UH\u0002J,\u0010v\u001a\u00020w*\u00020w2\u0006\u0010x\u001a\u00020U2\u0006\u0010y\u001a\u00020(2\u0006\u0010z\u001a\u00020\b2\u0006\u0010R\u001a\u00020\u001eH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR2\u0010\u001c\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e\u0018\u00010 0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010!\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\"0\" \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\"0\"\u0018\u00010 0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R0\u00100\u001a\b\u0012\u0004\u0012\u00020/0.2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0011\u00105\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010%R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020908X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010=\u001a\u0004\u0018\u00010<2\b\u0010-\u001a\u0004\u0018\u00010<8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u000e\u0010B\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u0004\u0018\u00010DX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010E\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010*\"\u0004\bG\u0010,R\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020KX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u007f"}, d2={"Lmockwebserver3/MockWebServer;", "Ljava/io/Closeable;", "()V", "_inetSocketAddress", "Ljava/net/InetSocketAddress;", "atomicRequestCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "bodyLimit", "", "getBodyLimit", "()J", "setBodyLimit", "(J)V", "clientAuth", "", "dispatcher", "Lmockwebserver3/Dispatcher;", "getDispatcher", "()Lmockwebserver3/Dispatcher;", "setDispatcher", "(Lmockwebserver3/Dispatcher;)V", "hostName", "", "getHostName", "()Ljava/lang/String;", "inetSocketAddress", "getInetSocketAddress", "()Ljava/net/InetSocketAddress;", "openClientSockets", "", "Ljava/net/Socket;", "kotlin.jvm.PlatformType", "", "openConnections", "Lokhttp3/internal/http2/Http2Connection;", "port", "getPort", "()I", "portField", "protocolNegotiationEnabled", "", "getProtocolNegotiationEnabled", "()Z", "setProtocolNegotiationEnabled", "(Z)V", "value", "", "Lokhttp3/Protocol;", "protocols", "getProtocols", "()Ljava/util/List;", "setProtocols", "(Ljava/util/List;)V", "requestCount", "getRequestCount", "requestQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lmockwebserver3/RecordedRequest;", "serverSocket", "Ljava/net/ServerSocket;", "Ljavax/net/ServerSocketFactory;", "serverSocketFactory", "getServerSocketFactory", "()Ljavax/net/ServerSocketFactory;", "setServerSocketFactory", "(Ljavax/net/ServerSocketFactory;)V", "shutdown", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "started", "getStarted", "setStarted", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "taskRunnerBackend", "Lokhttp3/internal/concurrent/TaskRunner$RealBackend;", "acceptConnections", "", "before", "close", "dispatchBookkeepingRequest", "sequenceNumber", "socket", "enqueue", "response", "Lmockwebserver3/MockResponse;", "handleWebSocketUpgrade", "source", "Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "request", "noClientAuth", "processHandshakeFailure", "raw", "readEmptyLine", "readRequest", "requestClientAuth", "requireClientAuth", "serveConnection", "start", "inetAddress", "Ljava/net/InetAddress;", "takeRequest", "timeout", "unit", "Ljava/util/concurrent/TimeUnit;", "toProxyAddress", "Ljava/net/Proxy;", "toString", "url", "Lokhttp3/HttpUrl;", "path", "useHttps", "writeHeaders", "headers", "Lokhttp3/Headers;", "writeHttpResponse", "withThrottlingAndSocketPolicy", "Lokio/Sink;", "policy", "disconnectHalfway", "expectedByteCount", "Companion", "Http2SocketHandler", "SocketHandler", "TruncatingBuffer", "mockwebserver3"})
@SourceDebugExtension(value={"SMAP\nMockWebServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockWebServer.kt\nmockwebserver3/MockWebServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1135:1\n1#2:1136\n*E\n"})
public final class MockWebServer
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TaskRunner.RealBackend taskRunnerBackend = new TaskRunner.RealBackend(_UtilJvmKt.threadFactory((String)"MockWebServer TaskRunner", (boolean)false));
    @NotNull
    private final TaskRunner taskRunner = new TaskRunner((TaskRunner.Backend)this.taskRunnerBackend, null, 2, null);
    @NotNull
    private final LinkedBlockingQueue<RecordedRequest> requestQueue = new LinkedBlockingQueue();
    private final Set<Socket> openClientSockets = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Http2Connection> openConnections = Collections.newSetFromMap(new ConcurrentHashMap());
    @NotNull
    private final AtomicInteger atomicRequestCount = new AtomicInteger();
    private long bodyLimit = Long.MAX_VALUE;
    @Nullable
    private ServerSocketFactory serverSocketFactory;
    @Nullable
    private ServerSocket serverSocket;
    @Nullable
    private SSLSocketFactory sslSocketFactory;
    private int clientAuth;
    @NotNull
    private Dispatcher dispatcher = new QueueDispatcher();
    private int portField = -1;
    @Nullable
    private InetSocketAddress _inetSocketAddress;
    private boolean protocolNegotiationEnabled = true;
    @NotNull
    private List<? extends Protocol> protocols;
    private boolean started;
    private boolean shutdown;
    private static final int CLIENT_AUTH_NONE = 0;
    private static final int CLIENT_AUTH_REQUESTED = 1;
    private static final int CLIENT_AUTH_REQUIRED = 2;
    @NotNull
    private static final Companion.UNTRUSTED_TRUST_MANAGER.1 UNTRUSTED_TRUST_MANAGER = new X509TrustManager(){

        @NotNull
        public Void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            throw new CertificateException();
        }

        @NotNull
        public Void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            throw new AssertionError();
        }

        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            throw new AssertionError();
        }
    };
    private static final Logger logger = Logger.getLogger(MockWebServer.class.getName());

    public MockWebServer() {
        Object[] objectArray = new Protocol[]{Protocol.HTTP_2, Protocol.HTTP_1_1};
        this.protocols = _UtilJvmKt.immutableListOf((Object[])objectArray);
    }

    public final int getRequestCount() {
        return this.atomicRequestCount.get();
    }

    public final long getBodyLimit() {
        return this.bodyLimit;
    }

    public final void setBodyLimit(long l) {
        this.bodyLimit = l;
    }

    @Nullable
    public final synchronized ServerSocketFactory getServerSocketFactory() {
        if (this.serverSocketFactory == null && this.started) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        return this.serverSocketFactory;
    }

    public final synchronized void setServerSocketFactory(@Nullable ServerSocketFactory value) {
        if (!(!this.started)) {
            boolean bl = false;
            String string = "serverSocketFactory must not be set after start()";
            throw new IllegalStateException(string.toString());
        }
        this.serverSocketFactory = value;
    }

    @NotNull
    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public final void setDispatcher(@NotNull Dispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"<set-?>");
        this.dispatcher = dispatcher;
    }

    public final int getPort() {
        this.before();
        return this.portField;
    }

    @NotNull
    public final String getHostName() {
        this.before();
        InetSocketAddress inetSocketAddress = this._inetSocketAddress;
        Intrinsics.checkNotNull((Object)inetSocketAddress);
        String string = inetSocketAddress.getAddress().getHostName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostName(...)");
        return string;
    }

    @NotNull
    public final InetSocketAddress getInetSocketAddress() {
        this.before();
        return new InetSocketAddress(this.getHostName(), this.portField);
    }

    public final boolean getProtocolNegotiationEnabled() {
        return this.protocolNegotiationEnabled;
    }

    public final void setProtocolNegotiationEnabled(boolean bl) {
        this.protocolNegotiationEnabled = bl;
    }

    @NotNull
    public final List<Protocol> getProtocols() {
        return this.protocols;
    }

    public final void setProtocols(@NotNull List<? extends Protocol> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        List protocolList = _UtilJvmKt.toImmutableList(value);
        if (!(!protocolList.contains(Protocol.H2_PRIOR_KNOWLEDGE) || protocolList.size() == 1)) {
            boolean $i$a$-require-MockWebServer$protocols$42 = false;
            String $i$a$-require-MockWebServer$protocols$42 = "protocols containing h2_prior_knowledge cannot use other protocols: " + protocolList;
            throw new IllegalArgumentException($i$a$-require-MockWebServer$protocols$42.toString());
        }
        if (!(protocolList.contains(Protocol.HTTP_1_1) || protocolList.contains(Protocol.H2_PRIOR_KNOWLEDGE))) {
            boolean $i$a$-require-MockWebServer$protocols$52 = false;
            String $i$a$-require-MockWebServer$protocols$52 = "protocols doesn't contain http/1.1: " + protocolList;
            throw new IllegalArgumentException($i$a$-require-MockWebServer$protocols$52.toString());
        }
        Intrinsics.checkNotNull((Object)protocolList, (String)"null cannot be cast to non-null type kotlin.collections.List<okhttp3.Protocol?>");
        if (!(!protocolList.contains(null))) {
            boolean bl = false;
            String string = "protocols must not contain null";
            throw new IllegalArgumentException(string.toString());
        }
        this.protocols = protocolList;
    }

    public final boolean getStarted() {
        return this.started;
    }

    public final void setStarted(boolean bl) {
        this.started = bl;
    }

    private final synchronized void before() {
        if (this.started) {
            return;
        }
        try {
            MockWebServer.start$default(this, 0, 1, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public final Proxy toProxyAddress() {
        this.before();
        InetSocketAddress inetSocketAddress = this._inetSocketAddress;
        Intrinsics.checkNotNull((Object)inetSocketAddress);
        InetSocketAddress address = new InetSocketAddress(inetSocketAddress.getAddress().getHostName(), this.getPort());
        return new Proxy(Proxy.Type.HTTP, address);
    }

    @NotNull
    public final HttpUrl url(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        HttpUrl httpUrl = new HttpUrl.Builder().scheme(this.sslSocketFactory != null ? "https" : "http").host(this.getHostName()).port(this.getPort()).build().resolve(path);
        Intrinsics.checkNotNull((Object)httpUrl);
        return httpUrl;
    }

    public final void useHttps(@NotNull SSLSocketFactory sslSocketFactory) {
        Intrinsics.checkNotNullParameter((Object)sslSocketFactory, (String)"sslSocketFactory");
        this.sslSocketFactory = sslSocketFactory;
    }

    public final void noClientAuth() {
        this.clientAuth = 0;
    }

    public final void requestClientAuth() {
        this.clientAuth = 1;
    }

    public final void requireClientAuth() {
        this.clientAuth = 2;
    }

    @NotNull
    public final RecordedRequest takeRequest() throws InterruptedException {
        RecordedRequest recordedRequest = this.requestQueue.take();
        Intrinsics.checkNotNullExpressionValue((Object)recordedRequest, (String)"take(...)");
        return recordedRequest;
    }

    @Nullable
    public final RecordedRequest takeRequest(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.requestQueue.poll(timeout, unit);
    }

    public final void enqueue(@NotNull MockResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Dispatcher dispatcher = this.dispatcher;
        Intrinsics.checkNotNull((Object)dispatcher, (String)"null cannot be cast to non-null type mockwebserver3.QueueDispatcher");
        ((QueueDispatcher)dispatcher).enqueueResponse(response);
    }

    @JvmOverloads
    public final void start(int port) throws IOException {
        InetAddress inetAddress = InetAddress.getByName("localhost");
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(...)");
        this.start(inetAddress, port);
    }

    public static /* synthetic */ void start$default(MockWebServer mockWebServer, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        mockWebServer.start(n);
    }

    public final void start(@NotNull InetAddress inetAddress, int port) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        this.start(new InetSocketAddress(inetAddress, port));
    }

    private final synchronized void start(InetSocketAddress inetSocketAddress) throws IOException {
        if (!(!this.shutdown)) {
            boolean bl = false;
            String string = "shutdown() already called";
            throw new IllegalStateException(string.toString());
        }
        if (this.started) {
            return;
        }
        this.started = true;
        this._inetSocketAddress = inetSocketAddress;
        ServerSocketFactory serverSocketFactory = this.getServerSocketFactory();
        Intrinsics.checkNotNull((Object)serverSocketFactory);
        ServerSocket serverSocket = this.serverSocket = serverSocketFactory.createServerSocket();
        Intrinsics.checkNotNull((Object)serverSocket);
        serverSocket.setReuseAddress(inetSocketAddress.getPort() != 0);
        ServerSocket serverSocket2 = this.serverSocket;
        Intrinsics.checkNotNull((Object)serverSocket2);
        serverSocket2.bind(inetSocketAddress, 50);
        ServerSocket serverSocket3 = this.serverSocket;
        Intrinsics.checkNotNull((Object)serverSocket3);
        this.portField = serverSocket3.getLocalPort();
        TaskQueue.execute$default((TaskQueue)this.taskRunner.newQueue(), (String)("MockWebServer " + this.portField), (long)0L, (boolean)false, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ MockWebServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                try {
                    MockWebServer.access$getLogger$cp().fine(this.this$0 + " starting to accept connections");
                    MockWebServer.access$acceptConnections(this.this$0);
                }
                catch (Throwable e) {
                    MockWebServer.access$getLogger$cp().log(Level.WARNING, this.this$0 + " failed unexpectedly", e);
                }
                ServerSocket serverSocket = MockWebServer.access$getServerSocket$p(this.this$0);
                if (serverSocket != null) {
                    _UtilCommonKt.closeQuietly((Closeable)serverSocket);
                }
                Iterator<E> openClientSocket = MockWebServer.access$getOpenClientSockets$p(this.this$0).iterator();
                while (openClientSocket.hasNext()) {
                    E e = openClientSocket.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    _UtilCommonKt.closeQuietly((Closeable)((Closeable)e));
                    openClientSocket.remove();
                }
                Iterator<E> httpConnection = MockWebServer.access$getOpenConnections$p(this.this$0).iterator();
                while (httpConnection.hasNext()) {
                    E e = httpConnection.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    _UtilCommonKt.closeQuietly((Closeable)((Closeable)e));
                    httpConnection.remove();
                }
                this.this$0.getDispatcher().shutdown();
            }
        }), (int)2, null);
    }

    private final void acceptConnections() throws Exception {
        while (true) {
            Socket socket = null;
            try {
                ServerSocket serverSocket = this.serverSocket;
                Intrinsics.checkNotNull((Object)serverSocket);
                Socket socket2 = serverSocket.accept();
                Intrinsics.checkNotNullExpressionValue((Object)socket2, (String)"accept(...)");
                socket = socket2;
            }
            catch (SocketException e) {
                logger.fine(this + " done accepting connections: " + e.getMessage());
                return;
            }
            SocketPolicy socketPolicy = this.dispatcher.peek().getSocketPolicy();
            if (socketPolicy == SocketPolicy.DisconnectAtStart.INSTANCE) {
                this.dispatchBookkeepingRequest(0, socket);
                socket.close();
                continue;
            }
            this.openClientSockets.add(socket);
            this.serveConnection(socket);
        }
    }

    public final synchronized void shutdown() throws IOException {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (!this.started) {
            return;
        }
        ServerSocket serverSocket = this.serverSocket;
        if (serverSocket == null) {
            return;
        }
        ServerSocket serverSocket2 = serverSocket;
        serverSocket2.close();
        for (TaskQueue queue : this.taskRunner.activeQueues()) {
            if (queue.idleLatch().await(5L, TimeUnit.SECONDS)) continue;
            throw new IOException("Gave up waiting for queue to shut down");
        }
        this.taskRunnerBackend.shutdown();
    }

    private final void serveConnection(Socket raw) {
        TaskQueue.execute$default((TaskQueue)this.taskRunner.newQueue(), (String)("MockWebServer " + raw.getRemoteSocketAddress()), (long)0L, (boolean)false, (Function0)((Function0)new Function0<Unit>(this, raw){
            final /* synthetic */ MockWebServer this$0;
            final /* synthetic */ Socket $raw;
            {
                this.this$0 = $receiver;
                this.$raw = $raw;
                super(0);
            }

            public final void invoke() {
                try {
                    this.this$0.new SocketHandler(this.$raw).handle();
                }
                catch (IOException e) {
                    MockWebServer.access$getLogger$cp().fine(this.this$0 + " connection from " + this.$raw.getInetAddress() + " failed: " + e);
                }
                catch (Exception e) {
                    MockWebServer.access$getLogger$cp().log(Level.SEVERE, this.this$0 + " connection from " + this.$raw.getInetAddress() + " crashed", e);
                }
            }
        }), (int)2, null);
    }

    private final void processHandshakeFailure(Socket raw) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManager[] trustManagerArray = new TrustManager[]{UNTRUSTED_TRUST_MANAGER};
        context.init(null, trustManagerArray, new SecureRandom());
        SSLSocketFactory sslSocketFactory = context.getSocketFactory();
        Socket socket = sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
        Intrinsics.checkNotNull((Object)socket, (String)"null cannot be cast to non-null type javax.net.ssl.SSLSocket");
        SSLSocket socket2 = (SSLSocket)socket;
        try {
            socket2.startHandshake();
            throw new AssertionError();
        }
        catch (IOException iOException) {
            socket2.close();
            return;
        }
    }

    private final void dispatchBookkeepingRequest(int sequenceNumber, Socket socket) throws InterruptedException {
        RecordedRequest request = new RecordedRequest("", Headers.Companion.of(new String[0]), CollectionsKt.emptyList(), 0L, new Buffer(), sequenceNumber, socket, null, 128, null);
        this.atomicRequestCount.incrementAndGet();
        this.requestQueue.add(request);
        this.dispatcher.dispatch(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RecordedRequest readRequest(Socket socket, BufferedSource source, BufferedSink sink, int sequenceNumber) throws IOException {
        String request = null;
        request = "";
        Headers.Builder headers = new Headers.Builder();
        long contentLength = 0L;
        contentLength = -1L;
        boolean chunked = false;
        TruncatingBuffer requestBody = new TruncatingBuffer(this.bodyLimit);
        List chunkSizes = new ArrayList();
        IOException failure = null;
        try {
            String header;
            request = source.readUtf8LineStrict();
            if (((CharSequence)request).length() == 0) {
                throw new ProtocolException("no request because the stream is exhausted");
            }
            while (!(((CharSequence)(header = source.readUtf8LineStrict())).length() == 0)) {
                Object lowercaseHeader;
                Internal.addHeaderLenient((Headers.Builder)headers, (String)header);
                String string = header;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(locale), (String)"toLowerCase(...)");
                if (contentLength == -1L && StringsKt.startsWith$default((String)lowercaseHeader, (String)"content-length:", (boolean)false, (int)2, null)) {
                    String string2 = header.substring(15);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    contentLength = Long.parseLong(((Object)StringsKt.trim((CharSequence)string2)).toString());
                }
                if (!StringsKt.startsWith$default((String)lowercaseHeader, (String)"transfer-encoding:", (boolean)false, (int)2, null)) continue;
                String string3 = ((String)lowercaseHeader).substring(18);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string3)).toString(), (Object)"chunked")) continue;
                chunked = true;
            }
            MockResponse peek = this.dispatcher.peek();
            for (MockResponse response : peek.getInformationalResponses()) {
                this.writeHttpResponse(socket, sink, response);
            }
            boolean hasBody = false;
            MockResponse policy = this.dispatcher.peek();
            BufferedSink requestBodySink = Okio.buffer((Sink)this.withThrottlingAndSocketPolicy(requestBody, policy, Intrinsics.areEqual((Object)policy.getSocketPolicy(), (Object)SocketPolicy.DisconnectDuringRequestBody.INSTANCE), contentLength, socket));
            Closeable closeable = (Closeable)requestBodySink;
            Throwable throwable = null;
            try {
                Unit unit;
                BufferedSink it = (BufferedSink)closeable;
                boolean bl = false;
                if (policy.getSocketPolicy() instanceof SocketPolicy.DoNotReadRequestBody) {
                    unit = Unit.INSTANCE;
                } else if (contentLength != -1L) {
                    hasBody = contentLength > 0L;
                    unit = requestBodySink.write((Source)source, contentLength);
                } else if (chunked) {
                    hasBody = true;
                    while (true) {
                        int chunkSize;
                        if ((chunkSize = Integer.parseInt(((Object)StringsKt.trim((CharSequence)source.readUtf8LineStrict())).toString(), CharsKt.checkRadix((int)16))) == 0) break;
                        chunkSizes.add(chunkSize);
                        requestBodySink.write((Source)source, (long)chunkSize);
                        this.readEmptyLine(source);
                    }
                    this.readEmptyLine(source);
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                it = unit;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String method = StringsKt.substringBefore$default((String)request, (char)' ', null, (int)2, null);
            if (!(!hasBody || HttpMethod.permitsRequestBody((String)method))) {
                boolean bl = false;
                String string = "Request must not have a body: " + request;
                throw new IllegalArgumentException(string.toString());
            }
        }
        catch (IOException e) {
            failure = e;
        }
        return new RecordedRequest(request, headers.build(), chunkSizes, requestBody.getReceivedByteCount(), requestBody.getBuffer(), sequenceNumber, socket, failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleWebSocketUpgrade(Socket socket, BufferedSource source, BufferedSink sink, RecordedRequest request, MockResponse response) throws IOException {
        String key = request.getHeaders().get("Sec-WebSocket-Key");
        MockResponse.Builder builder = response.newBuilder();
        String string = key;
        Intrinsics.checkNotNull((Object)string);
        MockResponse webSocketResponse = builder.setHeader("Sec-WebSocket-Accept", WebSocketProtocol.INSTANCE.acceptHeader(string)).build();
        this.writeHttpResponse(socket, sink, webSocketResponse);
        String scheme = request.getHandshake() != null ? "https" : "http";
        String authority = request.getHeaders().get("Host");
        Request fancyRequest = new Request.Builder().url(scheme + "://" + authority + '/').headers(request.getHeaders()).build();
        Response fancyResponse = new Response.Builder().code(webSocketResponse.getCode()).message(webSocketResponse.getMessage()).headers(webSocketResponse.getHeaders()).request(fancyRequest).protocol(Protocol.HTTP_1_1).build();
        CountDownLatch connectionClose = new CountDownLatch(1);
        RealWebSocket.Streams streams2 = new RealWebSocket.Streams(source, sink, connectionClose, socket){
            final /* synthetic */ CountDownLatch $connectionClose;
            final /* synthetic */ Socket $socket;
            {
                this.$connectionClose = $connectionClose;
                this.$socket = $socket;
                super(false, $source, $sink);
            }

            public void close() {
                this.$connectionClose.countDown();
            }

            public void cancel() {
                _UtilCommonKt.closeQuietly((Closeable)this.$socket);
            }
        };
        WebSocketListener webSocketListener = webSocketResponse.getWebSocketListener();
        Intrinsics.checkNotNull((Object)webSocketListener);
        RealWebSocket webSocket = new RealWebSocket(this.taskRunner, fancyRequest, webSocketListener, (Random)new SecureRandom(), 0L, WebSocketExtensions.Companion.parse(webSocketResponse.getHeaders()), 0L);
        StringBuilder stringBuilder = new StringBuilder().append("MockWebServer WebSocket ");
        String string2 = request.getPath();
        Intrinsics.checkNotNull((Object)string2);
        String name = stringBuilder.append(string2).toString();
        webSocket.initReaderAndWriter(name, streams2);
        try {
            webSocket.loopReader(fancyResponse);
            connectionClose.await();
        }
        finally {
            _UtilCommonKt.closeQuietly((Closeable)((Closeable)source));
        }
    }

    private final void writeHttpResponse(Socket socket, BufferedSink sink, MockResponse response) throws IOException {
        SleepKt.sleepNanos(response.getHeadersDelayNanos());
        sink.writeUtf8(response.getStatus());
        sink.writeUtf8("\r\n");
        this.writeHeaders(sink, response.getHeaders());
        MockResponseBody mockResponseBody = response.getBody();
        if (mockResponseBody == null) {
            return;
        }
        MockResponseBody body = mockResponseBody;
        SleepKt.sleepNanos(response.getBodyDelayNanos());
        BufferedSink responseBodySink = Okio.buffer((Sink)this.withThrottlingAndSocketPolicy((Sink)sink, response, Intrinsics.areEqual((Object)response.getSocketPolicy(), (Object)SocketPolicy.DisconnectDuringResponseBody.INSTANCE), body.getContentLength(), socket));
        body.writeTo(responseBodySink);
        responseBodySink.emit();
        if (StringsKt.equals((String)"chunked", (String)response.getHeaders().get("Transfer-Encoding"), (boolean)true)) {
            this.writeHeaders(sink, response.getTrailers());
        }
    }

    private final void writeHeaders(BufferedSink sink, Headers headers) throws IOException {
        for (Pair pair : headers) {
            String name = (String)pair.component1();
            String value = (String)pair.component2();
            sink.writeUtf8(name);
            sink.writeUtf8(": ");
            sink.writeUtf8(value);
            sink.writeUtf8("\r\n");
        }
        sink.writeUtf8("\r\n");
        sink.flush();
    }

    private final Sink withThrottlingAndSocketPolicy(Sink $this$withThrottlingAndSocketPolicy, MockResponse policy, boolean disconnectHalfway, long expectedByteCount, Socket socket) {
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = $this$withThrottlingAndSocketPolicy;
        if (policy.getThrottlePeriodNanos() > 0L) {
            result.element = new ThrottledSink((Sink)result.element, policy.getThrottleBytesPerPeriod(), policy.getThrottlePeriodNanos());
        }
        if (disconnectHalfway) {
            long halfwayByteCount = expectedByteCount != -1L ? expectedByteCount / (long)2 : 0L;
            result.element = new TriggerSink((Sink)result.element, halfwayByteCount, (Function0<Unit>)((Function0)new Function0<Unit>((Ref.ObjectRef<Sink>)result, socket){
                final /* synthetic */ Ref.ObjectRef<Sink> $result;
                final /* synthetic */ Socket $socket;
                {
                    this.$result = $result;
                    this.$socket = $socket;
                    super(0);
                }

                public final void invoke() {
                    ((Sink)this.$result.element).flush();
                    this.$socket.close();
                }
            }));
        }
        return (Sink)result.element;
    }

    private final void readEmptyLine(BufferedSource source) throws IOException {
        String line = source.readUtf8LineStrict();
        if (!(((CharSequence)line).length() == 0)) {
            boolean bl = false;
            String string = "Expected empty but was: " + line;
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public String toString() {
        return "MockWebServer[" + this.portField + ']';
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    @JvmOverloads
    public final void start() throws IOException {
        MockWebServer.start$default(this, 0, 1, null);
    }

    public static final /* synthetic */ void access$acceptConnections(MockWebServer $this) {
        $this.acceptConnections();
    }

    public static final /* synthetic */ ServerSocket access$getServerSocket$p(MockWebServer $this) {
        return $this.serverSocket;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000#\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lmockwebserver3/MockWebServer$Companion;", "", "()V", "CLIENT_AUTH_NONE", "", "CLIENT_AUTH_REQUESTED", "CLIENT_AUTH_REQUIRED", "UNTRUSTED_TRUST_MANAGER", "mockwebserver3/MockWebServer$Companion$UNTRUSTED_TRUST_MANAGER$1", "Lmockwebserver3/MockWebServer$Companion$UNTRUSTED_TRUST_MANAGER$1;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "mockwebserver3"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011*\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lmockwebserver3/MockWebServer$Http2SocketHandler;", "Lokhttp3/internal/http2/Http2Connection$Listener;", "socket", "Ljava/net/Socket;", "protocol", "Lokhttp3/Protocol;", "(Lmockwebserver3/MockWebServer;Ljava/net/Socket;Lokhttp3/Protocol;)V", "sequenceNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "onStream", "", "stream", "Lokhttp3/internal/http2/Http2Stream;", "pushPromises", "request", "Lmockwebserver3/RecordedRequest;", "promises", "", "Lmockwebserver3/PushPromise;", "readRequest", "writeResponse", "response", "Lmockwebserver3/MockResponse;", "toHttp2Headers", "Lokhttp3/internal/http2/Header;", "mockwebserver3"})
    private final class Http2SocketHandler
    extends Http2Connection.Listener {
        @NotNull
        private final Socket socket;
        @NotNull
        private final Protocol protocol;
        @NotNull
        private final AtomicInteger sequenceNumber;

        public Http2SocketHandler(@NotNull Socket socket, Protocol protocol) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            this.socket = socket;
            this.protocol = protocol;
            this.sequenceNumber = new AtomicInteger();
        }

        public void onStream(@NotNull Http2Stream stream) throws IOException {
            SocketPolicy socketPolicy;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            MockResponse peekedResponse = MockWebServer.this.getDispatcher().peek();
            if (peekedResponse.getSocketPolicy() instanceof SocketPolicy.ResetStreamAtStart) {
                MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber.getAndIncrement(), this.socket);
                ErrorCode errorCode = ErrorCode.Companion.fromHttp2(((SocketPolicy.ResetStreamAtStart)peekedResponse.getSocketPolicy()).getHttp2ErrorCode());
                Intrinsics.checkNotNull((Object)errorCode);
                stream.close(errorCode, null);
                return;
            }
            RecordedRequest request = this.readRequest(stream);
            MockWebServer.this.atomicRequestCount.incrementAndGet();
            MockWebServer.this.requestQueue.add(request);
            if (request.getFailure() != null) {
                return;
            }
            MockResponse response = MockWebServer.this.getDispatcher().dispatch(request);
            SocketPolicy socketPolicy2 = response.getSocketPolicy();
            if (socketPolicy2 == SocketPolicy.DisconnectAfterRequest.INSTANCE) {
                this.socket.close();
                return;
            }
            this.writeResponse(stream, request, response);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MockWebServer.this + " received request: " + request + " and responded: " + response + " protocol is " + this.protocol);
            }
            if (Intrinsics.areEqual((Object)(socketPolicy = socketPolicy2), (Object)SocketPolicy.DisconnectAtEnd.INSTANCE)) {
                stream.getConnection().shutdown(ErrorCode.NO_ERROR);
            } else if (socketPolicy instanceof SocketPolicy.DoNotReadRequestBody) {
                ErrorCode errorCode = ErrorCode.Companion.fromHttp2(((SocketPolicy.DoNotReadRequestBody)socketPolicy2).getHttp2ErrorCode());
                Intrinsics.checkNotNull((Object)errorCode);
                stream.close(errorCode, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final RecordedRequest readRequest(Http2Stream stream) throws IOException {
            Headers streamHeaders = Http2Stream.takeHeaders$default((Http2Stream)stream, (boolean)false, (int)1, null);
            Headers.Builder httpHeaders = new Headers.Builder();
            String method = "<:method omitted>";
            String path = "<:path omitted>";
            boolean readBody = true;
            for (Pair pair : streamHeaders) {
                String name = (String)pair.component1();
                String value = (String)pair.component2();
                if (Intrinsics.areEqual((Object)name, (Object)":method")) {
                    method = value;
                } else if (Intrinsics.areEqual((Object)name, (Object)":path")) {
                    path = value;
                } else if (this.protocol == Protocol.HTTP_2 || this.protocol == Protocol.H2_PRIOR_KNOWLEDGE) {
                    httpHeaders.add(name, value);
                } else {
                    throw new IllegalStateException();
                }
                if (!Intrinsics.areEqual((Object)name, (Object)"expect") || !StringsKt.equals((String)value, (String)"100-continue", (boolean)true)) continue;
                readBody = false;
            }
            Headers headers = httpHeaders.build();
            MockResponse peek = MockWebServer.this.getDispatcher().peek();
            for (MockResponse response : peek.getInformationalResponses()) {
                SleepKt.sleepNanos(response.getHeadersDelayNanos());
                stream.writeHeaders(this.toHttp2Headers(response), false, true);
                if (response.getCode() != 100) continue;
                readBody = true;
            }
            Buffer body = new Buffer();
            String requestLine = method + ' ' + path + " HTTP/1.1";
            IOException exception = null;
            if (readBody && peek.getStreamHandler() == null && !(peek.getSocketPolicy() instanceof SocketPolicy.DoNotReadRequestBody)) {
                try {
                    String contentLengthString = headers.get("content-length");
                    String string = contentLengthString;
                    BufferedSink requestBodySink = Okio.buffer((Sink)MockWebServer.this.withThrottlingAndSocketPolicy((Sink)body, peek, Intrinsics.areEqual((Object)peek.getSocketPolicy(), (Object)SocketPolicy.DisconnectDuringRequestBody.INSTANCE), string != null ? Long.parseLong(string) : Long.MAX_VALUE, this.socket));
                    Closeable closeable = (Closeable)requestBodySink;
                    Throwable throwable = null;
                    try {
                        BufferedSink it = (BufferedSink)closeable;
                        boolean bl = false;
                        long l = it.writeAll(stream.getSource());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            return new RecordedRequest(requestLine, headers, CollectionsKt.emptyList(), body.size(), body, this.sequenceNumber.getAndIncrement(), this.socket, exception);
        }

        private final List<Header> toHttp2Headers(MockResponse $this$toHttp2Headers) {
            List result = new ArrayList();
            ((Collection)result).add(new Header(Header.RESPONSE_STATUS, String.valueOf($this$toHttp2Headers.getCode())));
            for (Pair pair : $this$toHttp2Headers.getHeaders()) {
                String name = (String)pair.component1();
                String value = (String)pair.component2();
                ((Collection)result).add(new Header(name, value));
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void writeResponse(Http2Stream stream, RecordedRequest request, MockResponse response) throws IOException {
            Settings settings = response.getSettings();
            stream.getConnection().setSettings(settings);
            if (response.getSocketPolicy() == SocketPolicy.NoResponse.INSTANCE) {
                return;
            }
            long bodyDelayNanos = response.getBodyDelayNanos();
            Headers trailers = response.getTrailers();
            MockResponseBody body = response.getBody();
            StreamHandler streamHandler = response.getStreamHandler();
            boolean outFinished = body == null && response.getPushPromises().isEmpty() && streamHandler == null;
            boolean flushHeaders = body == null || bodyDelayNanos != 0L;
            if (!(!outFinished || trailers.size() == 0)) {
                boolean bl = false;
                String string = "unsupported: no body and non-empty trailers " + trailers;
                throw new IllegalArgumentException(string.toString());
            }
            SleepKt.sleepNanos(response.getHeadersDelayNanos());
            stream.writeHeaders(this.toHttp2Headers(response), outFinished, flushHeaders);
            if (trailers.size() > 0) {
                stream.enqueueTrailers(trailers);
            }
            this.pushPromises(stream, request, response.getPushPromises());
            if (body != null) {
                SleepKt.sleepNanos(bodyDelayNanos);
                BufferedSink responseBodySink = Okio.buffer((Sink)MockWebServer.this.withThrottlingAndSocketPolicy(stream.getSink(), response, Intrinsics.areEqual((Object)response.getSocketPolicy(), (Object)SocketPolicy.DisconnectDuringResponseBody.INSTANCE), body.getContentLength(), this.socket));
                Closeable closeable = (Closeable)responseBodySink;
                Throwable throwable = null;
                try {
                    BufferedSink it = (BufferedSink)closeable;
                    boolean bl = false;
                    body.writeTo(responseBodySink);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else if (streamHandler != null) {
                streamHandler.handle(new RealStream(stream));
            } else if (!outFinished) {
                stream.close(ErrorCode.NO_ERROR, null);
            }
        }

        private final void pushPromises(Http2Stream stream, RecordedRequest request, List<PushPromise> promises) throws IOException {
            for (PushPromise pushPromise : promises) {
                List pushedHeaders = new ArrayList();
                pushedHeaders.add(new Header(Header.TARGET_AUTHORITY, MockWebServer.this.url(pushPromise.getPath()).host()));
                pushedHeaders.add(new Header(Header.TARGET_METHOD, pushPromise.getMethod()));
                pushedHeaders.add(new Header(Header.TARGET_PATH, pushPromise.getPath()));
                Headers pushPromiseHeaders = pushPromise.getHeaders();
                for (Pair pair : pushPromiseHeaders) {
                    String name = (String)pair.component1();
                    String value = (String)pair.component2();
                    pushedHeaders.add(new Header(name, value));
                }
                String requestLine = pushPromise.getMethod() + ' ' + pushPromise.getPath() + " HTTP/1.1";
                List chunkSizes = CollectionsKt.emptyList();
                MockWebServer.this.requestQueue.add(new RecordedRequest(requestLine, pushPromise.getHeaders(), chunkSizes, 0L, new Buffer(), this.sequenceNumber.getAndIncrement(), this.socket, null, 128, null));
                boolean hasBody = pushPromise.getResponse().getBody() != null;
                Http2Stream pushedStream = stream.getConnection().pushStream(stream.getId(), pushedHeaders, hasBody);
                this.writeResponse(pushedStream, request, pushPromise.getResponse());
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lmockwebserver3/MockWebServer$SocketHandler;", "", "raw", "Ljava/net/Socket;", "(Lmockwebserver3/MockWebServer;Ljava/net/Socket;)V", "sequenceNumber", "", "handle", "", "processOneRequest", "", "socket", "source", "Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "processTunnelRequests", "mockwebserver3"})
    public final class SocketHandler {
        @NotNull
        private final Socket raw;
        private int sequenceNumber;

        public SocketHandler(Socket raw) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            this.raw = raw;
        }

        public final void handle() throws Exception {
            if (!this.processTunnelRequests()) {
                return;
            }
            SocketPolicy socketPolicy = MockWebServer.this.getDispatcher().peek().getSocketPolicy();
            Protocol protocol = null;
            Socket socket = null;
            if (MockWebServer.this.sslSocketFactory != null) {
                if (socketPolicy == SocketPolicy.FailHandshake.INSTANCE) {
                    MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, this.raw);
                    MockWebServer.this.processHandshakeFailure(this.raw);
                    return;
                }
                SSLSocketFactory sSLSocketFactory = MockWebServer.this.sslSocketFactory;
                Intrinsics.checkNotNull((Object)sSLSocketFactory);
                Socket socket2 = sSLSocketFactory.createSocket(this.raw, this.raw.getInetAddress().getHostAddress(), this.raw.getPort(), true);
                Intrinsics.checkNotNullExpressionValue((Object)socket2, (String)"createSocket(...)");
                socket = socket2;
                SSLSocket sslSocket = (SSLSocket)socket;
                sslSocket.setUseClientMode(false);
                if (MockWebServer.this.clientAuth == 2) {
                    sslSocket.setNeedClientAuth(true);
                } else if (MockWebServer.this.clientAuth == 1) {
                    sslSocket.setWantClientAuth(true);
                }
                MockWebServer.this.openClientSockets.add(socket);
                if (MockWebServer.this.getProtocolNegotiationEnabled()) {
                    Platform.Companion.get().configureTlsExtensions(sslSocket, null, MockWebServer.this.getProtocols());
                }
                sslSocket.startHandshake();
                if (MockWebServer.this.getProtocolNegotiationEnabled()) {
                    String protocolString = Platform.Companion.get().getSelectedProtocol(sslSocket);
                    String string = protocolString;
                    protocol = string != null ? Protocol.Companion.get(string) : Protocol.HTTP_1_1;
                    Platform.Companion.get().afterHandshake(sslSocket);
                } else {
                    protocol = Protocol.HTTP_1_1;
                }
                MockWebServer.this.openClientSockets.remove(this.raw);
            } else {
                protocol = MockWebServer.this.getProtocols().contains(Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_1_1;
                socket = this.raw;
            }
            if (socketPolicy == SocketPolicy.StallSocketAtStart.INSTANCE) {
                MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, socket);
                return;
            }
            if (protocol == Protocol.HTTP_2 || protocol == Protocol.H2_PRIOR_KNOWLEDGE) {
                Http2SocketHandler http2SocketHandler = new Http2SocketHandler(socket, protocol);
                Http2Connection connection = Http2Connection.Builder.socket$default((Http2Connection.Builder)new Http2Connection.Builder(false, MockWebServer.this.taskRunner), (Socket)socket, null, null, null, (int)14, null).listener((Http2Connection.Listener)http2SocketHandler).build();
                Http2Connection.start$default((Http2Connection)connection, (boolean)false, (int)1, null);
                MockWebServer.this.openConnections.add(connection);
                MockWebServer.this.openClientSockets.remove(socket);
                return;
            }
            if (protocol != Protocol.HTTP_1_1) {
                throw new AssertionError();
            }
            BufferedSource source = Okio.buffer((Source)Okio.source((Socket)socket));
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((Socket)socket));
            while (this.processOneRequest(socket, source, sink)) {
            }
            if (this.sequenceNumber == 0) {
                logger.warning(MockWebServer.this + " connection from " + this.raw.getInetAddress() + " didn't make a request");
            }
            socket.close();
            MockWebServer.this.openClientSockets.remove(socket);
        }

        private final boolean processTunnelRequests() throws IOException, InterruptedException {
            if (!MockWebServer.this.getDispatcher().peek().getInTunnel()) {
                return true;
            }
            BufferedSource source = Okio.buffer((Source)Okio.source((Socket)this.raw));
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((Socket)this.raw));
            do {
                boolean socketStillGood;
                if (socketStillGood = this.processOneRequest(this.raw, source, sink)) continue;
                this.raw.close();
                MockWebServer.this.openClientSockets.remove(this.raw);
                return false;
            } while (MockWebServer.this.getDispatcher().peek().getInTunnel());
            return true;
        }

        private final boolean processOneRequest(Socket socket, BufferedSource source, BufferedSink sink) throws IOException, InterruptedException {
            SocketPolicy socketPolicy;
            boolean responseWantsWebSockets;
            if (source.exhausted()) {
                return false;
            }
            RecordedRequest request = MockWebServer.this.readRequest(socket, source, sink, this.sequenceNumber);
            MockWebServer.this.atomicRequestCount.incrementAndGet();
            MockWebServer.this.requestQueue.add(request);
            if (request.getFailure() != null) {
                return false;
            }
            MockResponse response = MockWebServer.this.getDispatcher().dispatch(request);
            if (response.getSocketPolicy() == SocketPolicy.DisconnectAfterRequest.INSTANCE) {
                socket.close();
                return false;
            }
            if (response.getSocketPolicy() == SocketPolicy.HalfCloseAfterRequest.INSTANCE) {
                socket.shutdownOutput();
                return false;
            }
            if (response.getSocketPolicy() == SocketPolicy.NoResponse.INSTANCE) {
                if (source.exhausted()) {
                    return false;
                }
                throw new ProtocolException("unexpected data");
            }
            boolean reuseSocket = true;
            boolean requestWantsWebSockets = StringsKt.equals((String)"Upgrade", (String)request.getHeaders().get("Connection"), (boolean)true) && StringsKt.equals((String)"websocket", (String)request.getHeaders().get("Upgrade"), (boolean)true);
            boolean bl = responseWantsWebSockets = response.getWebSocketListener() != null;
            if (requestWantsWebSockets && responseWantsWebSockets) {
                MockWebServer.this.handleWebSocketUpgrade(socket, source, sink, request, response);
                reuseSocket = false;
            } else {
                MockWebServer.this.writeHttpResponse(socket, sink, response);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MockWebServer.this + " received request: " + request + " and responded: " + response);
            }
            if (Intrinsics.areEqual((Object)(socketPolicy = response.getSocketPolicy()), (Object)SocketPolicy.DisconnectAtEnd.INSTANCE) ? true : socketPolicy instanceof SocketPolicy.DoNotReadRequestBody) {
                socket.close();
                return false;
            }
            if (Intrinsics.areEqual((Object)socketPolicy, (Object)SocketPolicy.ShutdownInputAtEnd.INSTANCE)) {
                socket.shutdownInput();
            } else if (Intrinsics.areEqual((Object)socketPolicy, (Object)SocketPolicy.ShutdownOutputAtEnd.INSTANCE)) {
                socket.shutdownOutput();
            } else if (Intrinsics.areEqual((Object)socketPolicy, (Object)SocketPolicy.ShutdownServerAfterResponse.INSTANCE)) {
                MockWebServer.this.shutdown();
            }
            int n = this.sequenceNumber;
            this.sequenceNumber = n + 1;
            return reuseSocket;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lmockwebserver3/MockWebServer$TruncatingBuffer;", "Lokio/Sink;", "remainingByteCount", "", "(J)V", "buffer", "Lokio/Buffer;", "getBuffer", "()Lokio/Buffer;", "receivedByteCount", "getReceivedByteCount", "()J", "setReceivedByteCount", "close", "", "flush", "timeout", "Lokio/Timeout;", "write", "source", "byteCount", "mockwebserver3"})
    private static final class TruncatingBuffer
    implements Sink {
        private long remainingByteCount;
        @NotNull
        private final Buffer buffer;
        private long receivedByteCount;

        public TruncatingBuffer(long remainingByteCount) {
            this.remainingByteCount = remainingByteCount;
            this.buffer = new Buffer();
        }

        @NotNull
        public final Buffer getBuffer() {
            return this.buffer;
        }

        public final long getReceivedByteCount() {
            return this.receivedByteCount;
        }

        public final void setReceivedByteCount(long l) {
            this.receivedByteCount = l;
        }

        public void write(@NotNull Buffer source, long byteCount) throws IOException {
            long toSkip;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            long toRead = Math.min(this.remainingByteCount, byteCount);
            if (toRead > 0L) {
                source.read(this.buffer, toRead);
            }
            if ((toSkip = byteCount - toRead) > 0L) {
                source.skip(toSkip);
            }
            this.remainingByteCount -= toRead;
            this.receivedByteCount += byteCount;
        }

        public void flush() throws IOException {
        }

        @NotNull
        public Timeout timeout() {
            return Timeout.NONE;
        }

        public void close() throws IOException {
        }
    }
}

