/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.internal.Internal;

public final class JavaNetCookieJar
implements CookieJar {
    private final CookieHandler cookieHandler;

    public JavaNetCookieJar(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        if (this.cookieHandler != null) {
            ArrayList<String> cookieStrings = new ArrayList<String>();
            for (Cookie cookie : cookies) {
                cookieStrings.add(cookie.toString());
            }
            Map<String, List<String>> multimap = Collections.singletonMap("Set-Cookie", cookieStrings);
            try {
                this.cookieHandler.put(url.uri(), multimap);
            }
            catch (IOException e) {
                Internal.logger.log(Level.WARNING, "Saving cookies failed for " + url.resolve("/..."), e);
            }
        }
    }

    public List<Cookie> loadForRequest(HttpUrl url) {
        Map<String, List<String>> cookieHeaders;
        Map<String, List<String>> headers = Collections.emptyMap();
        try {
            cookieHeaders = this.cookieHandler.get(url.uri(), headers);
        }
        catch (IOException e) {
            Internal.logger.log(Level.WARNING, "Loading cookies failed for " + url.resolve("/..."), e);
            return Collections.emptyList();
        }
        ArrayList<Cookie> cookies = null;
        for (Map.Entry<String, List<String>> entry : cookieHeaders.entrySet()) {
            String key = entry.getKey();
            if (!"Cookie".equalsIgnoreCase(key) && !"Cookie2".equalsIgnoreCase(key) || entry.getValue().isEmpty()) continue;
            for (String header : entry.getValue()) {
                if (cookies == null) {
                    cookies = new ArrayList<Cookie>();
                }
                cookies.addAll(this.decodeHeaderAsJavaNetCookies(url, header));
            }
        }
        return cookies != null ? Collections.unmodifiableList(cookies) : Collections.emptyList();
    }

    private List<Cookie> decodeHeaderAsJavaNetCookies(HttpUrl url, String header) {
        List<HttpCookie> javaNetCookies;
        try {
            javaNetCookies = HttpCookie.parse(header);
        }
        catch (IllegalArgumentException e) {
            Internal.logger.log(Level.WARNING, "Parsing request cookie failed for " + url.resolve("/..."), e);
            return Collections.emptyList();
        }
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        for (HttpCookie javaNetCookie : javaNetCookies) {
            result.add(new Cookie.Builder().name(javaNetCookie.getName()).value(javaNetCookie.getValue()).domain(url.host()).build());
        }
        return result;
    }
}

