/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Cache;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/cache/CacheInterceptor;", "Lokhttp3/Interceptor;", "cache", "Lokhttp3/Cache;", "(Lokhttp3/Cache;)V", "getCache$okhttp", "()Lokhttp3/Cache;", "cacheWritingResponse", "Lokhttp3/Response;", "cacheRequest", "Lokhttp3/internal/cache/CacheRequest;", "response", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "okhttp"})
public final class CacheInterceptor
implements Interceptor {
    @Nullable
    private final Cache cache;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response networkResponse;
        Response cacheResponse;
        Request networkRequest;
        block23: {
            ResponseBody responseBody;
            Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
            Cache cache = this.cache;
            Response cacheCandidate = cache != null ? cache.get$okhttp(chain.request()) : null;
            long now = System.currentTimeMillis();
            CacheStrategy strategy = new CacheStrategy.Factory(now, chain.request(), cacheCandidate).compute();
            networkRequest = strategy.getNetworkRequest();
            cacheResponse = strategy.getCacheResponse();
            Cache cache2 = this.cache;
            if (cache2 != null) {
                cache2.trackResponse$okhttp(strategy);
            }
            if (cacheCandidate != null && cacheResponse == null) {
                ResponseBody responseBody2 = cacheCandidate.body();
                if (responseBody2 != null) {
                    Util.closeQuietly(responseBody2);
                }
            }
            if (networkRequest == null && cacheResponse == null) {
                return new Response.Builder().request(chain.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
            }
            if (networkRequest == null) {
                Response response = cacheResponse;
                if (response == null) {
                    Intrinsics.throwNpe();
                }
                return response.newBuilder().cacheResponse(CacheInterceptor.Companion.stripBody(cacheResponse)).build();
            }
            networkResponse = null;
            try {
                networkResponse = chain.proceed(networkRequest);
                if (networkResponse != null || cacheCandidate == null) break block23;
                responseBody = cacheCandidate.body();
            }
            catch (Throwable throwable) {
                if (cacheCandidate != null) {
                    ResponseBody responseBody3 = cacheCandidate.body();
                    if (responseBody3 != null) {
                        Util.closeQuietly(responseBody3);
                    }
                }
                throw throwable;
            }
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
        }
        if (cacheResponse != null) {
            Response response = networkResponse;
            if (response != null) {
                if (response.code() == 304) {
                    Response response2 = cacheResponse.newBuilder().headers(CacheInterceptor.Companion.combine(cacheResponse.headers(), networkResponse.headers())).sentRequestAtMillis(networkResponse.sentRequestAtMillis()).receivedResponseAtMillis(networkResponse.receivedResponseAtMillis()).cacheResponse(CacheInterceptor.Companion.stripBody(cacheResponse)).networkResponse(CacheInterceptor.Companion.stripBody(networkResponse)).build();
                    ResponseBody responseBody = networkResponse.body();
                    if (responseBody == null) {
                        Intrinsics.throwNpe();
                    }
                    responseBody.close();
                    Cache cache = this.cache;
                    if (cache == null) {
                        Intrinsics.throwNpe();
                    }
                    cache.trackConditionalCacheHit$okhttp();
                    this.cache.update$okhttp(cacheResponse, response2);
                    return response2;
                }
            }
            ResponseBody responseBody = cacheResponse.body();
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
        }
        Response response = networkResponse;
        if (response == null) {
            Intrinsics.throwNpe();
        }
        Response response3 = response.newBuilder().cacheResponse(CacheInterceptor.Companion.stripBody(cacheResponse)).networkResponse(CacheInterceptor.Companion.stripBody(networkResponse)).build();
        if (this.cache != null) {
            if (HttpHeaders.promisesBody(response3) && CacheStrategy.Companion.isCacheable(response3, networkRequest)) {
                CacheRequest cacheRequest = this.cache.put$okhttp(response3);
                return this.cacheWritingResponse(cacheRequest, response3);
            }
            if (HttpMethod.INSTANCE.invalidatesCache(networkRequest.method())) {
                try {
                    this.cache.remove$okhttp(networkRequest);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return response3;
    }

    private final Response cacheWritingResponse(CacheRequest cacheRequest, Response response) throws IOException {
        if (cacheRequest == null) {
            return response;
        }
        Sink cacheBodyUnbuffered = cacheRequest.body();
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        BufferedSource source = responseBody.source();
        BufferedSink cacheBody = Okio.buffer((Sink)cacheBodyUnbuffered);
        Source cacheWritingSource2 = new Source(source, cacheRequest, cacheBody){
            private boolean cacheRequestClosed;
            final /* synthetic */ BufferedSource $source;
            final /* synthetic */ CacheRequest $cacheRequest;
            final /* synthetic */ BufferedSink $cacheBody;

            public final boolean getCacheRequestClosed() {
                return this.cacheRequestClosed;
            }

            public final void setCacheRequestClosed(boolean bl) {
                this.cacheRequestClosed = bl;
            }

            public long read(@NotNull Buffer sink, long byteCount) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                long bytesRead = 0L;
                try {
                    bytesRead = this.$source.read(sink, byteCount);
                }
                catch (IOException e) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        this.$cacheRequest.abort();
                    }
                    throw (Throwable)e;
                }
                if (bytesRead == -1L) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        this.$cacheBody.close();
                    }
                    return -1L;
                }
                sink.copyTo(this.$cacheBody.getBuffer(), sink.size() - bytesRead, bytesRead);
                this.$cacheBody.emitCompleteSegments();
                return bytesRead;
            }

            @NotNull
            public Timeout timeout() {
                return this.$source.timeout();
            }

            public void close() throws IOException {
                if (!this.cacheRequestClosed && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                    this.cacheRequestClosed = true;
                    this.$cacheRequest.abort();
                }
                this.$source.close();
            }
            {
                this.$source = $captured_local_variable$0;
                this.$cacheRequest = $captured_local_variable$1;
                this.$cacheBody = $captured_local_variable$2;
            }
        };
        String contentType = Response.header$default(response, "Content-Type", null, 2, null);
        ResponseBody responseBody2 = response.body();
        if (responseBody2 == null) {
            Intrinsics.throwNpe();
        }
        long contentLength = responseBody2.contentLength();
        return response.newBuilder().body(new RealResponseBody(contentType, contentLength, Okio.buffer((Source)cacheWritingSource2))).build();
    }

    @Nullable
    public final Cache getCache$okhttp() {
        return this.cache;
    }

    public CacheInterceptor(@Nullable Cache cache) {
        this.cache = cache;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u000f"}, d2={"Lokhttp3/internal/cache/CacheInterceptor$Companion;", "", "()V", "combine", "Lokhttp3/Headers;", "cachedHeaders", "networkHeaders", "isContentSpecificHeader", "", "fieldName", "", "isEndToEnd", "stripBody", "Lokhttp3/Response;", "response", "okhttp"})
    public static final class Companion {
        private final Response stripBody(Response response) {
            Response response2 = response;
            return (response2 != null ? response2.body() : null) != null ? response.newBuilder().body(null).build() : response;
        }

        private final Headers combine(Headers cachedHeaders, Headers networkHeaders) {
            String fieldName;
            int index;
            Headers.Builder result = new Headers.Builder();
            int n = 0;
            int n2 = ((Collection)cachedHeaders.names()).size();
            while (n < n2) {
                fieldName = cachedHeaders.name(index);
                String value = cachedHeaders.value(index);
                if (!(StringsKt.equals((String)"Warning", (String)fieldName, (boolean)true) && StringsKt.startsWith$default((String)value, (String)"1", (boolean)false, (int)2, null) || !this.isContentSpecificHeader(fieldName) && this.isEndToEnd(fieldName) && networkHeaders.get(fieldName) != null)) {
                    result.addLenient$okhttp(fieldName, value);
                }
                ++index;
            }
            n2 = ((Collection)networkHeaders.names()).size();
            for (index = 0; index < n2; ++index) {
                fieldName = networkHeaders.name(index);
                if (this.isContentSpecificHeader(fieldName) || !this.isEndToEnd(fieldName)) continue;
                result.addLenient$okhttp(fieldName, networkHeaders.value(index));
            }
            return result.build();
        }

        private final boolean isEndToEnd(String fieldName) {
            return !StringsKt.equals((String)"Connection", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Keep-Alive", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authenticate", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authorization", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"TE", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Trailers", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Transfer-Encoding", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Upgrade", (String)fieldName, (boolean)true);
        }

        private final boolean isContentSpecificHeader(String fieldName) {
            return StringsKt.equals((String)"Content-Length", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Encoding", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Type", (String)fieldName, (boolean)true);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

