//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[readUtf8](read-utf8.md)

# readUtf8

[common]\
abstract fun [readUtf8](read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)

Removes all bytes from this, decodes them as UTF-8, and returns the string. Returns the empty string if this source is empty.

Buffer buffer = new Buffer()\
    .writeUtf8("Uh uh uh!")\
    .writeByte(' ')\
    .writeUtf8("You didn't say the magic word!");\
\
assertEquals("Uh uh uh! You didn't say the magic word!", buffer.readUtf8());\
assertEquals(0, buffer.size());\
\
assertEquals("", buffer.readUtf8());\
assertEquals(0, buffer.size());

[jvm, nonJvm]\
[jvm, nonJvm]\
abstract fun [readUtf8](read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)

[jvm, nonJvm]\
abstract fun [readUtf8](read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)

[common]\
abstract fun [readUtf8](read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)

Removes byteCount bytes from this, decodes them as UTF-8, and returns the string.

Buffer buffer = new Buffer()\
    .writeUtf8("Uh uh uh!")\
    .writeByte(' ')\
    .writeUtf8("You didn't say the magic word!");\
assertEquals(40, buffer.size());\
\
assertEquals("Uh uh uh! You ", buffer.readUtf8(14));\
assertEquals(26, buffer.size());\
\
assertEquals("didn't say the", buffer.readUtf8(14));\
assertEquals(12, buffer.size());\
\
assertEquals(" magic word!", buffer.readUtf8(12));\
assertEquals(0, buffer.size());
