/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import android.net.Uri;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.RequestBody;
import retrofit2.Converter;
import retrofit2.RequestBuilder;
import retrofit2.Utils;

abstract class RequestAction<T> {
    RequestAction() {
    }

    abstract void perform(RequestBuilder var1, T var2) throws IOException;

    final RequestAction<Iterable<T>> iterable() {
        return new RequestAction<Iterable<T>>(){

            @Override
            void perform(RequestBuilder builder, Iterable<T> values) throws IOException {
                if (values == null) {
                    return;
                }
                for (Object value : values) {
                    RequestAction.this.perform(builder, value);
                }
            }
        };
    }

    final RequestAction<Object> array() {
        return new RequestAction<Object>(){

            @Override
            void perform(RequestBuilder builder, Object values) throws IOException {
                if (values == null) {
                    return;
                }
                int size = Array.getLength(values);
                for (int i = 0; i < size; ++i) {
                    RequestAction.this.perform(builder, Array.get(values, i));
                }
            }
        };
    }

    static final class Body<T>
    extends RequestAction<T> {
        private final Converter<T, RequestBody> converter;

        Body(Converter<T, RequestBody> converter) {
            this.converter = converter;
        }

        @Override
        void perform(RequestBuilder builder, T value) {
            RequestBody body;
            if (value == null) {
                throw new IllegalArgumentException("Body parameter value must not be null.");
            }
            try {
                body = this.converter.convert(value);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to convert " + value + " to RequestBody", e);
            }
            builder.setBody(body);
        }
    }

    static final class PartMap<T>
    extends RequestAction<Map<String, T>> {
        private final Converter<T, RequestBody> valueConverter;
        private final String transferEncoding;

        PartMap(Converter<T, RequestBody> valueConverter, String transferEncoding) {
            this.valueConverter = valueConverter;
            this.transferEncoding = transferEncoding;
        }

        @Override
        void perform(RequestBuilder builder, Map<String, T> value) throws IOException {
            if (value == null) {
                return;
            }
            for (Map.Entry<String, T> entry : value.entrySet()) {
                String entryKey = entry.getKey();
                if (entryKey == null) {
                    throw new IllegalArgumentException("Part map contained null key.");
                }
                T entryValue = entry.getValue();
                if (entryValue == null) continue;
                Headers headers = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + entryKey + "\"", "Content-Transfer-Encoding", this.transferEncoding});
                builder.addPart(headers, this.valueConverter.convert(entryValue));
            }
        }
    }

    static final class Part<T>
    extends RequestAction<T> {
        private final Headers headers;
        private final Converter<T, RequestBody> converter;

        Part(Headers headers, Converter<T, RequestBody> converter) {
            this.headers = headers;
            this.converter = converter;
        }

        @Override
        void perform(RequestBuilder builder, T value) {
            RequestBody body;
            if (value == null) {
                return;
            }
            try {
                body = this.converter.convert(value);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to convert " + value + " to RequestBody", e);
            }
            builder.addPart(this.headers, body);
        }
    }

    static final class FieldMap<T>
    extends RequestAction<Map<String, T>> {
        private final Converter<T, String> valueConverter;
        private final boolean encoded;

        FieldMap(Converter<T, String> valueConverter, boolean encoded) {
            this.valueConverter = valueConverter;
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, Map<String, T> value) throws IOException {
            if (value == null) {
                return;
            }
            for (Map.Entry<String, T> entry : value.entrySet()) {
                String entryKey = entry.getKey();
                if (entryKey == null) {
                    throw new IllegalArgumentException("Field map contained null key.");
                }
                T entryValue = entry.getValue();
                if (entryValue == null) continue;
                builder.addFormField(entryKey, this.valueConverter.convert(entryValue), this.encoded);
            }
        }
    }

    static final class Field<T>
    extends RequestAction<T> {
        private final String name;
        private final Converter<T, String> valueConverter;
        private final boolean encoded;

        Field(String name, Converter<T, String> valueConverter, boolean encoded) {
            this.name = Utils.checkNotNull(name, "name == null");
            this.valueConverter = valueConverter;
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, T value) throws IOException {
            if (value == null) {
                return;
            }
            builder.addFormField(this.name, this.valueConverter.convert(value), this.encoded);
        }
    }

    static final class QueryMap<T>
    extends RequestAction<Map<String, T>> {
        private final Converter<T, String> valueConverter;
        private final boolean encoded;

        QueryMap(Converter<T, String> valueConverter, boolean encoded) {
            this.valueConverter = valueConverter;
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, Map<String, T> value) throws IOException {
            if (value == null) {
                return;
            }
            for (Map.Entry<String, T> entry : value.entrySet()) {
                String entryKey = entry.getKey();
                if (entryKey == null) {
                    throw new IllegalArgumentException("Query map contained null key.");
                }
                T entryValue = entry.getValue();
                if (entryValue == null) continue;
                builder.addQueryParam(entryKey, this.valueConverter.convert(entryValue), this.encoded);
            }
        }
    }

    static final class Query<T>
    extends RequestAction<T> {
        private final String name;
        private final Converter<T, String> valueConverter;
        private final boolean encoded;

        Query(String name, Converter<T, String> valueConverter, boolean encoded) {
            this.name = Utils.checkNotNull(name, "name == null");
            this.valueConverter = valueConverter;
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, T value) throws IOException {
            if (value == null) {
                return;
            }
            builder.addQueryParam(this.name, this.valueConverter.convert(value), this.encoded);
        }
    }

    static final class Path<T>
    extends RequestAction<T> {
        private final String name;
        private final Converter<T, String> valueConverter;
        private final boolean encoded;

        Path(String name, Converter<T, String> valueConverter, boolean encoded) {
            this.name = Utils.checkNotNull(name, "name == null");
            this.valueConverter = valueConverter;
            this.encoded = encoded;
        }

        @Override
        void perform(RequestBuilder builder, T value) throws IOException {
            if (value == null) {
                throw new IllegalArgumentException("Path parameter \"" + this.name + "\" value must not be null.");
            }
            builder.addPathParam(this.name, this.valueConverter.convert(value), this.encoded);
        }
    }

    static final class Header<T>
    extends RequestAction<T> {
        private final String name;
        private final Converter<T, String> valueConverter;

        Header(String name, Converter<T, String> valueConverter) {
            this.name = Utils.checkNotNull(name, "name == null");
            this.valueConverter = valueConverter;
        }

        @Override
        void perform(RequestBuilder builder, T value) throws IOException {
            if (value == null) {
                return;
            }
            builder.addHeader(this.name, this.valueConverter.convert(value));
        }
    }

    static final class AndroidUriUrl
    extends RequestAction<Uri> {
        AndroidUriUrl() {
        }

        @Override
        void perform(RequestBuilder builder, Uri value) {
            builder.setRelativeUrl(value.toString());
        }
    }

    static final class JavaUriUrl
    extends RequestAction<URI> {
        JavaUriUrl() {
        }

        @Override
        void perform(RequestBuilder builder, URI value) {
            builder.setRelativeUrl(value.toString());
        }
    }

    static final class StringUrl
    extends RequestAction<String> {
        StringUrl() {
        }

        @Override
        void perform(RequestBuilder builder, String value) {
            builder.setRelativeUrl(value);
        }
    }
}

