/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.BaseUrl;
import retrofit2.BuiltInConverters;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.MethodHandler;
import retrofit2.Platform;
import retrofit2.Utils;

public final class Retrofit {
    private final Map<Method, MethodHandler> methodHandlerCache = new LinkedHashMap<Method, MethodHandler>();
    private final Call.Factory callFactory;
    private final BaseUrl baseUrl;
    private final List<Converter.Factory> converterFactories;
    private final List<CallAdapter.Factory> adapterFactories;
    private final Executor callbackExecutor;
    private final boolean validateEagerly;

    Retrofit(Call.Factory callFactory, BaseUrl baseUrl, List<Converter.Factory> converterFactories, List<CallAdapter.Factory> adapterFactories, Executor callbackExecutor, boolean validateEagerly) {
        this.callFactory = callFactory;
        this.baseUrl = baseUrl;
        this.converterFactories = converterFactories;
        this.adapterFactories = adapterFactories;
        this.callbackExecutor = callbackExecutor;
        this.validateEagerly = validateEagerly;
    }

    public <T> T create(final Class<T> service) {
        Utils.validateServiceInterface(service);
        if (this.validateEagerly) {
            this.eagerlyValidateMethods(service);
        }
        return (T)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service}, new InvocationHandler(){
            private final Platform platform = Platform.get();

            @Override
            public Object invoke(Object proxy, Method method, Object ... args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                if (this.platform.isDefaultMethod(method)) {
                    return this.platform.invokeDefaultMethod(method, service, proxy, args);
                }
                return Retrofit.this.loadMethodHandler(method).invoke(args);
            }
        });
    }

    private void eagerlyValidateMethods(Class<?> service) {
        Platform platform = Platform.get();
        for (Method method : service.getDeclaredMethods()) {
            if (platform.isDefaultMethod(method)) continue;
            this.loadMethodHandler(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodHandler loadMethodHandler(Method method) {
        MethodHandler handler;
        Map<Method, MethodHandler> map = this.methodHandlerCache;
        synchronized (map) {
            handler = this.methodHandlerCache.get(method);
            if (handler == null) {
                handler = MethodHandler.create(this, method);
                this.methodHandlerCache.put(method, handler);
            }
        }
        return handler;
    }

    public Call.Factory callFactory() {
        return this.callFactory;
    }

    public BaseUrl baseUrl() {
        return this.baseUrl;
    }

    public List<CallAdapter.Factory> callAdapterFactories() {
        return Collections.unmodifiableList(this.adapterFactories);
    }

    public CallAdapter<?> callAdapter(Type returnType, Annotation[] annotations) {
        return this.nextCallAdapter(null, returnType, annotations);
    }

    public CallAdapter<?> nextCallAdapter(CallAdapter.Factory skipPast, Type returnType, Annotation[] annotations) {
        int i;
        int start;
        Utils.checkNotNull(returnType, "returnType == null");
        Utils.checkNotNull(annotations, "annotations == null");
        int count = this.adapterFactories.size();
        for (int i2 = start = this.adapterFactories.indexOf(skipPast) + 1; i2 < count; ++i2) {
            CallAdapter<?> adapter = this.adapterFactories.get(i2).get(returnType, annotations, this);
            if (adapter == null) continue;
            return adapter;
        }
        StringBuilder builder = new StringBuilder("Could not locate call adapter for ").append(returnType).append(".\n");
        if (skipPast != null) {
            builder.append("  Skipped:");
            for (i = 0; i < start; ++i) {
                builder.append("\n   * ").append(this.adapterFactories.get(i).getClass().getName());
            }
            builder.append('\n');
        }
        builder.append("  Tried:");
        int count2 = this.adapterFactories.size();
        for (i = start; i < count2; ++i) {
            builder.append("\n   * ").append(this.adapterFactories.get(i).getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public List<Converter.Factory> converterFactories() {
        return Collections.unmodifiableList(this.converterFactories);
    }

    public <T> Converter<T, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations) {
        return this.nextRequestBodyConverter(null, type, parameterAnnotations, methodAnnotations);
    }

    public <T> Converter<T, RequestBody> nextRequestBodyConverter(Converter.Factory skipPast, Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations) {
        int i;
        int start;
        Utils.checkNotNull(type, "type == null");
        Utils.checkNotNull(parameterAnnotations, "parameterAnnotations == null");
        Utils.checkNotNull(methodAnnotations, "methodAnnotations == null");
        int count = this.converterFactories.size();
        for (int i2 = start = this.converterFactories.indexOf(skipPast) + 1; i2 < count; ++i2) {
            Converter.Factory factory = this.converterFactories.get(i2);
            Converter<?, RequestBody> converter = factory.requestBodyConverter(type, parameterAnnotations, methodAnnotations, this);
            if (converter == null) continue;
            return converter;
        }
        StringBuilder builder = new StringBuilder("Could not locate RequestBody converter for ").append(type).append(".\n");
        if (skipPast != null) {
            builder.append("  Skipped:");
            for (i = 0; i < start; ++i) {
                builder.append("\n   * ").append(this.converterFactories.get(i).getClass().getName());
            }
            builder.append('\n');
        }
        builder.append("  Tried:");
        int count2 = this.converterFactories.size();
        for (i = start; i < count2; ++i) {
            builder.append("\n   * ").append(this.converterFactories.get(i).getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public <T> Converter<ResponseBody, T> responseBodyConverter(Type type, Annotation[] annotations) {
        return this.nextResponseBodyConverter(null, type, annotations);
    }

    public <T> Converter<ResponseBody, T> nextResponseBodyConverter(Converter.Factory skipPast, Type type, Annotation[] annotations) {
        int i;
        int start;
        Utils.checkNotNull(type, "type == null");
        Utils.checkNotNull(annotations, "annotations == null");
        int count = this.converterFactories.size();
        for (int i2 = start = this.converterFactories.indexOf(skipPast) + 1; i2 < count; ++i2) {
            Converter<ResponseBody, ?> converter = this.converterFactories.get(i2).responseBodyConverter(type, annotations, this);
            if (converter == null) continue;
            return converter;
        }
        StringBuilder builder = new StringBuilder("Could not locate ResponseBody converter for ").append(type).append(".\n");
        if (skipPast != null) {
            builder.append("  Skipped:");
            for (i = 0; i < start; ++i) {
                builder.append("\n   * ").append(this.converterFactories.get(i).getClass().getName());
            }
            builder.append('\n');
        }
        builder.append("  Tried:");
        int count2 = this.converterFactories.size();
        for (i = start; i < count2; ++i) {
            builder.append("\n   * ").append(this.converterFactories.get(i).getClass().getName());
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public <T> Converter<T, String> stringConverter(Type type, Annotation[] annotations) {
        Utils.checkNotNull(type, "type == null");
        Utils.checkNotNull(annotations, "annotations == null");
        int count = this.converterFactories.size();
        for (int i = 0; i < count; ++i) {
            Converter<?, String> converter = this.converterFactories.get(i).stringConverter(type, annotations, this);
            if (converter == null) continue;
            return converter;
        }
        return BuiltInConverters.ToStringConverter.INSTANCE;
    }

    public Executor callbackExecutor() {
        return this.callbackExecutor;
    }

    public static final class Builder {
        private Call.Factory callFactory;
        private BaseUrl baseUrl;
        private List<Converter.Factory> converterFactories = new ArrayList<Converter.Factory>();
        private List<CallAdapter.Factory> adapterFactories = new ArrayList<CallAdapter.Factory>();
        private Executor callbackExecutor;
        private boolean validateEagerly;

        public Builder() {
            this.converterFactories.add(new BuiltInConverters());
        }

        public Builder client(OkHttpClient client) {
            return this.callFactory((Call.Factory)Utils.checkNotNull(client, "client == null"));
        }

        public Builder callFactory(Call.Factory factory) {
            this.callFactory = Utils.checkNotNull(factory, "factory == null");
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            Utils.checkNotNull(baseUrl, "baseUrl == null");
            HttpUrl httpUrl = HttpUrl.parse((String)baseUrl);
            if (httpUrl == null) {
                throw new IllegalArgumentException("Illegal URL: " + baseUrl);
            }
            return this.baseUrl(httpUrl);
        }

        public Builder baseUrl(final HttpUrl baseUrl) {
            Utils.checkNotNull(baseUrl, "baseUrl == null");
            List pathSegments = baseUrl.pathSegments();
            if (!"".equals(pathSegments.get(pathSegments.size() - 1))) {
                throw new IllegalArgumentException("baseUrl must end in /: " + baseUrl);
            }
            return this.baseUrl(new BaseUrl(){

                @Override
                public HttpUrl url() {
                    return baseUrl;
                }
            });
        }

        public Builder baseUrl(BaseUrl baseUrl) {
            this.baseUrl = Utils.checkNotNull(baseUrl, "baseUrl == null");
            return this;
        }

        public Builder addConverterFactory(Converter.Factory factory) {
            this.converterFactories.add(Utils.checkNotNull(factory, "factory == null"));
            return this;
        }

        public Builder addCallAdapterFactory(CallAdapter.Factory factory) {
            this.adapterFactories.add(Utils.checkNotNull(factory, "factory == null"));
            return this;
        }

        public Builder callbackExecutor(Executor executor) {
            this.callbackExecutor = Utils.checkNotNull(executor, "executor == null");
            return this;
        }

        public Builder validateEagerly(boolean validateEagerly) {
            this.validateEagerly = validateEagerly;
            return this;
        }

        public Retrofit build() {
            if (this.baseUrl == null) {
                throw new IllegalStateException("Base URL required.");
            }
            Call.Factory callFactory = this.callFactory;
            if (callFactory == null) {
                callFactory = new OkHttpClient();
            }
            ArrayList<CallAdapter.Factory> adapterFactories = new ArrayList<CallAdapter.Factory>(this.adapterFactories);
            adapterFactories.add(Platform.get().defaultCallAdapterFactory(this.callbackExecutor));
            ArrayList<Converter.Factory> converterFactories = new ArrayList<Converter.Factory>(this.converterFactories);
            return new Retrofit(callFactory, this.baseUrl, converterFactories, adapterFactories, this.callbackExecutor, this.validateEagerly);
        }
    }
}

