/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.tape;

import com.squareup.tape.FileObjectQueue;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class SerializedConverter<T extends Serializable>
implements FileObjectQueue.Converter<T> {
    private T deserialize(InputStream in) throws IOException {
        Serializable entry;
        ObjectInputStream oin = new ObjectInputStream(new BufferedInputStream(in, 1024));
        try {
            entry = (Serializable)oin.readUnshared();
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        return (T)entry;
    }

    @Override
    public T from(byte[] bytes) throws IOException {
        return this.deserialize(new ByteArrayInputStream(bytes));
    }

    @Override
    public void toStream(T o, OutputStream bytes) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeUnshared(o);
        out.close();
    }
}

