/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.shaded.security.logging;

import com.veracode.shaded.security.logging.SecureExceptionWrapper;
import java.util.ArrayList;

public class SecureLoggerUtil {
    static String escapeMessage(String argument) {
        if (argument == null) {
            return null;
        }
        return argument.replace("\n", "\\n").replace("\r", "\\r").replace("%0D", "%250D").replace("%0A", "%250A").replace("%0d", "%250d").replace("%0a", "%250a");
    }

    static Object escapeMessage(Object argument) {
        if (argument instanceof Throwable) {
            return new SecureExceptionWrapper((Throwable)argument);
        }
        String message = String.valueOf(argument);
        if (message == null) {
            return null;
        }
        if ("".equals(message)) {
            return "";
        }
        return SecureLoggerUtil.escapeMessage(message);
    }

    static Object[] escapeMessages(Object ... arguments) {
        ArrayList<Object> escaped = new ArrayList<Object>();
        for (Object arg : arguments) {
            escaped.add(SecureLoggerUtil.escapeMessage(arg));
        }
        return escaped.toArray();
    }
}

