/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.srcclr.sdk.BaseBuilder;
import com.srcclr.sdk.BaseModel;
import com.srcclr.sdk.LanguageType;
import com.srcclr.sdk.VulnerabilityLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@JsonDeserialize(builder=Builder.class)
@Immutable
public class Vulnerability
extends BaseModel {
    private final Date disclosureDate;
    private final boolean hasExploits;
    private final String cve;
    private final String title;
    private final String overview;
    private final LanguageType language;
    private final Set<String> vulnerabilityTypes;
    private final Float cvssScore;
    private final Collection<VulnerabilityLibrary> libraries;

    private Vulnerability(Builder builder) {
        super(builder);
        this.disclosureDate = builder.disclosureDate;
        this.hasExploits = builder.hasExploits;
        this.cve = builder.cve;
        this.title = builder.title;
        this.overview = builder.overview;
        this.language = builder.language;
        this.vulnerabilityTypes = builder.vulnerabilityTypes;
        this.cvssScore = builder.cvssScore;
        this.libraries = Collections.unmodifiableCollection(builder.libraries);
    }

    public Date getDisclosureDate() {
        return this.disclosureDate;
    }

    @JsonProperty(value="hasExploits")
    public boolean hasExploits() {
        return this.hasExploits;
    }

    public String getCve() {
        return this.cve;
    }

    public String getTitle() {
        return this.title;
    }

    public String getOverview() {
        return this.overview;
    }

    public LanguageType getLanguage() {
        return this.language;
    }

    public Set<String> getVulnerabilityTypes() {
        return this.vulnerabilityTypes;
    }

    public Float getCvssScore() {
        return this.cvssScore;
    }

    public Collection<VulnerabilityLibrary> getLibraries() {
        return this.libraries;
    }

    public static class Builder
    extends BaseBuilder<Builder, Vulnerability> {
        private Date disclosureDate;
        private boolean hasExploits;
        private String cve;
        private String title;
        private String overview;
        private LanguageType language;
        private Set<String> vulnerabilityTypes = new HashSet<String>();
        private Float cvssScore;
        private Collection<VulnerabilityLibrary> libraries = new LinkedList<VulnerabilityLibrary>();

        public Builder withDisclosureDate(Date disclosureDate) {
            this.disclosureDate = disclosureDate;
            return this;
        }

        public Builder withHasExploits(boolean hasExploits) {
            this.hasExploits = hasExploits;
            return this;
        }

        public Builder withCve(String cve) {
            this.cve = cve;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withOverview(String overview) {
            this.overview = overview;
            return this;
        }

        public Builder withLanguage(LanguageType language) {
            this.language = language;
            return this;
        }

        public Builder withVulnerabilityTypes(Set<String> vulnerabilityTypes) {
            this.vulnerabilityTypes = vulnerabilityTypes;
            return this;
        }

        public Builder withCvssScore(Float cvssScore) {
            this.cvssScore = cvssScore;
            return this;
        }

        public Builder withLibraries(Collection<VulnerabilityLibrary> libraries) {
            this.libraries = new ArrayList<VulnerabilityLibrary>(libraries);
            return this;
        }

        @Override
        public Vulnerability build() {
            return new Vulnerability(this);
        }
    }
}

