/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.publickey;

import com.sshtools.common.publickey.CertificateExtension;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;

public class StringCertificateExtension
extends CertificateExtension {
    public StringCertificateExtension(String name, String value, boolean known) {
        this.setName(name);
        this.setKnown(known);
        try (ByteArrayWriter writer = new ByteArrayWriter();){
            writer.writeString(value);
            this.setStoredValue(writer.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    StringCertificateExtension(String name, byte[] value, boolean known) {
        this.setName(name);
        this.setStoredValue(value);
    }

    @Override
    public String getValue() {
        String string;
        ByteArrayReader reader = new ByteArrayReader(this.getStoredValue());
        try {
            string = reader.readString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        reader.close();
        return string;
    }
}

