/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.files;

import com.sshtools.common.events.Event;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.OpenFile;
import com.sshtools.common.util.UnsignedInteger32;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PseduoRandomOpenFile
implements OpenFile {
    AbstractFile f;
    UnsignedInteger32 flags;
    long filePointer;
    boolean textMode = false;
    InputStream in;
    OutputStream out;
    boolean closed;
    byte[] handle;

    public PseduoRandomOpenFile(AbstractFile f, UnsignedInteger32 flags, byte[] handle) throws IOException, PermissionDeniedException {
        this.f = f;
        this.flags = flags;
        boolean bl = this.textMode = (flags.intValue() & 0x40) != 0;
        if (this.isTextMode() && Log.isDebugEnabled()) {
            Log.debug((String)(f.getName() + " is being opened in TEXT mode"), (Object[])new Object[0]);
        }
    }

    @Override
    public byte[] getHandle() {
        return this.handle;
    }

    @Override
    public boolean isTextMode() {
        return this.textMode;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            finally {
                this.out = null;
            }
        }
        this.closed = true;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException, PermissionDeniedException {
        int count;
        int r;
        if (this.closed) {
            return -1;
        }
        if (this.filePointer == -1L) {
            return -1;
        }
        InputStream in = this.getInputStream();
        for (count = 0; count < len; count += r) {
            r = in.read(buf, off + count, len - count);
            if (r == -1) {
                if (count == 0) {
                    this.filePointer = -1L;
                    return -1;
                }
                return count;
            }
            this.filePointer += (long)r;
        }
        return count;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException, PermissionDeniedException {
        if (this.closed) {
            throw new IOException("File has been closed.");
        }
        if (this.filePointer == -1L) {
            throw new IOException("File is EOF");
        }
        OutputStream out = this.getOutputStream();
        out.write(buf, off, len);
        this.filePointer += (long)len;
    }

    private OutputStream getOutputStream() throws IOException, PermissionDeniedException {
        if (this.closed) {
            throw new IOException("File has been closed [getOutputStream].");
        }
        if (this.out == null) {
            this.out = this.f.getOutputStream();
        }
        return this.out;
    }

    private InputStream getInputStream() throws IOException, PermissionDeniedException {
        if (this.closed) {
            throw new IOException("File has been closed [getInputStream].");
        }
        if (this.in == null) {
            this.in = this.f.getInputStream();
        }
        return this.in;
    }

    @Override
    public void seek(long longValue) throws IOException {
        if (this.closed) {
            throw new IOException("File has been closed [getOutputStream].");
        }
        this.filePointer = -1L;
    }

    @Override
    public AbstractFile getFile() {
        return this.f;
    }

    @Override
    public UnsignedInteger32 getFlags() {
        return this.flags;
    }

    @Override
    public long getFilePointer() throws IOException {
        if (this.closed) {
            throw new IOException("File has been closed [getFilePointer].");
        }
        return this.filePointer;
    }

    @Override
    public void processEvent(Event evt) {
        evt.addAttribute("ABSTRACT_FILE", this.f);
        if (this.in != null) {
            evt.addAttribute("ABSTRACT_FILE_IN", this.in);
        }
        if (this.out != null) {
            evt.addAttribute("ABSTRACT_FILE_OUT", this.out);
        }
    }
}

