/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components.jce;

import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshKeyFingerprint;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.SshPublicKeyFactory;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.ssh.components.jce.SshEd448PublicKey;
import com.sshtools.common.util.Arrays;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class SshEd448PublicKeyJCE
implements SshEd448PublicKey {
    public static final byte[] ASN_HEADER = new byte[]{48, 67, 48, 5, 6, 3, 43, 101, 113, 3, 58, 0};
    public static final String ALGORITHM_NAME = "ssh-ed448";
    PublicKey publicKey;
    byte[] pk;

    public SshEd448PublicKeyJCE() {
    }

    @Override
    public SecurityLevel getSecurityLevel() {
        return SecurityLevel.PARANOID;
    }

    @Override
    public int getPriority() {
        return 9998;
    }

    public SshEd448PublicKeyJCE(byte[] pk) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, NoSuchProviderException {
        this.pk = pk;
        this.loadPublicKey(pk);
    }

    private void loadPublicKey(byte[] pk) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, NoSuchProviderException {
        KeyFactory keyFactory = JCEProvider.getKeyFactory("Ed448");
        byte[] encoded = Arrays.cat((byte[])ASN_HEADER, (byte[])pk);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encoded);
        this.publicKey = keyFactory.generatePublic(x509KeySpec);
    }

    public SshEd448PublicKeyJCE(PublicKey pub) {
        this.publicKey = pub;
    }

    @Override
    public SshPublicKey init(byte[] blob, int start, int len) throws SshException {
        try (ByteArrayReader bar = new ByteArrayReader(blob, start, len);){
            String name = bar.readString();
            if (!name.equals(ALGORITHM_NAME)) {
                throw new SshException("The encoded key is not ed448", 5);
            }
            byte[] pub = bar.readBinaryString();
            this.loadPublicKey(pub);
        }
        return this;
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM_NAME;
    }

    @Override
    public String getEncodingAlgorithm() {
        return this.getAlgorithm();
    }

    @Override
    public int getBitLength() {
        return 448;
    }

    @Override
    public byte[] getEncoded() throws SshException {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            baw.writeString(this.getAlgorithm());
            baw.writeBinaryString(this.decodeJCEKey());
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new SshException("Failed to encoded key data", 5, ex);
        }
        finally {
            try {
                baw.close();
            }
            catch (IOException iOException) {}
        }
    }

    private byte[] decodeJCEKey() {
        byte[] encoded = this.publicKey.getEncoded();
        byte[] seed = Arrays.copy((byte[])encoded, (int)ASN_HEADER.length, (int)(encoded.length - ASN_HEADER.length));
        return seed;
    }

    @Override
    public byte[] getA() {
        return this.decodeJCEKey();
    }

    @Override
    public String getFingerprint() throws SshException {
        return SshKeyFingerprint.getFingerprint(this.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifySignature(byte[] signature, byte[] data) throws SshException {
        try {
            try (ByteArrayReader bar = new ByteArrayReader(signature);){
                long count = bar.readInt();
                if (count > 0L && count == (long)this.getSigningAlgorithm().length()) {
                    bar.reset();
                    byte[] sig = bar.readBinaryString();
                    String header = new String(sig);
                    signature = bar.readBinaryString();
                }
            }
            return this.verifyJCESignature(signature, data);
        }
        catch (Exception ex) {
            throw new SshException(16, (Throwable)ex);
        }
    }

    private boolean verifyJCESignature(byte[] signature, byte[] data) throws SshException {
        try {
            Signature sgr = JCEProvider.getSignature("Ed448");
            sgr.initVerify(this.publicKey);
            sgr.update(data);
            return sgr.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SshException(e, 5);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshEd448PublicKeyJCE) {
            try {
                return ((SshPublicKey)obj).getFingerprint().equals(this.getFingerprint());
            }
            catch (SshException sshException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getFingerprint().hashCode();
        }
        catch (SshException ex) {
            return 0;
        }
    }

    @Override
    public String getSigningAlgorithm() {
        return this.getAlgorithm();
    }

    @Override
    public String test() {
        try {
            KeyFactory factory = JCEProvider.getKeyFactory("Ed448");
            return factory.getProvider().getName();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public PublicKey getJCEPublicKey() {
        return this.publicKey;
    }

    public static class SshEd448PublicKeyJCEFactory
    implements SshPublicKeyFactory<SshEd448PublicKeyJCE> {
        @Override
        public SshEd448PublicKeyJCE create() throws NoSuchAlgorithmException, IOException {
            return new SshEd448PublicKeyJCE();
        }

        @Override
        public String[] getKeys() {
            return new String[]{SshEd448PublicKeyJCE.ALGORITHM_NAME};
        }
    }
}

