/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.logger.Log;
import com.sshtools.synergy.ssh.ChannelNG;
import java.io.IOException;
import java.io.OutputStream;

public class ChannelOutputStream
extends OutputStream {
    int type = -1;
    ChannelNG<?> channel;
    boolean sentEOF;

    public ChannelOutputStream(ChannelNG<?> channel) {
        this.channel = channel;
    }

    public ChannelOutputStream(ChannelNG<?> channel, int type) {
        this.type = type;
        this.channel = channel;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.type > -1) {
            this.channel.sendExtendedData(new byte[]{(byte)b}, this.type);
        } else {
            this.channel.sendChannelDataAndBlock(new byte[]{(byte)b});
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.type > -1) {
            this.channel.sendExtendedData(b, off, len, this.type);
        } else {
            this.channel.sendData(b, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ChannelNG<?> channelNG = this.channel;
        synchronized (channelNG) {
            if (!(this.sentEOF || this.channel.isClosed() || this.channel.isClosing())) {
                if (Log.isDebugEnabled()) {
                    this.channel.log("The channel's OutputStream has been closed");
                }
                this.channel.sendEOF();
                this.sentEOF = true;
            }
        }
    }
}

