/*
 * Decompiled with CFR 0.152.
 */
package com.stchome.maven.plugins;

import com.stchome.maven.plugins.ArtifactItem;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

public abstract class ArtifactMojoParent
extends AbstractMojo {
    private ArtifactFactory factory;
    private ArtifactResolver resolver;
    private ArtifactRepository local;
    private List remoteRepos;
    protected File defaultWorkDirectory;
    protected ArchiverManager archiverManager;
    private ArrayList artifactItems;
    Log log = this.getLog();

    public void execute() throws MojoExecutionException {
        Iterator iter = ((AbstractList)this.artifactItems).iterator();
        while (iter.hasNext()) {
            ArtifactItem artifactItem = (ArtifactItem)iter.next();
            this.log.info((CharSequence)("Configured Artifact: " + artifactItem.toString()));
            try {
                Artifact artifact = this.getArtifact(artifactItem);
                File file = artifactItem.getLocation();
                if (file == null) {
                    file = this.defaultWorkDirectory;
                }
                file.mkdirs();
                this.doMojo(artifact, file, artifactItem);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Nested:", e);
            }
        }
    }

    protected Artifact getArtifact(ArtifactItem artifactItem) throws ArtifactResolutionException, ArtifactNotFoundException {
        Artifact artifact = this.factory.createArtifact(artifactItem.getGroupId(), artifactItem.getArtifactId(), artifactItem.getVersion(), "provided", artifactItem.getType());
        this.resolver.resolve(artifact, this.remoteRepos, this.local);
        return artifact;
    }

    protected abstract void doMojo(Artifact var1, File var2, ArtifactItem var3) throws Exception;
}

