/*
 * Decompiled with CFR 0.152.
 */
package com.stchome.maven.plugins;

import com.stchome.maven.plugins.ArtifactItem;
import com.stchome.maven.plugins.ArtifactMojoParent;
import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;

public class ExplodeMojo
extends ArtifactMojoParent {
    protected void doMojo(Artifact artifact, File location, ArtifactItem artifactItem) throws Exception {
        this.unpack(artifact.getFile(), location, artifactItem.isOverWrite());
    }

    protected void unpack(File file, File location, boolean overWrite) throws MojoExecutionException, NoSuchArchiverException {
        this.log.info((CharSequence)("Unpacking File " + file.getAbsolutePath() + " to " + location.getAbsolutePath()));
        String archiveExt = FileUtils.getExtension((String)file.getAbsolutePath()).toLowerCase();
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(archiveExt);
            unArchiver.setOverwrite(overWrite);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.extract();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)((Object)e));
        }
    }
}

