/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.v2;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeActiveObject;
import com.stripe.model.StripeObject;
import com.stripe.model.StripeObjectInterface;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;

public class StripeCollection<T extends StripeObjectInterface>
extends StripeObject
implements StripeActiveObject {
    private transient StripeResponseGetter responseGetter;
    private transient Type pageTypeToken;
    @SerializedName(value="data")
    List<T> data;
    @SerializedName(value="next_page_url")
    String nextPageUrl;
    @SerializedName(value="previous_page_url")
    String previousPageUrl;
    private transient RequestOptions requestOptions;

    public Iterable<T> autoPagingIterable() {
        return new PagingIterable();
    }

    public Iterable<T> autoPagingIterable(RequestOptions options) {
        return new PagingIterable(options);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        this.responseGetter = responseGetter;
        if (this.data != null) {
            for (StripeObjectInterface item : this.data) {
                this.trySetResponseGetter(item, responseGetter);
            }
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StripeCollection)) {
            return false;
        }
        StripeCollection other = (StripeCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$nextPageUrl = this.getNextPageUrl();
        String other$nextPageUrl = other.getNextPageUrl();
        if (this$nextPageUrl == null ? other$nextPageUrl != null : !this$nextPageUrl.equals(other$nextPageUrl)) {
            return false;
        }
        String this$previousPageUrl = this.getPreviousPageUrl();
        String other$previousPageUrl = other.getPreviousPageUrl();
        return !(this$previousPageUrl == null ? other$previousPageUrl != null : !this$previousPageUrl.equals(other$previousPageUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StripeCollection;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $nextPageUrl = this.getNextPageUrl();
        result = result * 59 + ($nextPageUrl == null ? 43 : $nextPageUrl.hashCode());
        String $previousPageUrl = this.getPreviousPageUrl();
        result = result * 59 + ($previousPageUrl == null ? 43 : $previousPageUrl.hashCode());
        return result;
    }

    @Generated
    public void setPageTypeToken(Type pageTypeToken) {
        this.pageTypeToken = pageTypeToken;
    }

    @Generated
    public List<T> getData() {
        return this.data;
    }

    @Generated
    public String getNextPageUrl() {
        return this.nextPageUrl;
    }

    @Generated
    public String getPreviousPageUrl() {
        return this.previousPageUrl;
    }

    @Generated
    public RequestOptions getRequestOptions() {
        return this.requestOptions;
    }

    @Generated
    public void setRequestOptions(RequestOptions requestOptions) {
        this.requestOptions = requestOptions;
    }

    private class PagingIterable
    implements Iterable<T> {
        RequestOptions options;

        public PagingIterable() {
            this.options = StripeCollection.this.getRequestOptions();
        }

        public PagingIterable(RequestOptions options) {
            this.options = options;
        }

        private Page<T> getPage(String nextPageUrl) throws StripeException {
            if (nextPageUrl == null) {
                throw new IllegalArgumentException("nextPageUrl cannot be null");
            }
            StripeCollection response = (StripeCollection)StripeCollection.this.responseGetter.request(new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, nextPageUrl, new HashMap<String, Object>(), this.options), StripeCollection.this.pageTypeToken);
            return new Page(response.getData(), response.getNextPageUrl());
        }

        @Override
        public Iterator<T> iterator() {
            return new PagingIterator(StripeCollection.this.getData(), StripeCollection.this.getNextPageUrl());
        }

        private class PagingIterator
        implements Iterator<T> {
            Iterator<T> currentDataIterator;
            String nextPageUrl;

            public PagingIterator(List<T> currentPage, String nextPageUrl) {
                this.currentDataIterator = currentPage.iterator();
                this.nextPageUrl = nextPageUrl;
            }

            @Override
            public T next() {
                if (!this.currentDataIterator.hasNext() && this.nextPageUrl != null) {
                    try {
                        Page p = PagingIterable.this.getPage(this.nextPageUrl);
                        this.currentDataIterator = p.data.iterator();
                        this.nextPageUrl = p.nextPageUrl;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to paginate", e);
                    }
                }
                return (StripeObjectInterface)this.currentDataIterator.next();
            }

            @Override
            public boolean hasNext() {
                return this.currentDataIterator.hasNext() || this.nextPageUrl != null;
            }
        }
    }

    private static class Page<T> {
        List<T> data;
        String nextPageUrl;

        Page(List<T> data, String nextPageUrl) {
            this.data = data;
            this.nextPageUrl = nextPageUrl;
        }
    }
}

