/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.exception.AuthenticationException;
import com.stripe.exception.StripeException;
import com.stripe.net.Authenticator;
import com.stripe.net.StripeRequest;
import com.stripe.util.StringUtils;
import lombok.Generated;

public final class BearerTokenAuthenticator
implements Authenticator {
    private final String apiKey;

    public BearerTokenAuthenticator(String apiKey) {
        if (apiKey == null) {
            throw new IllegalArgumentException("apiKey should be not-null");
        }
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public StripeRequest authenticate(StripeRequest request) throws StripeException {
        if (this.apiKey.isEmpty()) {
            throw new AuthenticationException("Your API key is invalid, as it is an empty string. You can double-check your API key from the Stripe Dashboard. See https://stripe.com/docs/api/authentication for details or contact support at https://support.stripe.com/email if you have any questions.", null, null, 0);
        }
        if (StringUtils.containsWhitespace(this.apiKey)) {
            throw new AuthenticationException("Your API key is invalid, as it contains whitespace. You can double-check your API key from the Stripe Dashboard. See https://stripe.com/docs/api/authentication for details or contact support at https://support.stripe.com/email if you have any questions.", null, null, 0);
        }
        return request.withAdditionalHeader("Authorization", String.format("Bearer %s", this.apiKey));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BearerTokenAuthenticator)) {
            return false;
        }
        BearerTokenAuthenticator other = (BearerTokenAuthenticator)o;
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        return !(this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        return result;
    }
}

