/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CustomerSessionCreateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CustomerSession
extends ApiResource {
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="components")
    Components components;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public static CustomerSession create(Map<String, Object> params) throws StripeException {
        return CustomerSession.create(params, (RequestOptions)null);
    }

    public static CustomerSession create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/customer_sessions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (CustomerSession)CustomerSession.getGlobalResponseGetter().request(request, (Type)((Object)CustomerSession.class));
    }

    public static CustomerSession create(CustomerSessionCreateParams params) throws StripeException {
        return CustomerSession.create(params, (RequestOptions)null);
    }

    public static CustomerSession create(CustomerSessionCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/customer_sessions";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (CustomerSession)CustomerSession.getGlobalResponseGetter().request(request, (Type)((Object)CustomerSession.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.components, responseGetter);
        this.trySetResponseGetter(this.customer, responseGetter);
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public Components getComponents() {
        return this.components;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setComponents(Components components) {
        this.components = components;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomerSession)) {
            return false;
        }
        CustomerSession other = (CustomerSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        Components this$components = this.getComponents();
        Components other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomerSession;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        Components $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    public static class Components
    extends StripeObject {
        @SerializedName(value="buy_button")
        BuyButton buyButton;
        @SerializedName(value="payment_element")
        PaymentElement paymentElement;
        @SerializedName(value="pricing_table")
        PricingTable pricingTable;

        @Generated
        public BuyButton getBuyButton() {
            return this.buyButton;
        }

        @Generated
        public PaymentElement getPaymentElement() {
            return this.paymentElement;
        }

        @Generated
        public PricingTable getPricingTable() {
            return this.pricingTable;
        }

        @Generated
        public void setBuyButton(BuyButton buyButton) {
            this.buyButton = buyButton;
        }

        @Generated
        public void setPaymentElement(PaymentElement paymentElement) {
            this.paymentElement = paymentElement;
        }

        @Generated
        public void setPricingTable(PricingTable pricingTable) {
            this.pricingTable = pricingTable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Components)) {
                return false;
            }
            Components other = (Components)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BuyButton this$buyButton = this.getBuyButton();
            BuyButton other$buyButton = other.getBuyButton();
            if (this$buyButton == null ? other$buyButton != null : !((Object)this$buyButton).equals(other$buyButton)) {
                return false;
            }
            PaymentElement this$paymentElement = this.getPaymentElement();
            PaymentElement other$paymentElement = other.getPaymentElement();
            if (this$paymentElement == null ? other$paymentElement != null : !((Object)this$paymentElement).equals(other$paymentElement)) {
                return false;
            }
            PricingTable this$pricingTable = this.getPricingTable();
            PricingTable other$pricingTable = other.getPricingTable();
            return !(this$pricingTable == null ? other$pricingTable != null : !((Object)this$pricingTable).equals(other$pricingTable));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Components;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BuyButton $buyButton = this.getBuyButton();
            result = result * 59 + ($buyButton == null ? 43 : ((Object)$buyButton).hashCode());
            PaymentElement $paymentElement = this.getPaymentElement();
            result = result * 59 + ($paymentElement == null ? 43 : ((Object)$paymentElement).hashCode());
            PricingTable $pricingTable = this.getPricingTable();
            result = result * 59 + ($pricingTable == null ? 43 : ((Object)$pricingTable).hashCode());
            return result;
        }

        public static class BuyButton
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BuyButton)) {
                    return false;
                }
                BuyButton other = (BuyButton)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BuyButton;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                return result;
            }
        }

        public static class PaymentElement
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PaymentElement)) {
                    return false;
                }
                PaymentElement other = (PaymentElement)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PaymentElement;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="payment_method_allow_redisplay_filters")
                List<String> paymentMethodAllowRedisplayFilters;
                @SerializedName(value="payment_method_redisplay")
                String paymentMethodRedisplay;
                @SerializedName(value="payment_method_redisplay_limit")
                Long paymentMethodRedisplayLimit;
                @SerializedName(value="payment_method_remove")
                String paymentMethodRemove;
                @SerializedName(value="payment_method_save")
                String paymentMethodSave;
                @SerializedName(value="payment_method_save_usage")
                String paymentMethodSaveUsage;

                @Generated
                public List<String> getPaymentMethodAllowRedisplayFilters() {
                    return this.paymentMethodAllowRedisplayFilters;
                }

                @Generated
                public String getPaymentMethodRedisplay() {
                    return this.paymentMethodRedisplay;
                }

                @Generated
                public Long getPaymentMethodRedisplayLimit() {
                    return this.paymentMethodRedisplayLimit;
                }

                @Generated
                public String getPaymentMethodRemove() {
                    return this.paymentMethodRemove;
                }

                @Generated
                public String getPaymentMethodSave() {
                    return this.paymentMethodSave;
                }

                @Generated
                public String getPaymentMethodSaveUsage() {
                    return this.paymentMethodSaveUsage;
                }

                @Generated
                public void setPaymentMethodAllowRedisplayFilters(List<String> paymentMethodAllowRedisplayFilters) {
                    this.paymentMethodAllowRedisplayFilters = paymentMethodAllowRedisplayFilters;
                }

                @Generated
                public void setPaymentMethodRedisplay(String paymentMethodRedisplay) {
                    this.paymentMethodRedisplay = paymentMethodRedisplay;
                }

                @Generated
                public void setPaymentMethodRedisplayLimit(Long paymentMethodRedisplayLimit) {
                    this.paymentMethodRedisplayLimit = paymentMethodRedisplayLimit;
                }

                @Generated
                public void setPaymentMethodRemove(String paymentMethodRemove) {
                    this.paymentMethodRemove = paymentMethodRemove;
                }

                @Generated
                public void setPaymentMethodSave(String paymentMethodSave) {
                    this.paymentMethodSave = paymentMethodSave;
                }

                @Generated
                public void setPaymentMethodSaveUsage(String paymentMethodSaveUsage) {
                    this.paymentMethodSaveUsage = paymentMethodSaveUsage;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$paymentMethodRedisplayLimit = this.getPaymentMethodRedisplayLimit();
                    Long other$paymentMethodRedisplayLimit = other.getPaymentMethodRedisplayLimit();
                    if (this$paymentMethodRedisplayLimit == null ? other$paymentMethodRedisplayLimit != null : !((Object)this$paymentMethodRedisplayLimit).equals(other$paymentMethodRedisplayLimit)) {
                        return false;
                    }
                    List<String> this$paymentMethodAllowRedisplayFilters = this.getPaymentMethodAllowRedisplayFilters();
                    List<String> other$paymentMethodAllowRedisplayFilters = other.getPaymentMethodAllowRedisplayFilters();
                    if (this$paymentMethodAllowRedisplayFilters == null ? other$paymentMethodAllowRedisplayFilters != null : !((Object)this$paymentMethodAllowRedisplayFilters).equals(other$paymentMethodAllowRedisplayFilters)) {
                        return false;
                    }
                    String this$paymentMethodRedisplay = this.getPaymentMethodRedisplay();
                    String other$paymentMethodRedisplay = other.getPaymentMethodRedisplay();
                    if (this$paymentMethodRedisplay == null ? other$paymentMethodRedisplay != null : !this$paymentMethodRedisplay.equals(other$paymentMethodRedisplay)) {
                        return false;
                    }
                    String this$paymentMethodRemove = this.getPaymentMethodRemove();
                    String other$paymentMethodRemove = other.getPaymentMethodRemove();
                    if (this$paymentMethodRemove == null ? other$paymentMethodRemove != null : !this$paymentMethodRemove.equals(other$paymentMethodRemove)) {
                        return false;
                    }
                    String this$paymentMethodSave = this.getPaymentMethodSave();
                    String other$paymentMethodSave = other.getPaymentMethodSave();
                    if (this$paymentMethodSave == null ? other$paymentMethodSave != null : !this$paymentMethodSave.equals(other$paymentMethodSave)) {
                        return false;
                    }
                    String this$paymentMethodSaveUsage = this.getPaymentMethodSaveUsage();
                    String other$paymentMethodSaveUsage = other.getPaymentMethodSaveUsage();
                    return !(this$paymentMethodSaveUsage == null ? other$paymentMethodSaveUsage != null : !this$paymentMethodSaveUsage.equals(other$paymentMethodSaveUsage));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $paymentMethodRedisplayLimit = this.getPaymentMethodRedisplayLimit();
                    result = result * 59 + ($paymentMethodRedisplayLimit == null ? 43 : ((Object)$paymentMethodRedisplayLimit).hashCode());
                    List<String> $paymentMethodAllowRedisplayFilters = this.getPaymentMethodAllowRedisplayFilters();
                    result = result * 59 + ($paymentMethodAllowRedisplayFilters == null ? 43 : ((Object)$paymentMethodAllowRedisplayFilters).hashCode());
                    String $paymentMethodRedisplay = this.getPaymentMethodRedisplay();
                    result = result * 59 + ($paymentMethodRedisplay == null ? 43 : $paymentMethodRedisplay.hashCode());
                    String $paymentMethodRemove = this.getPaymentMethodRemove();
                    result = result * 59 + ($paymentMethodRemove == null ? 43 : $paymentMethodRemove.hashCode());
                    String $paymentMethodSave = this.getPaymentMethodSave();
                    result = result * 59 + ($paymentMethodSave == null ? 43 : $paymentMethodSave.hashCode());
                    String $paymentMethodSaveUsage = this.getPaymentMethodSaveUsage();
                    result = result * 59 + ($paymentMethodSaveUsage == null ? 43 : $paymentMethodSaveUsage.hashCode());
                    return result;
                }
            }
        }

        public static class PricingTable
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PricingTable)) {
                    return false;
                }
                PricingTable other = (PricingTable)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PricingTable;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                return result;
            }
        }
    }
}

