/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.PaymentMethodDomainCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PaymentMethodDomainCreateParams;
import com.stripe.param.PaymentMethodDomainListParams;
import com.stripe.param.PaymentMethodDomainRetrieveParams;
import com.stripe.param.PaymentMethodDomainUpdateParams;
import com.stripe.param.PaymentMethodDomainValidateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class PaymentMethodDomain
extends ApiResource
implements HasId {
    @SerializedName(value="amazon_pay")
    AmazonPay amazonPay;
    @SerializedName(value="apple_pay")
    ApplePay applePay;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="domain_name")
    String domainName;
    @SerializedName(value="enabled")
    Boolean enabled;
    @SerializedName(value="google_pay")
    GooglePay googlePay;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="klarna")
    Klarna klarna;
    @SerializedName(value="link")
    Link link;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="paypal")
    Paypal paypal;

    public static PaymentMethodDomain create(Map<String, Object> params) throws StripeException {
        return PaymentMethodDomain.create(params, (RequestOptions)null);
    }

    public static PaymentMethodDomain create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_method_domains";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (PaymentMethodDomain)PaymentMethodDomain.getGlobalResponseGetter().request(request, (Type)((Object)PaymentMethodDomain.class));
    }

    public static PaymentMethodDomain create(PaymentMethodDomainCreateParams params) throws StripeException {
        return PaymentMethodDomain.create(params, (RequestOptions)null);
    }

    public static PaymentMethodDomain create(PaymentMethodDomainCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_method_domains";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentMethodDomain)PaymentMethodDomain.getGlobalResponseGetter().request(request, (Type)((Object)PaymentMethodDomain.class));
    }

    public static PaymentMethodDomainCollection list(Map<String, Object> params) throws StripeException {
        return PaymentMethodDomain.list(params, (RequestOptions)null);
    }

    public static PaymentMethodDomainCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_method_domains";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (PaymentMethodDomainCollection)PaymentMethodDomain.getGlobalResponseGetter().request(request, (Type)((Object)PaymentMethodDomainCollection.class));
    }

    public static PaymentMethodDomainCollection list(PaymentMethodDomainListParams params) throws StripeException {
        return PaymentMethodDomain.list(params, (RequestOptions)null);
    }

    public static PaymentMethodDomainCollection list(PaymentMethodDomainListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_method_domains";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentMethodDomainCollection)PaymentMethodDomain.getGlobalResponseGetter().request(request, (Type)((Object)PaymentMethodDomainCollection.class));
    }

    public static PaymentMethodDomain retrieve(String paymentMethodDomain) throws StripeException {
        return PaymentMethodDomain.retrieve(paymentMethodDomain, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PaymentMethodDomain retrieve(String paymentMethodDomain, RequestOptions options) throws StripeException {
        return PaymentMethodDomain.retrieve(paymentMethodDomain, (Map<String, Object>)null, options);
    }

    public static PaymentMethodDomain retrieve(String paymentMethodDomain, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_domains/%s", ApiResource.urlEncodeId(paymentMethodDomain));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (PaymentMethodDomain)PaymentMethodDomain.getGlobalResponseGetter().request(request, (Type)((Object)PaymentMethodDomain.class));
    }

    public static PaymentMethodDomain retrieve(String paymentMethodDomain, PaymentMethodDomainRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_domains/%s", ApiResource.urlEncodeId(paymentMethodDomain));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentMethodDomain)PaymentMethodDomain.getGlobalResponseGetter().request(request, (Type)((Object)PaymentMethodDomain.class));
    }

    public PaymentMethodDomain update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PaymentMethodDomain update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_domains/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (PaymentMethodDomain)this.getResponseGetter().request(request, (Type)((Object)PaymentMethodDomain.class));
    }

    public PaymentMethodDomain update(PaymentMethodDomainUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PaymentMethodDomain update(PaymentMethodDomainUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_domains/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentMethodDomain)this.getResponseGetter().request(request, (Type)((Object)PaymentMethodDomain.class));
    }

    public PaymentMethodDomain validate() throws StripeException {
        return this.validate((Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentMethodDomain validate(RequestOptions options) throws StripeException {
        return this.validate((Map<String, Object>)null, options);
    }

    public PaymentMethodDomain validate(Map<String, Object> params) throws StripeException {
        return this.validate(params, (RequestOptions)null);
    }

    public PaymentMethodDomain validate(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_domains/%s/validate", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (PaymentMethodDomain)this.getResponseGetter().request(request, (Type)((Object)PaymentMethodDomain.class));
    }

    public PaymentMethodDomain validate(PaymentMethodDomainValidateParams params) throws StripeException {
        return this.validate(params, (RequestOptions)null);
    }

    public PaymentMethodDomain validate(PaymentMethodDomainValidateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_domains/%s/validate", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentMethodDomain)this.getResponseGetter().request(request, (Type)((Object)PaymentMethodDomain.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.amazonPay, responseGetter);
        this.trySetResponseGetter(this.applePay, responseGetter);
        this.trySetResponseGetter(this.googlePay, responseGetter);
        this.trySetResponseGetter(this.klarna, responseGetter);
        this.trySetResponseGetter(this.link, responseGetter);
        this.trySetResponseGetter(this.paypal, responseGetter);
    }

    @Generated
    public AmazonPay getAmazonPay() {
        return this.amazonPay;
    }

    @Generated
    public ApplePay getApplePay() {
        return this.applePay;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getDomainName() {
        return this.domainName;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public GooglePay getGooglePay() {
        return this.googlePay;
    }

    @Generated
    public Klarna getKlarna() {
        return this.klarna;
    }

    @Generated
    public Link getLink() {
        return this.link;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Paypal getPaypal() {
        return this.paypal;
    }

    @Generated
    public void setAmazonPay(AmazonPay amazonPay) {
        this.amazonPay = amazonPay;
    }

    @Generated
    public void setApplePay(ApplePay applePay) {
        this.applePay = applePay;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setGooglePay(GooglePay googlePay) {
        this.googlePay = googlePay;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setKlarna(Klarna klarna) {
        this.klarna = klarna;
    }

    @Generated
    public void setLink(Link link) {
        this.link = link;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaypal(Paypal paypal) {
        this.paypal = paypal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentMethodDomain)) {
            return false;
        }
        PaymentMethodDomain other = (PaymentMethodDomain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AmazonPay this$amazonPay = this.getAmazonPay();
        AmazonPay other$amazonPay = other.getAmazonPay();
        if (this$amazonPay == null ? other$amazonPay != null : !((Object)this$amazonPay).equals(other$amazonPay)) {
            return false;
        }
        ApplePay this$applePay = this.getApplePay();
        ApplePay other$applePay = other.getApplePay();
        if (this$applePay == null ? other$applePay != null : !((Object)this$applePay).equals(other$applePay)) {
            return false;
        }
        String this$domainName = this.getDomainName();
        String other$domainName = other.getDomainName();
        if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) {
            return false;
        }
        GooglePay this$googlePay = this.getGooglePay();
        GooglePay other$googlePay = other.getGooglePay();
        if (this$googlePay == null ? other$googlePay != null : !((Object)this$googlePay).equals(other$googlePay)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Klarna this$klarna = this.getKlarna();
        Klarna other$klarna = other.getKlarna();
        if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
            return false;
        }
        Link this$link = this.getLink();
        Link other$link = other.getLink();
        if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Paypal this$paypal = this.getPaypal();
        Paypal other$paypal = other.getPaypal();
        return !(this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentMethodDomain;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AmazonPay $amazonPay = this.getAmazonPay();
        result = result * 59 + ($amazonPay == null ? 43 : ((Object)$amazonPay).hashCode());
        ApplePay $applePay = this.getApplePay();
        result = result * 59 + ($applePay == null ? 43 : ((Object)$applePay).hashCode());
        String $domainName = this.getDomainName();
        result = result * 59 + ($domainName == null ? 43 : $domainName.hashCode());
        GooglePay $googlePay = this.getGooglePay();
        result = result * 59 + ($googlePay == null ? 43 : ((Object)$googlePay).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Klarna $klarna = this.getKlarna();
        result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
        Link $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Paypal $paypal = this.getPaypal();
        result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class AmazonPay
    extends StripeObject {
        @SerializedName(value="status")
        String status;
        @SerializedName(value="status_details")
        StatusDetails statusDetails;

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public StatusDetails getStatusDetails() {
            return this.statusDetails;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setStatusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmazonPay)) {
                return false;
            }
            AmazonPay other = (AmazonPay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            StatusDetails this$statusDetails = this.getStatusDetails();
            StatusDetails other$statusDetails = other.getStatusDetails();
            return !(this$statusDetails == null ? other$statusDetails != null : !((Object)this$statusDetails).equals(other$statusDetails));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmazonPay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            StatusDetails $statusDetails = this.getStatusDetails();
            result = result * 59 + ($statusDetails == null ? 43 : ((Object)$statusDetails).hashCode());
            return result;
        }

        public static class StatusDetails
        extends StripeObject {
            @SerializedName(value="error_message")
            String errorMessage;

            @Generated
            public String getErrorMessage() {
                return this.errorMessage;
            }

            @Generated
            public void setErrorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StatusDetails)) {
                    return false;
                }
                StatusDetails other = (StatusDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$errorMessage = this.getErrorMessage();
                String other$errorMessage = other.getErrorMessage();
                return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StatusDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $errorMessage = this.getErrorMessage();
                result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
                return result;
            }
        }
    }

    public static class ApplePay
    extends StripeObject {
        @SerializedName(value="status")
        String status;
        @SerializedName(value="status_details")
        StatusDetails statusDetails;

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public StatusDetails getStatusDetails() {
            return this.statusDetails;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setStatusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplePay)) {
                return false;
            }
            ApplePay other = (ApplePay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            StatusDetails this$statusDetails = this.getStatusDetails();
            StatusDetails other$statusDetails = other.getStatusDetails();
            return !(this$statusDetails == null ? other$statusDetails != null : !((Object)this$statusDetails).equals(other$statusDetails));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApplePay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            StatusDetails $statusDetails = this.getStatusDetails();
            result = result * 59 + ($statusDetails == null ? 43 : ((Object)$statusDetails).hashCode());
            return result;
        }

        public static class StatusDetails
        extends StripeObject {
            @SerializedName(value="error_message")
            String errorMessage;

            @Generated
            public String getErrorMessage() {
                return this.errorMessage;
            }

            @Generated
            public void setErrorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StatusDetails)) {
                    return false;
                }
                StatusDetails other = (StatusDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$errorMessage = this.getErrorMessage();
                String other$errorMessage = other.getErrorMessage();
                return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StatusDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $errorMessage = this.getErrorMessage();
                result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
                return result;
            }
        }
    }

    public static class GooglePay
    extends StripeObject {
        @SerializedName(value="status")
        String status;
        @SerializedName(value="status_details")
        StatusDetails statusDetails;

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public StatusDetails getStatusDetails() {
            return this.statusDetails;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setStatusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GooglePay)) {
                return false;
            }
            GooglePay other = (GooglePay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            StatusDetails this$statusDetails = this.getStatusDetails();
            StatusDetails other$statusDetails = other.getStatusDetails();
            return !(this$statusDetails == null ? other$statusDetails != null : !((Object)this$statusDetails).equals(other$statusDetails));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GooglePay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            StatusDetails $statusDetails = this.getStatusDetails();
            result = result * 59 + ($statusDetails == null ? 43 : ((Object)$statusDetails).hashCode());
            return result;
        }

        public static class StatusDetails
        extends StripeObject {
            @SerializedName(value="error_message")
            String errorMessage;

            @Generated
            public String getErrorMessage() {
                return this.errorMessage;
            }

            @Generated
            public void setErrorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StatusDetails)) {
                    return false;
                }
                StatusDetails other = (StatusDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$errorMessage = this.getErrorMessage();
                String other$errorMessage = other.getErrorMessage();
                return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StatusDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $errorMessage = this.getErrorMessage();
                result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
                return result;
            }
        }
    }

    public static class Klarna
    extends StripeObject {
        @SerializedName(value="status")
        String status;
        @SerializedName(value="status_details")
        StatusDetails statusDetails;

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public StatusDetails getStatusDetails() {
            return this.statusDetails;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setStatusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Klarna)) {
                return false;
            }
            Klarna other = (Klarna)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            StatusDetails this$statusDetails = this.getStatusDetails();
            StatusDetails other$statusDetails = other.getStatusDetails();
            return !(this$statusDetails == null ? other$statusDetails != null : !((Object)this$statusDetails).equals(other$statusDetails));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Klarna;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            StatusDetails $statusDetails = this.getStatusDetails();
            result = result * 59 + ($statusDetails == null ? 43 : ((Object)$statusDetails).hashCode());
            return result;
        }

        public static class StatusDetails
        extends StripeObject {
            @SerializedName(value="error_message")
            String errorMessage;

            @Generated
            public String getErrorMessage() {
                return this.errorMessage;
            }

            @Generated
            public void setErrorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StatusDetails)) {
                    return false;
                }
                StatusDetails other = (StatusDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$errorMessage = this.getErrorMessage();
                String other$errorMessage = other.getErrorMessage();
                return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StatusDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $errorMessage = this.getErrorMessage();
                result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
                return result;
            }
        }
    }

    public static class Link
    extends StripeObject {
        @SerializedName(value="status")
        String status;
        @SerializedName(value="status_details")
        StatusDetails statusDetails;

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public StatusDetails getStatusDetails() {
            return this.statusDetails;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setStatusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Link)) {
                return false;
            }
            Link other = (Link)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            StatusDetails this$statusDetails = this.getStatusDetails();
            StatusDetails other$statusDetails = other.getStatusDetails();
            return !(this$statusDetails == null ? other$statusDetails != null : !((Object)this$statusDetails).equals(other$statusDetails));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Link;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            StatusDetails $statusDetails = this.getStatusDetails();
            result = result * 59 + ($statusDetails == null ? 43 : ((Object)$statusDetails).hashCode());
            return result;
        }

        public static class StatusDetails
        extends StripeObject {
            @SerializedName(value="error_message")
            String errorMessage;

            @Generated
            public String getErrorMessage() {
                return this.errorMessage;
            }

            @Generated
            public void setErrorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StatusDetails)) {
                    return false;
                }
                StatusDetails other = (StatusDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$errorMessage = this.getErrorMessage();
                String other$errorMessage = other.getErrorMessage();
                return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StatusDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $errorMessage = this.getErrorMessage();
                result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
                return result;
            }
        }
    }

    public static class Paypal
    extends StripeObject {
        @SerializedName(value="status")
        String status;
        @SerializedName(value="status_details")
        StatusDetails statusDetails;

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public StatusDetails getStatusDetails() {
            return this.statusDetails;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public void setStatusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Paypal)) {
                return false;
            }
            Paypal other = (Paypal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            StatusDetails this$statusDetails = this.getStatusDetails();
            StatusDetails other$statusDetails = other.getStatusDetails();
            return !(this$statusDetails == null ? other$statusDetails != null : !((Object)this$statusDetails).equals(other$statusDetails));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Paypal;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            StatusDetails $statusDetails = this.getStatusDetails();
            result = result * 59 + ($statusDetails == null ? 43 : ((Object)$statusDetails).hashCode());
            return result;
        }

        public static class StatusDetails
        extends StripeObject {
            @SerializedName(value="error_message")
            String errorMessage;

            @Generated
            public String getErrorMessage() {
                return this.errorMessage;
            }

            @Generated
            public void setErrorMessage(String errorMessage) {
                this.errorMessage = errorMessage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StatusDetails)) {
                    return false;
                }
                StatusDetails other = (StatusDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$errorMessage = this.getErrorMessage();
                String other$errorMessage = other.getErrorMessage();
                return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StatusDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $errorMessage = this.getErrorMessage();
                result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
                return result;
            }
        }
    }
}

