/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.CustomElement;
import com.structurizr.model.Element;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ElementNotPermittedInViewException;
import com.structurizr.view.ElementView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.StaticView;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public final class ComponentView
extends StaticView {
    private Container container;
    private String containerId;
    private boolean externalContainerBoundariesVisible = false;

    ComponentView() {
    }

    ComponentView(Container container, String key, String description) {
        super(container.getSoftwareSystem(), key, description);
        this.container = container;
    }

    @Override
    @JsonIgnore
    public String getSoftwareSystemId() {
        return super.getSoftwareSystemId();
    }

    public String getContainerId() {
        if (this.container != null) {
            return this.container.getId();
        }
        return this.containerId;
    }

    void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    @JsonIgnore
    public Container getContainer() {
        return this.container;
    }

    void setContainer(Container container) {
        this.container = container;
    }

    public void addAllContainers() {
        this.getSoftwareSystem().getContainers().forEach(c -> {
            try {
                this.add((Container)c);
            }
            catch (ElementNotPermittedInViewException elementNotPermittedInViewException) {
                // empty catch block
            }
        });
    }

    public void add(Container container) {
        this.add(container, true);
    }

    public void add(Container container, boolean addRelationships) {
        this.addElement(container, addRelationships);
    }

    public void addAllComponents() {
        this.container.getComponents().forEach(this::add);
    }

    public void add(Component component) {
        this.add(component, true);
    }

    public void add(Component component, boolean addRelationships) {
        if (component != null) {
            this.addElement(component, addRelationships);
        }
    }

    public void remove(Container container) {
        this.removeElement(container);
    }

    public void remove(Component component) {
        this.removeElement(component);
    }

    @Override
    public String getName() {
        return this.getSoftwareSystem().getName() + " - " + this.getContainer().getName() + " - Components";
    }

    @Override
    public void addDefaultElements() {
        for (Component component : this.getContainer().getComponents()) {
            this.add(component);
            for (Container container : this.getSoftwareSystem().getContainers()) {
                if (!container.hasEfferentRelationshipWith(component) && !component.hasEfferentRelationshipWith(container)) continue;
                this.add(container);
            }
            this.addNearestNeighbours(component, CustomElement.class);
            this.addNearestNeighbours(component, Person.class);
            this.addNearestNeighbours(component, SoftwareSystem.class);
        }
    }

    @Override
    public void addAllElements() {
        this.addAllSoftwareSystems();
        this.addAllPeople();
        this.addAllContainers();
        this.addAllComponents();
    }

    @Override
    public void addNearestNeighbours(@Nonnull Element element) {
        super.addNearestNeighbours(element, SoftwareSystem.class);
        super.addNearestNeighbours(element, Person.class);
        super.addNearestNeighbours(element, Container.class);
        super.addNearestNeighbours(element, Component.class);
    }

    public void addExternalDependencies() {
        HashSet<Element> components = new HashSet<Element>();
        this.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Component).forEach(components::add);
        for (Relationship relationship : this.getContainer().getModel().getRelationships()) {
            if (components.contains(relationship.getSource())) {
                this.addExternalDependency(relationship.getDestination(), components);
            }
            if (!components.contains(relationship.getDestination())) continue;
            this.addExternalDependency(relationship.getSource(), components);
        }
        this.getRelationships().stream().map(RelationshipView::getRelationship).filter(r -> !components.contains(r.getSource()) && !components.contains(r.getDestination())).forEach(this::remove);
    }

    private void addExternalDependency(Element element, Set<Element> components) {
        if (element instanceof Component) {
            if (element.getParent().equals(this.getContainer())) {
                return;
            }
            element = element.getParent();
        }
        if (element instanceof Container) {
            if (element.getParent().equals(this.getContainer().getParent())) {
                this.addElement(element, true);
                return;
            }
            element = element.getParent();
        }
        if (element instanceof SoftwareSystem || element instanceof Person) {
            this.addElement(element, true);
        }
    }

    @Override
    protected void checkElementCanBeAdded(Element element) {
        if (element instanceof CustomElement || element instanceof Person) {
            return;
        }
        if (element instanceof SoftwareSystem) {
            if (element.equals(this.getContainer().getParent())) {
                throw new ElementNotPermittedInViewException("The software system in scope cannot be added to a component view.");
            }
            this.checkParentAndChildrenHaveNotAlreadyBeenAdded((SoftwareSystem)element);
            return;
        }
        if (element instanceof Container) {
            if (element.equals(this.getContainer())) {
                throw new ElementNotPermittedInViewException("The container in scope cannot be added to a component view.");
            }
            this.checkParentAndChildrenHaveNotAlreadyBeenAdded((Container)element);
            return;
        }
        if (element instanceof Component) {
            this.checkParentAndChildrenHaveNotAlreadyBeenAdded((Component)element);
            return;
        }
        throw new ElementNotPermittedInViewException("Only people, software systems, containers, and components can be added to a component view.");
    }

    @Override
    protected boolean canBeRemoved(Element element) {
        return true;
    }

    public boolean getExternalContainerBoundariesVisible() {
        return this.externalContainerBoundariesVisible;
    }

    @Deprecated
    public void setExternalSoftwareSystemBoundariesVisible(boolean externalContainerBoundariesVisible) {
        this.externalContainerBoundariesVisible = externalContainerBoundariesVisible;
    }
}

