/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.model.CustomElement;
import com.structurizr.model.Element;
import com.structurizr.model.Person;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ElementNotPermittedInViewException;
import com.structurizr.view.StaticView;
import javax.annotation.Nonnull;

public final class SystemContextView
extends StaticView {
    private boolean enterpriseBoundaryVisible = true;

    SystemContextView() {
    }

    SystemContextView(SoftwareSystem softwareSystem, String key, String description) {
        super(softwareSystem, key, description);
        this.addElement(softwareSystem, true);
    }

    @Override
    public String getName() {
        return this.getSoftwareSystem().getName() + " - System Context";
    }

    @Override
    public void addDefaultElements() {
        this.addNearestNeighbours(this.getSoftwareSystem(), CustomElement.class);
        this.addNearestNeighbours(this.getSoftwareSystem(), Person.class);
        this.addNearestNeighbours(this.getSoftwareSystem(), SoftwareSystem.class);
    }

    @Override
    public void addAllElements() {
        this.addAllSoftwareSystems();
        this.addAllPeople();
    }

    @Override
    public void addNearestNeighbours(@Nonnull Element element) {
        if (element == null) {
            throw new IllegalArgumentException("An element must be specified.");
        }
        if (!(element instanceof Person) && !(element instanceof SoftwareSystem)) {
            throw new IllegalArgumentException("A person or software system must be specified.");
        }
        super.addNearestNeighbours(element, Person.class);
        super.addNearestNeighbours(element, SoftwareSystem.class);
    }

    @Deprecated
    public boolean isEnterpriseBoundaryVisible() {
        return this.enterpriseBoundaryVisible;
    }

    @Deprecated
    public void setEnterpriseBoundaryVisible(boolean enterpriseBoundaryVisible) {
        this.enterpriseBoundaryVisible = enterpriseBoundaryVisible;
    }

    @Override
    protected void checkElementCanBeAdded(Element element) {
        if (!(element instanceof CustomElement || element instanceof Person || element instanceof SoftwareSystem)) {
            throw new ElementNotPermittedInViewException("Only people and software systems can be added to a system context view.");
        }
    }

    @Override
    protected boolean canBeRemoved(Element element) {
        return !this.getSoftwareSystem().equals(element);
    }
}

