/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.ClientHandShake;
import com.sun.grizzly.websockets.ClientWebSocket;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.Selector;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ClientNetworkHandler
implements NetworkHandler {
    private Socket socket;
    private URL url;
    private ClientWebSocket webSocket;
    private Selector selector;
    private final ByteChunk chunk = new ByteChunk();
    private boolean isHeaderParsed = false;
    private OutputStream outputStream;
    private InputStream inputStream;

    public ClientNetworkHandler(ClientWebSocket webSocket) {
        this.url = webSocket.getAddress();
        this.webSocket = webSocket;
        try {
            this.connect();
            this.handshake();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.queueRead();
    }

    private void queueRead() {
        this.webSocket.execute(new Runnable(){

            public void run() {
                try {
                    ClientNetworkHandler.this.unframe();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        });
    }

    protected void connect() throws IOException {
        if ("ws".equals(this.url.getProtocol())) {
            this.socket = new Socket(this.url.getHost(), this.url.getPort());
        } else if ("wss".equals(this.url.getProtocol())) {
            this.socket = this.getSSLSocketFactory().createSocket(this.url.getHost(), this.url.getPort());
        } else {
            throw new IOException("Unknown schema: " + this.url.getProtocol());
        }
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
    }

    public void send(DataFrame frame) throws IOException {
        this.write(frame.frame());
    }

    protected void handshake() throws IOException {
        String path;
        boolean isSecure = "wss".equals(this.url.getProtocol());
        StringBuilder origin = new StringBuilder();
        origin.append(isSecure ? "https://" : "http://");
        origin.append(this.url.getHost());
        if (!isSecure && this.url.getPort() != 80 || isSecure && this.url.getPort() != 443) {
            origin.append(":").append(this.url.getPort());
        }
        if ("".equals(path = this.url.getPath())) {
            path = "/";
        }
        ClientHandShake clientHS = new ClientHandShake(isSecure, origin.toString(), this.url.getHost(), String.valueOf(this.url.getPort()), path);
        this.write(clientHS.getBytes());
        byte[] serverKey = this.findServerKey();
        if (serverKey == null) {
            return;
        }
        try {
            clientHS.validateServerResponse(serverKey);
        }
        catch (HandshakeException e) {
            throw new IOException(e.getMessage());
        }
        this.webSocket.onConnect();
    }

    protected void write(byte[] bytes) throws IOException {
        this.outputStream.write(bytes);
        this.outputStream.flush();
    }

    private void unframe() throws IOException {
        int lastRead;
        while ((lastRead = this.read()) > 0) {
            this.readFrame();
        }
        if (lastRead == -1) {
            throw new EOFException();
        }
        if (this.webSocket.isConnected()) {
            this.queueRead();
        }
    }

    private byte[] findServerKey() throws IOException {
        if (!this.isHeaderParsed) {
            byte[] line;
            this.read();
            do {
                if ((line = this.readLine()) != null) continue;
                return null;
            } while (line.length != 0);
        }
        this.isHeaderParsed = true;
        return this.readN(16);
    }

    private byte[] readLine() throws IOException {
        int idx;
        if (this.chunk.getLength() <= 0) {
            this.read();
        }
        if ((idx = this.chunk.indexOf('\n', 0)) != -1) {
            int eolBytes = 1;
            int offset = this.chunk.getOffset();
            if ((idx += offset) > offset && this.chunk.getBuffer()[idx - 1] == 13) {
                --idx;
                eolBytes = 2;
            }
            int size = idx - offset;
            byte[] result = new byte[size];
            this.chunk.substract(result, 0, size);
            this.chunk.setOffset(this.chunk.getOffset() + eolBytes);
            return result;
        }
        return null;
    }

    private byte[] readN(int n) throws IOException {
        if (this.chunk.getLength() < n) {
            return null;
        }
        byte[] result = new byte[n];
        this.chunk.substract(result, 0, n);
        return result;
    }

    public void shutdown() throws IOException {
        this.socket.close();
    }

    public ClientWebSocket getWebSocket() {
        return this.webSocket;
    }

    public void setWebSocket(WebSocket webSocket) {
        this.webSocket = (ClientWebSocket)webSocket;
    }

    protected void readFrame() throws IOException {
        while (this.read() > 0) {
            DataFrame dataFrame = DataFrame.read(this);
            if (dataFrame != null) {
                dataFrame.respond(this.webSocket);
                continue;
            }
            this.webSocket.close();
        }
    }

    private int read() throws IOException {
        int length;
        int count = this.chunk.getLength();
        if (count < 1) {
            byte[] bytes = new byte[8192];
            while ((count = this.inputStream.read(bytes)) == 8192) {
                this.chunk.append(bytes, 0, count);
            }
            if (count > 0) {
                this.chunk.append(bytes, 0, count);
            }
        }
        if ((length = this.chunk.getLength()) <= 0) {
            return count;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte get() throws IOException {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            this.fill();
            return (byte)this.chunk.substract();
        }
    }

    private void fill() throws IOException {
        if (this.chunk.getLength() == 0) {
            this.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean peek(byte ... bytes) throws IOException {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            this.fill();
            return this.chunk.startsWith(bytes);
        }
    }

    public SSLSocketFactory getSSLSocketFactory() throws IOException {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            return sc.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }
}

