/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl;

import com.sun.xml.internal.stream.StaxEntityResolverWrapper;
import java.util.HashMap;
import javax.xml.stream.XMLResolver;

public class PropertyManager {
    protected static final String STAX_NOTATIONS = "javax.xml.stream.notations";
    protected static final String STAX_ENTITIES = "javax.xml.stream.entities";
    private static final String STRING_INTERNING = "http://xml.org/sax/features/string-interning".intern();
    HashMap supportedProps = new HashMap();
    public static final int CONTEXT_READER = 1;
    public static final int CONTEXT_WRITER = 2;

    public PropertyManager(int context) {
        switch (context) {
            case 1: {
                this.initConfigurableReaderProperties();
                break;
            }
            case 2: {
                this.initWriterProps();
            }
        }
    }

    public PropertyManager(PropertyManager propertyManager) {
        HashMap properties = propertyManager.getProperties();
        this.supportedProps.putAll(properties);
    }

    private HashMap getProperties() {
        return this.supportedProps;
    }

    private void initConfigurableReaderProperties() {
        this.supportedProps.put("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        this.supportedProps.put("javax.xml.stream.isValidating", Boolean.FALSE);
        this.supportedProps.put("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        this.supportedProps.put("javax.xml.stream.isSupportingExternalEntities", Boolean.TRUE);
        this.supportedProps.put("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.supportedProps.put("javax.xml.stream.supportDTD", Boolean.TRUE);
        this.supportedProps.put("javax.xml.stream.reporter", null);
        this.supportedProps.put("javax.xml.stream.resolver", null);
        this.supportedProps.put("javax.xml.stream.allocator", null);
        this.supportedProps.put(STAX_NOTATIONS, null);
        this.supportedProps.put("http://xml.org/sax/features/string-interning", new Boolean(true));
        this.supportedProps.put("http://apache.org/xml/features/allow-java-encodings", new Boolean(true));
        this.supportedProps.put("add-namespacedecl-as-attrbiute", Boolean.FALSE);
        this.supportedProps.put("http://java.sun.com/xml/stream/properties/reader-in-defined-state", new Boolean(true));
        this.supportedProps.put("reuse-instance", new Boolean(true));
        this.supportedProps.put("http://java.sun.com/xml/stream/properties/report-cdata-event", new Boolean(false));
        this.supportedProps.put("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", new Boolean(false));
        this.supportedProps.put("http://apache.org/xml/features/warn-on-duplicate-entitydef", new Boolean(false));
        this.supportedProps.put("http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", new Boolean(false));
    }

    private void initWriterProps() {
        this.supportedProps.put("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
        this.supportedProps.put("escapeCharacters", Boolean.TRUE);
        this.supportedProps.put("reuse-instance", new Boolean(true));
    }

    public boolean containsProperty(String property) {
        return this.supportedProps.containsKey(property);
    }

    public Object getProperty(String property) {
        if (property == null) {
            return null;
        }
        if (this.supportedProps.containsKey(property)) {
            return this.supportedProps.get(property);
        }
        return null;
    }

    public void setProperty(String property, Object value) {
        String equivalentProperty = null;
        if (property == "javax.xml.stream.isNamespaceAware" || property.equals("javax.xml.stream.isNamespaceAware")) {
            equivalentProperty = "http://apache.org/xml/features/namespaces";
        } else if (property == "javax.xml.stream.isValidating" || property.equals("javax.xml.stream.isValidating")) {
            if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                throw new IllegalArgumentException("true value of isValidating not supported");
            }
        } else if (property == STRING_INTERNING || property.equals(STRING_INTERNING)) {
            if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
                throw new IllegalArgumentException("false value of " + STRING_INTERNING + "feature is not supported");
            }
        } else if (property == "javax.xml.stream.resolver" || property.equals("javax.xml.stream.resolver")) {
            this.supportedProps.put("http://apache.org/xml/properties/internal/stax-entity-resolver", new StaxEntityResolverWrapper((XMLResolver)value));
        }
        this.supportedProps.put(property, value);
        if (equivalentProperty != null) {
            this.supportedProps.put(equivalentProperty, value);
        }
    }

    public String toString() {
        return this.supportedProps.toString();
    }
}

