/*
 * Copyright (c) 1997, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.xml.ws.resources;

import java.util.Locale;
import java.util.ResourceBundle;
import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class HttpserverMessages {

    private final static String BUNDLE_NAME = "com.sun.xml.ws.resources.httpserver";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new HttpserverMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    private HttpserverMessages() {
    }

    public static Localizable localizableUNEXPECTED_HTTP_METHOD(Object arg0) {
        return MESSAGE_FACTORY.getMessage("unexpected.http.method", arg0);
    }

    /**
     * Cannot handle HTTP method: {0}
     * 
     */
    public static String UNEXPECTED_HTTP_METHOD(Object arg0) {
        return LOCALIZER.localize(localizableUNEXPECTED_HTTP_METHOD(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
