/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.db.sdo;

import com.sun.xml.ws.db.sdo.SAX2DOMContentHandler;
import com.sun.xml.ws.db.sdo.SDODatabindingSchemaResolver;
import com.sun.xml.ws.db.sdo.SchemaInfo;
import com.sun.xml.ws.db.sdo.Stax2SAXAdapter;
import com.sun.xml.ws.util.xml.XmlUtil;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.helper.XSDHelper;
import commonj.sdo.impl.HelperProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.SchemaResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.NamespaceSupport;

public final class SDOUtils {
    public static final String NS_XMLNS = "http://www.w3.org/2001/XMLSchema";
    public static final String NS_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    private static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    private static final QName SCHEMA_INCLUDE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "include");
    private static final QName SCHEMA_IMPORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "import");
    public static final QName QNAME_SCHEMA = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    static volatile TransformerFactory transformerFactory = null;
    static volatile DocumentBuilderFactory dbf = null;

    private SDOUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Transformer newTransformer() {
        if (transformerFactory == null) {
            Class<SDOUtils> clazz = SDOUtils.class;
            // MONITORENTER : com.sun.xml.ws.db.sdo.SDOUtils.class
            if (transformerFactory == null) {
                transformerFactory = XmlUtil.newTransformerFactory((boolean)false);
            }
            // MONITOREXIT : clazz
        }
        try {
            return transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static DocumentBuilder newDocumentBuilder() {
        if (dbf == null) {
            Class<SDOUtils> clazz = SDOUtils.class;
            // MONITORENTER : com.sun.xml.ws.db.sdo.SDOUtils.class
            if (dbf == null) {
                DocumentBuilderFactory tmpDBF = XmlUtil.newDocumentBuilderFactory((boolean)false);
                tmpDBF.setValidating(false);
                tmpDBF.setNamespaceAware(true);
                tmpDBF.setIgnoringElementContentWhitespace(true);
                tmpDBF.setIgnoringComments(true);
                dbf = tmpDBF;
            }
            // MONITOREXIT : clazz
        }
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Element sdoToDom(HelperContext hc, DataObject obj, String targetNamespace, String localName) throws ParserConfigurationException, IOException {
        SDOXMLHelper sdoXMLHelper = (SDOXMLHelper)hc.getXMLHelper();
        sdoXMLHelper.setTimeZoneQualified(true);
        XMLDocument xmlDoc = sdoXMLHelper.createDocument(obj, targetNamespace, localName);
        if (xmlDoc == null) {
            return null;
        }
        Document doc = SDOUtils.newDocumentBuilder().newDocument();
        DOMResult result = new DOMResult(doc);
        sdoXMLHelper.save(xmlDoc, (Result)result, null);
        return ((Document)result.getNode()).getDocumentElement();
    }

    public static Source sdoToXML(HelperContext hc, DataObject obj, String targetNamespace, String localName) throws ParserConfigurationException, IOException {
        SDOXMLHelper sdoXMLHelper = (SDOXMLHelper)hc.getXMLHelper();
        sdoXMLHelper.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdoXMLHelper.setTimeZoneQualified(true);
        XMLDocument xmlDoc = sdoXMLHelper.createDocument(obj, targetNamespace, localName);
        if (xmlDoc == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(bout);
        sdoXMLHelper.save(xmlDoc, (Result)result, null);
        byte[] bytes = bout.toByteArray();
        System.out.println("data obj converted to xml: " + new String(bytes));
        return new StreamSource(new ByteArrayInputStream(bytes));
    }

    public static void registerSDOContext(HelperContext context, List<Source> schemas) {
        SDOXSDHelper xsdHelper = (SDOXSDHelper)context.getXSDHelper();
        SDODatabindingSchemaResolver schemaResolver = new SDODatabindingSchemaResolver(schemas);
        for (Source source : schemas) {
            xsdHelper.define(source, (SchemaResolver)schemaResolver);
        }
    }

    public static List<Source> getSchemaClosureFromWSDL(Source wsdlSource) {
        String systemId = wsdlSource.getSystemId();
        Document wsdl = SDOUtils.createDOM(wsdlSource);
        ArrayList<Source> list = new ArrayList<Source>();
        SDOUtils.addSchemaFragmentSource(wsdl, systemId, list);
        return list;
    }

    public static Document createDOM(Source wsdlSource) {
        Transformer trans = SDOUtils.newTransformer();
        DocumentBuilder builder = SDOUtils.newDocumentBuilder();
        Document doc = builder.newDocument();
        DOMResult result = new DOMResult(doc);
        try {
            trans.transform(wsdlSource, result);
        }
        catch (TransformerException te) {
            throw new RuntimeException(te);
        }
        return (Document)result.getNode();
    }

    public static Map<String, Source> getMetadataClosure(List<Source> schemas) {
        HashMap<String, Source> closureDocs = new HashMap<String, Source>();
        HashMap<String, Source> currentDocs = new HashMap<String, Source>();
        for (Source src : schemas) {
            currentDocs.put(src.getSystemId(), src);
        }
        HashSet remaining = new HashSet(currentDocs.keySet());
        while (!remaining.isEmpty()) {
            Iterator it = remaining.iterator();
            String current = (String)it.next();
            remaining.remove(current);
            Source currentDoc = (Source)currentDocs.get(current);
            if (currentDoc == null) {
                currentDoc = SDOUtils.loadSourceFromURL(current);
            }
            HashSet<String> imports = new HashSet<String>();
            currentDoc = SDOUtils.getImports(currentDoc, imports);
            closureDocs.put(current, currentDoc);
            for (String importedDoc : imports) {
                if (closureDocs.get(importedDoc) != null) continue;
                remaining.add(importedDoc);
            }
        }
        return closureDocs;
    }

    private static Source loadSourceFromURL(String systemID) {
        StreamSource targetXSD;
        try {
            URL targetURL = new URL(systemID);
            InputStream is = targetURL.openStream();
            targetXSD = new StreamSource(is);
            targetXSD.setSystemId(targetURL.toExternalForm());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return targetXSD;
    }

    private static Source getImports(Source currentDoc, Set<String> importedDocs) {
        Document doc = SDOUtils.createDOM(currentDoc);
        Element root = doc.getDocumentElement();
        try {
            URL u;
            String importedDoc;
            Element e;
            int i;
            NodeList imports = root.getElementsByTagNameNS(SCHEMA_INCLUDE_QNAME.getNamespaceURI(), SCHEMA_INCLUDE_QNAME.getLocalPart());
            NodeList includes = root.getElementsByTagNameNS(SCHEMA_IMPORT_QNAME.getNamespaceURI(), SCHEMA_INCLUDE_QNAME.getLocalPart());
            if (imports != null) {
                for (i = 0; i < imports.getLength(); ++i) {
                    e = (Element)imports.item(i);
                    importedDoc = e.getAttributeNS("http://www.w3.org/2001/XMLSchema", "schemaLocation");
                    if (importedDoc == null) continue;
                    u = new URL(currentDoc.getSystemId());
                    importedDocs.add(new URL(u, importedDoc).toString());
                }
            }
            if (includes != null) {
                for (i = 0; i < imports.getLength(); ++i) {
                    e = (Element)imports.item(i);
                    importedDoc = e.getAttributeNS("http://www.w3.org/2001/XMLSchema", "schemaLocation");
                    if (importedDoc == null) continue;
                    u = new URL(currentDoc.getSystemId());
                    importedDocs.add(new URL(u, importedDoc).toString());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new DOMSource(doc, currentDoc.getSystemId());
    }

    private static void addSchemaFragmentSource(Document doc, String systemId, List<Source> list) {
        Element e = doc.getDocumentElement();
        assert (e.getNamespaceURI().equals(NS_WSDL));
        assert (e.getLocalName().equals("definitions"));
        NodeList typesList = e.getElementsByTagNameNS(NS_WSDL, "types");
        for (int i = 0; i < typesList.getLength(); ++i) {
            NodeList schemaList = ((Element)typesList.item(i)).getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int j = 0; j < schemaList.getLength(); ++j) {
                Element elem = (Element)schemaList.item(j);
                NamespaceSupport nss = new NamespaceSupport();
                SDOUtils.buildNamespaceSupport(nss, elem);
                SDOUtils.patchDOMFragment(nss, elem);
                list.add(new DOMSource(elem, systemId + "#schema" + j));
            }
        }
    }

    private static void buildNamespaceSupport(NamespaceSupport nss, Node node) {
        if (node == null || node.getNodeType() != 1) {
            return;
        }
        SDOUtils.buildNamespaceSupport(nss, node.getParentNode());
        nss.pushContext();
        NamedNodeMap atts = node.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr a = (Attr)atts.item(i);
            if ("xmlns".equals(a.getPrefix())) {
                nss.declarePrefix(a.getLocalName(), a.getValue());
                continue;
            }
            if (!"xmlns".equals(a.getName())) continue;
            nss.declarePrefix("", a.getValue());
        }
    }

    private static void patchDOMFragment(NamespaceSupport nss, Element elem) {
        NamedNodeMap atts = elem.getAttributes();
        Enumeration<String> en = nss.getPrefixes();
        while (en.hasMoreElements()) {
            String prefix = en.nextElement();
            for (int i = 0; i < atts.getLength(); ++i) {
                Attr a = (Attr)atts.item(i);
                if ("xmlns".equals(a.getPrefix()) && a.getLocalName().equals("prefix")) continue;
                elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nss.getURI(prefix));
            }
        }
    }

    public static Object unwrapPrimitives(Object obj) {
        if (obj == null) {
            return obj;
        }
        if (!(obj instanceof DataObject)) {
            return obj;
        }
        DataObject dataObject = (DataObject)obj;
        if (dataObject.getClass().getName().endsWith("WrapperImpl")) {
            if (dataObject.get(0) != null) {
                System.out.println("unwrapped object: " + dataObject.get(0).getClass().getName());
            }
            return dataObject.get(0);
        }
        return obj;
    }

    public static void printDOM(Source src) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult sr = new StreamResult(bos);
            TransformerFactory tf = XmlUtil.newTransformerFactory((boolean)false);
            Transformer trans = tf.newTransformer();
            trans.transform(src, sr);
            System.out.println("**********\n" + bos);
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String dom2String(DOMSource domSrc) throws TransformerException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult sr = new StreamResult(bos);
        TransformerFactory tf = XmlUtil.newTransformerFactory((boolean)false);
        Transformer trans = tf.newTransformer();
        trans.transform(domSrc, sr);
        return sr.toString();
    }

    public static void printXMLReader(XMLStreamReader xml) {
        try {
            Document doc = SDOUtils.newDocument();
            SAX2DOMContentHandler handler = new SAX2DOMContentHandler(doc);
            Stax2SAXAdapter adapter = new Stax2SAXAdapter(xml, false);
            adapter.parse(handler);
            SDOUtils.printDOM(new DOMSource(doc));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static QName getPropertyElementName(HelperContext context, Property p) {
        XSDHelper helper = context.getXSDHelper();
        String localName = p.getName();
        String ns = helper.getNamespaceURI(p);
        return new QName(ns, localName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SDOType> defineSchema(HelperContext hc, File f) throws Exception {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(f);
            InputStreamReader reader = new InputStreamReader(fin);
            StreamSource source = new StreamSource(reader);
            List list = ((SDOXSDHelper)hc.getXSDHelper()).define((Source)source, null);
            return list;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Document newDocument() {
        return SDOUtils.newDocumentBuilder().newDocument();
    }

    public static boolean validateBuiltinType(String javaType, QName qname) {
        return SDOUtils.validateSupportedType(HelperProvider.getDefaultContext(), javaType, qname);
    }

    public static boolean validateSupportedType(HelperContext hc, String javaType, QName qname) {
        TypeHelper typeHelper = hc.getTypeHelper();
        if (qname != null) {
            Type type = typeHelper.getType(qname.getNamespaceURI(), qname.getLocalPart());
            String java = ((SDOType)type).getInstanceClassName();
            if (java != null) {
                return java.equals(javaType);
            }
            return false;
        }
        if (SDOUtils.isPrimitive(javaType)) {
            return true;
        }
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(javaType);
            Type type = typeHelper.getType(cls);
            return type != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean isPrimitive(String type) {
        return type.equals("int") || type.equals("short") || type.equals("long") || type.equals("byte") || type.equals("float") || type.equals("double") || type.equals("boolean");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<SchemaInfo> getSchemas(File f) throws Exception {
        try (FileInputStream fin = null;){
            fin = new FileInputStream(f);
            StreamSource source = new StreamSource(fin);
            source.setSystemId(f.toURI().toURL().toExternalForm());
            ArrayList<Source> main_schema = new ArrayList<Source>();
            main_schema.add(source);
            Map<String, Source> map = SDOUtils.getMetadataClosure(main_schema);
            HashSet<SchemaInfo> schemas = new HashSet<SchemaInfo>();
            for (Map.Entry<String, Source> entry : map.entrySet()) {
                SchemaInfo info = new SchemaInfo(entry.getKey(), null, entry.getValue());
                schemas.add(info);
            }
            HashSet<SchemaInfo> hashSet = schemas;
            return hashSet;
        }
    }

    public static Set<SchemaInfo> getSchemas(String filePath) throws Exception {
        HashSet<SchemaInfo> schemas = new HashSet<SchemaInfo>();
        Document document = SDOUtils.newDocumentBuilder().parse(new File(filePath));
        Element rootEl = document.getDocumentElement();
        if (QNAME_SCHEMA.equals(new QName(rootEl.getNamespaceURI(), rootEl.getLocalName()))) {
            SchemaInfo info = new SchemaInfo(filePath, null, new DOMSource(rootEl));
            schemas.add(info);
        } else if (NS_WSDL.equals(rootEl.getNamespaceURI())) {
            Node types = null;
            Node n = rootEl.getFirstChild();
            while (types == null) {
                if (n instanceof Element && n.getLocalName().equals("types")) {
                    types = (Element)n;
                    continue;
                }
                n = n.getNextSibling();
            }
            NodeList nl = types.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node x = nl.item(i);
                if (!(x instanceof Element) || !x.getLocalName().equals("schema")) continue;
                SchemaInfo info = new SchemaInfo(filePath, null, new DOMSource(x));
                schemas.add(info);
            }
        }
        return schemas;
    }
}

