/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.rm.CloseSequenceException;
import com.sun.xml.ws.rm.InvalidSequenceException;
import com.sun.xml.ws.rm.MessageNumberRolloverException;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.RMMessage;
import com.sun.xml.ws.rm.RMVersion;
import com.sun.xml.ws.rm.jaxws.runtime.InboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.RMProvider;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.protocol.AbstractAckRequested;
import com.sun.xml.ws.rm.protocol.AbstractSequence;
import com.sun.xml.ws.rm.protocol.AbstractSequenceAcknowledgement;
import com.sun.xml.ws.rm.v200502.SequenceElement;
import com.sun.xml.ws.rm.v200702.AckRequestedElement;
import com.sun.xml.ws.rm.v200702.SequenceAcknowledgementElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class InboundMessageProcessor {
    private static final RmLogger LOGGER = RmLogger.getLogger(InboundMessageProcessor.class);

    private InboundMessageProcessor() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void processMessage(RMMessage message, Unmarshaller unmarshaller, RMProvider provider, RMVersion rmVersion) throws RMException {
        Object el;
        InboundSequence inseq = null;
        Header header = InboundMessageProcessor.getHeader(message.getHeaders(), "Sequence", rmVersion);
        if (header != null) {
            try {
                int messageNumber;
                el = (AbstractSequence)header.readAsJAXB(unmarshaller);
                message.setSequenceElement((AbstractSequence)el);
                String seqid = null;
                if (el instanceof SequenceElement) {
                    seqid = ((SequenceElement)el).getId();
                    messageNumber = ((SequenceElement)el).getNumber();
                } else {
                    seqid = ((com.sun.xml.ws.rm.v200702.SequenceElement)el).getId();
                    messageNumber = ((com.sun.xml.ws.rm.v200702.SequenceElement)el).getNumber();
                }
                if (messageNumber == Integer.MAX_VALUE) {
                    throw LOGGER.logSevereException(new MessageNumberRolloverException(LocalizationMessages.WSRM_3026_MESSAGE_NUMBER_ROLLOVER(messageNumber), messageNumber));
                }
                inseq = provider.getInboundSequence(seqid);
                if (inseq == null) throw LOGGER.logSevereException(new InvalidSequenceException(LocalizationMessages.WSRM_3022_UNKNOWN_SEQUENCE_ID_IN_MESSAGE(seqid), seqid));
                if (inseq.isClosed()) {
                    throw LOGGER.logSevereException(new CloseSequenceException(LocalizationMessages.WSRM_3029_SEQUENCE_CLOSED(seqid), seqid));
                }
                inseq.set(messageNumber, message);
            }
            catch (JAXBException e) {
                throw LOGGER.logSevereException(new RMException("Unable to unmarshall Sequence RM header", e));
            }
        }
        if ((header = InboundMessageProcessor.getHeader(message.getHeaders(), "SequenceAcknowledgement", rmVersion)) != null) {
            try {
                AbstractSequenceAcknowledgement ackHeader = (AbstractSequenceAcknowledgement)header.readAsJAXB(unmarshaller);
                String ackHeaderId = null;
                ackHeaderId = ackHeader instanceof com.sun.xml.ws.rm.v200502.SequenceAcknowledgementElement ? ((com.sun.xml.ws.rm.v200502.SequenceAcknowledgementElement)ackHeader).getId() : ((SequenceAcknowledgementElement)ackHeader).getId();
                message.setSequenceAcknowledgementElement(ackHeader);
                OutboundSequence seq = provider.getOutboundSequence(ackHeaderId);
                if (seq != null) {
                    seq.handleAckResponse(ackHeader);
                }
            }
            catch (JAXBException e) {
                throw LOGGER.logSevereException(new RMException("Unable to unmarshall SequenceAcknowledgement RM header", e));
            }
        }
        if ((header = InboundMessageProcessor.getHeader(message.getHeaders(), "AckRequested", rmVersion)) != null) {
            try {
                el = (AbstractAckRequested)header.readAsJAXB(unmarshaller);
                message.setAckRequestedElement((AbstractAckRequested)el);
                String id = null;
                id = el instanceof com.sun.xml.ws.rm.v200502.AckRequestedElement ? ((com.sun.xml.ws.rm.v200502.AckRequestedElement)el).getId() : ((AckRequestedElement)el).getId();
                InboundSequence seq = provider.getInboundSequence(id);
                if (seq == null) return;
                seq.handleAckRequested();
                return;
            }
            catch (JAXBException e) {
                throw LOGGER.logSevereException(new RMException("Unable to unmarshall AckRequested RM header", e));
            }
        } else {
            if (inseq == null) return;
            inseq.handleAckRequested();
        }
    }

    private static Header getHeader(HeaderList headers, String name, RMVersion rmVersion) {
        return headers != null ? headers.get(rmVersion.namespaceUri, name, true) : null;
    }
}

