/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.rm.SequenceSettings;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.WSDLPolicyMapWrapper;
import com.sun.xml.ws.rm.RMVersion;
import com.sun.xml.ws.rm.localization.RmLogger;
import java.net.URI;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public class SequenceConfig
implements SequenceSettings {
    private static final RmLogger LOGGER = RmLogger.getLogger(SequenceConfig.class);
    private static final QName ORDERED_QNAME = new QName("http://sun.com/2006/03/rm", "Ordered");
    private static final QName ALLOW_DUPLICATES_QNAME = new QName("http://sun.com/2006/03/rm", "AllowDuplicates");
    private static final QName RESEND_INTERVAL_QNAME = new QName("http://sun.com/2006/03/rm/client", "ResendInterval");
    private static final QName ACK_REQUEST_INTERVAL_QNAME = new QName("http://sun.com/2006/03/rm/client", "AckRequestInterval");
    private static final QName CLOSE_TIMEOUT_QNAME = new QName("http://sun.com/2006/03/rm/client", "CloseTimeout");
    private static final QName RM_FLOW_CONTROL_QNAME = new QName("http://schemas.microsoft.com/net/2005/02/rm/policy", "RmFlowControl");
    private static final QName MAX_RECEIVE_BUFFER_SIZE_QNAME = new QName("http://schemas.microsoft.com/net/2005/02/rm/policy", "MaxReceiveBufferSize");
    private static final QName MILLISECONDS_ATTRIBUTE_QNAME = new QName("", "Milliseconds");
    private String acksTo;
    private long ackRequestInterval;
    private AddressingVersion addressingVersion;
    private URI anonymousAddressingUri;
    private boolean allowDuplicatesEnabled;
    private int bufferSize;
    private long closeTimeout;
    private String companionSequenceId;
    private boolean flowControlRequired;
    private boolean ordered;
    private long inactivityTimeout;
    private long resendInterval;
    private RMVersion rmVersion;
    private String sequenceId;
    private boolean sequenceSTRRequired;
    private boolean sequenceTransportSecurityRequired;
    private SOAPVersion soapVersion;

    public SequenceConfig() {
        this(null, null, null);
    }

    public SequenceConfig(WSDLPort port, AddressingVersion addressing, SOAPVersion soap) {
        this.ackRequestInterval = 0L;
        this.addressingVersion = addressing != null ? addressing : AddressingVersion.W3C;
        this.acksTo = this.addressingVersion.anonymousUri;
        try {
            this.anonymousAddressingUri = new URI(this.addressingVersion.anonymousUri);
        }
        catch (Throwable e) {
            throw LOGGER.logSevereException(new WebServiceException("Unable to initialize sequence configuration due to an unexpected exception", e));
        }
        this.allowDuplicatesEnabled = false;
        this.bufferSize = 32;
        this.closeTimeout = 0L;
        this.flowControlRequired = false;
        this.inactivityTimeout = 600000L;
        this.ordered = false;
        this.resendInterval = 0L;
        this.sequenceSTRRequired = false;
        this.sequenceTransportSecurityRequired = false;
        SOAPVersion sOAPVersion = this.soapVersion = soap != null ? soap : SOAPVersion.SOAP_12;
        if (port != null) {
            PolicyMap policyMap = ((WSDLPolicyMapWrapper)port.getBinding().getOwner().getExtension(WSDLPolicyMapWrapper.class)).getPolicyMap();
            try {
                this.init(port, policyMap);
            }
            catch (PolicyException e) {
                throw LOGGER.logSevereException(new WebServiceException("Unable to initialize sequence configuration due to an unexpected exception", (Throwable)e));
            }
        }
    }

    public SequenceConfig(SequenceSettings settings) {
        this.ackRequestInterval = settings.getAckRequestInterval();
        this.acksTo = settings.getAcksTo();
        this.addressingVersion = settings.getAddressingVersion();
        this.allowDuplicatesEnabled = settings.isAllowDuplicatesEnabled();
        this.anonymousAddressingUri = settings.getAnonymousAddressingUri();
        this.bufferSize = settings.getBufferSize();
        this.closeTimeout = settings.getCloseTimeout();
        this.flowControlRequired = settings.isFlowControlRequired();
        this.inactivityTimeout = settings.getInactivityTimeout();
        this.ordered = settings.isOrdered();
        this.resendInterval = settings.getResendInterval();
        this.rmVersion = settings.getRMVersion();
        this.soapVersion = settings.getSoapVersion();
        this.sequenceSTRRequired = settings.isSequenceSTRRequired();
        this.sequenceTransportSecurityRequired = settings.isSequenceTransportSecurityRequired();
    }

    public String getAcksTo() {
        return this.acksTo;
    }

    public AddressingVersion getAddressingVersion() {
        return this.addressingVersion;
    }

    public URI getAnonymousAddressingUri() {
        return this.anonymousAddressingUri;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public long getCloseTimeout() {
        return this.closeTimeout;
    }

    public SOAPVersion getSoapVersion() {
        if (this.soapVersion != null) {
            return this.soapVersion;
        }
        return SOAPVersion.SOAP_12;
    }

    public boolean isFlowControlRequired() {
        return this.flowControlRequired;
    }

    public long getResendInterval() {
        return this.resendInterval;
    }

    public long getAckRequestInterval() {
        return this.ackRequestInterval;
    }

    public boolean isAllowDuplicatesEnabled() {
        return this.allowDuplicatesEnabled;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(String id) {
        this.sequenceId = id;
    }

    public String getCompanionSequenceId() {
        return this.companionSequenceId;
    }

    public void setCompanionSequenceId(String id) {
        this.companionSequenceId = id;
    }

    public RMVersion getRMVersion() {
        return this.rmVersion;
    }

    public boolean isSequenceSTRRequired() {
        return this.sequenceSTRRequired;
    }

    public boolean isSequenceTransportSecurityRequired() {
        return this.sequenceTransportSecurityRequired;
    }

    private void init(WSDLPort port, PolicyMap policyMap) throws PolicyException {
        PolicyMapKey endpointScopeKey;
        if (policyMap != null && (endpointScopeKey = PolicyMap.createWsdlEndpointScopeKey(port.getOwner().getName(), port.getName())) != null) {
            Iterator<Object> i$;
            AssertionSet policyAssertionSet = null;
            Policy policy = null;
            policy = policyMap.getEndpointEffectivePolicy(endpointScopeKey);
            if (policy != null && (i$ = policy.iterator()).hasNext()) {
                AssertionSet set;
                policyAssertionSet = set = (AssertionSet)i$.next();
            }
            if (policyAssertionSet != null) {
                for (PolicyAssertion assertion : policyAssertionSet) {
                    String num;
                    QName qname = assertion.getName();
                    if (RMVersion.WSRM10.rmPolicyAssertionQName.equals(qname)) {
                        this.rmVersion = RMVersion.WSRM10;
                        this.handleRMAssertion(assertion);
                        continue;
                    }
                    if (RMVersion.WSRM11.rmPolicyAssertionQName.equals(qname)) {
                        this.rmVersion = RMVersion.WSRM11;
                        this.handleRMAssertion(assertion);
                        continue;
                    }
                    if (RM_FLOW_CONTROL_QNAME.equals(qname)) {
                        this.handleFlowAssertion(assertion);
                        continue;
                    }
                    if (ORDERED_QNAME.equals(qname)) {
                        this.ordered = true;
                        continue;
                    }
                    if (ALLOW_DUPLICATES_QNAME.equals(qname)) {
                        this.allowDuplicatesEnabled = true;
                        continue;
                    }
                    if (ACK_REQUEST_INTERVAL_QNAME.equals(qname)) {
                        num = assertion.getAttributeValue(MILLISECONDS_ATTRIBUTE_QNAME);
                        if (num == null) continue;
                        this.ackRequestInterval = Long.parseLong(num);
                        continue;
                    }
                    if (RESEND_INTERVAL_QNAME.equals(qname)) {
                        num = assertion.getAttributeValue(MILLISECONDS_ATTRIBUTE_QNAME);
                        if (num == null) continue;
                        this.resendInterval = Long.parseLong(num);
                        continue;
                    }
                    if (CLOSE_TIMEOUT_QNAME.equals(qname)) {
                        num = assertion.getAttributeValue(MILLISECONDS_ATTRIBUTE_QNAME);
                        if (num == null) continue;
                        this.closeTimeout = Long.parseLong(num);
                        continue;
                    }
                    if (RMVersion.WSRM11.sequenceSTRAssertionQName.equals(qname)) {
                        this.sequenceSTRRequired = true;
                        continue;
                    }
                    if (!RMVersion.WSRM11.sequenceTransportSecurityAssertionQName.equals(qname)) continue;
                    this.sequenceTransportSecurityRequired = true;
                }
            }
        }
    }

    private void handleRMAssertion(PolicyAssertion rmAssertion) {
        Iterator<PolicyAssertion> it = rmAssertion.getNestedAssertionsIterator();
        while (it != null && it.hasNext()) {
            String num;
            PolicyAssertion assertion = it.next();
            if (!assertion.getName().equals(this.rmVersion.inactivityTimeoutAssertionQName) || (num = assertion.getAttributeValue(new QName("", "Milliseconds"))) == null) continue;
            this.inactivityTimeout = Long.parseLong(num);
        }
    }

    private void handleFlowAssertion(PolicyAssertion flowAssertion) {
        this.flowControlRequired = true;
        Iterator<PolicyAssertion> it = flowAssertion.getNestedAssertionsIterator();
        while (it != null && it.hasNext()) {
            PolicyAssertion assertion = it.next();
            if (!MAX_RECEIVE_BUFFER_SIZE_QNAME.equals(assertion.getName())) continue;
            this.bufferSize = Integer.parseInt(assertion.getValue());
            break;
        }
    }
}

