/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.client;

import com.sun.xml.ws.addressing.policy.Address;
import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.client.STSIssuedTokenConfiguration;
import com.sun.xml.ws.api.security.trust.client.SecondaryIssuedTokenParameters;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelGenerator;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.ws.policy.sourcemodel.XmlPolicyModelMarshaller;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.IssuedToken;
import com.sun.xml.ws.security.policy.Issuer;
import com.sun.xml.ws.security.policy.RequestSecurityTokenTemplate;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.impl.client.SecondaryIssuedTokenParametersImpl;
import com.sun.xml.ws.security.trust.impl.elements.ClaimsImpl;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultSTSIssuedTokenConfiguration
extends STSIssuedTokenConfiguration {
    private static final String PRE_CONFIGURED_STS = "PreconfiguredSTS";
    private static final String NAMESPACE = "namespace";
    private static final String CONFIG_NAMESPACE = "";
    private static final String ENDPOINT = "endPoint";
    private static final String METADATA = "metadata";
    private static final String WSDL_LOCATION = "wsdlLocation";
    private static final String SERVICE_NAME = "serviceName";
    private static final String PORT_NAME = "portName";
    private static final String REQUEST_SECURITY_TOKEN_TEMPLATE = "RequestSecurityTokenTemplate";
    private static final String CLAIMS = "Claims";
    private static final String DIALECT = "Dialect";
    private String tokenType = null;
    private String keyType = null;
    private long keySize = -1L;
    private String signatureAlg = null;
    private String encAlg = null;
    private String canAlg = null;
    private String keyWrapAlg = null;
    private Token oboToken = null;
    private String signWith = null;
    private String encryptWith = null;
    private Claims claims = null;

    public DefaultSTSIssuedTokenConfiguration(String protocol, IssuedToken issuedToken, PolicyAssertion localToken) {
        this.protocol = protocol;
        this.parseAssertions(issuedToken, localToken);
    }

    public DefaultSTSIssuedTokenConfiguration(String stsEndpoint, String stsMEXAddress) {
        super(stsEndpoint, stsMEXAddress);
    }

    public DefaultSTSIssuedTokenConfiguration(String stsEndpoint, String stsWSDLLocation, String stsServiceName, String stsPortName, String stsNamespace) {
        super(stsEndpoint, stsWSDLLocation, stsServiceName, stsPortName, stsNamespace);
    }

    public DefaultSTSIssuedTokenConfiguration(String protocol, String stsEndpoint, String stsMEXAddress) {
        super(protocol, stsEndpoint, stsMEXAddress);
    }

    public DefaultSTSIssuedTokenConfiguration(String protocol, String stsEndpoint, String stsWSDLLocation, String stsServiceName, String stsPortName, String stsNamespace) {
        super(protocol, stsEndpoint, stsWSDLLocation, stsServiceName, stsPortName, stsNamespace);
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setKeySize(long keySize) {
        this.keySize = keySize;
    }

    public void setSignWith(String signWithAlg) {
        this.signWith = signWithAlg;
    }

    public void setEncryptWith(String encWithAlg) {
        this.encryptWith = encWithAlg;
    }

    public void setSignatureAlgorithm(String sigAlg) {
        this.signatureAlg = sigAlg;
    }

    public void setEncryptionAlgorithm(String encAlg) {
        this.encAlg = encAlg;
    }

    public void setCanonicalizationAlgorithm(String canAlg) {
        this.canAlg = canAlg;
    }

    public void setKeyWrapAlgorithm(String keyWrapAlg) {
        this.keyWrapAlg = keyWrapAlg;
    }

    public void setClaims(Claims claims) {
        this.claims = claims;
    }

    public void setOBOToken(Token token) {
        this.oboToken = token;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public long getKeySize() {
        return this.keySize;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlg;
    }

    public String getEncryptionAlgorithm() {
        return this.encAlg;
    }

    public String getCanonicalizationAlgorithm() {
        return this.canAlg;
    }

    public String getKeyWrapAlgorithm() {
        return this.keyWrapAlg;
    }

    public String getSignWith() {
        return this.signWith;
    }

    public String getEncryptWith() {
        return this.encryptWith;
    }

    public Claims getClaims() {
        return this.claims;
    }

    public Token getOBOToken() {
        return this.oboToken;
    }

    public void setSecondaryIssuedTokenParameters(SecondaryIssuedTokenParameters sisPara) {
        this.sisPara = sisPara;
    }

    private void parseAssertions(IssuedToken issuedToken, PolicyAssertion localToken) {
        RequestSecurityTokenTemplate rstt;
        Issuer issuer = issuedToken.getIssuer();
        URI stsURI = null;
        if (issuer != null) {
            stsURI = issuedToken.getIssuer().getAddress().getURI();
        }
        if (stsURI != null) {
            this.stsEndpoint = stsURI.toString();
            this.stsMEXAddress = this.getAddressFromMetadata(issuedToken);
            if (this.stsMEXAddress == null) {
                this.stsMEXAddress = this.stsEndpoint;
            }
        } else if (localToken != null && PRE_CONFIGURED_STS.equals(localToken.getName().getLocalPart())) {
            Map<QName, String> attrs = localToken.getAttributes();
            this.stsNamespace = attrs.get(new QName(CONFIG_NAMESPACE, NAMESPACE));
            this.stsEndpoint = attrs.get(new QName(CONFIG_NAMESPACE, ENDPOINT));
            if (this.stsEndpoint == null) {
                this.stsEndpoint = attrs.get(new QName(CONFIG_NAMESPACE, ENDPOINT.toLowerCase()));
            }
            this.stsMEXAddress = attrs.get(new QName(CONFIG_NAMESPACE, METADATA));
            if (this.stsMEXAddress == null) {
                this.stsWSDLLocation = attrs.get(new QName(CONFIG_NAMESPACE, WSDL_LOCATION));
                this.stsServiceName = attrs.get(new QName(CONFIG_NAMESPACE, SERVICE_NAME));
                this.stsPortName = attrs.get(new QName(CONFIG_NAMESPACE, PORT_NAME));
            }
        }
        if ((rstt = issuedToken.getRequestSecurityTokenTemplate()) != null) {
            if (this.protocol.equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI())) {
                SecondaryIssuedTokenParametersImpl sitp = new SecondaryIssuedTokenParametersImpl();
                this.copy(rstt, sitp);
                sitp.setClaims(this.getClaims((PolicyAssertion)((Object)issuedToken)));
                this.sisPara = sitp;
            } else {
                this.copy(rstt);
                this.setClaims(this.getClaims((PolicyAssertion)((Object)issuedToken)));
            }
        }
    }

    private String getAddressFromMetadata(IssuedToken issuedToken) {
        PolicyAssertion assertion;
        Iterator<PolicyAssertion> iterator;
        PolicyAssertion issuer = (PolicyAssertion)((Object)issuedToken.getIssuer());
        PolicyAssertion addressingMetadata = null;
        PolicyAssertion metadata = null;
        PolicyAssertion metadataSection = null;
        PolicyAssertion metadataReference = null;
        Address address = null;
        if (issuer != null) {
            address = ((Issuer)((Object)issuer)).getAddress();
            if (issuer.hasNestedAssertions()) {
                iterator = issuer.getNestedAssertionsIterator();
                while (iterator.hasNext()) {
                    assertion = iterator.next();
                    if (!WSTrustUtil.isAddressingMetadata(assertion)) continue;
                    addressingMetadata = assertion;
                    break;
                }
            }
        }
        if (addressingMetadata != null && addressingMetadata.hasNestedAssertions()) {
            iterator = addressingMetadata.getNestedAssertionsIterator();
            while (iterator.hasNext()) {
                assertion = iterator.next();
                if (!WSTrustUtil.isMetadata(assertion)) continue;
                metadata = assertion;
                break;
            }
        }
        if (metadata != null && metadata.hasNestedAssertions()) {
            iterator = metadata.getNestedAssertionsIterator();
            while (iterator.hasNext()) {
                assertion = iterator.next();
                if (!WSTrustUtil.isMetadataSection(assertion)) continue;
                metadataSection = assertion;
                break;
            }
        }
        if (metadataSection != null && metadataSection.hasNestedAssertions()) {
            iterator = metadataSection.getNestedAssertionsIterator();
            while (iterator.hasNext()) {
                assertion = iterator.next();
                if (!WSTrustUtil.isMetadataReference(assertion)) continue;
                metadataReference = assertion;
                break;
            }
        }
        if (metadataReference != null && metadataReference.hasNestedAssertions()) {
            iterator = metadataReference.getNestedAssertionsIterator();
            while (iterator.hasNext()) {
                assertion = iterator.next();
                if (!PolicyUtil.isAddress(assertion)) continue;
                address = (Address)((Object)assertion);
            }
        }
        if (address != null) {
            return address.getURI().toString();
        }
        return null;
    }

    private Claims getClaims(PolicyAssertion token) {
        Object cs = null;
        Iterator<PolicyAssertion> tokens = token.getNestedAssertionsIterator();
        while (tokens.hasNext()) {
            PolicyAssertion cToken = tokens.next();
            if (!REQUEST_SECURITY_TOKEN_TEMPLATE.equals(cToken.getName().getLocalPart())) continue;
            Iterator<PolicyAssertion> cTokens = cToken.getNestedAssertionsIterator();
            while (cTokens.hasNext()) {
                PolicyAssertion gToken = cTokens.next();
                if (!CLAIMS.equals(gToken.getName().getLocalPart())) continue;
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    XMLOutputFactory xof = XMLOutputFactory.newInstance();
                    XMLStreamWriter writer = xof.createXMLStreamWriter(baos);
                    AssertionSet set = AssertionSet.createAssertionSet(Arrays.asList(gToken));
                    Policy policy = Policy.createPolicy(Arrays.asList(set));
                    PolicySourceModel sourceModel = PolicyModelGenerator.getGenerator().translate(policy);
                    XmlPolicyModelMarshaller pm = (XmlPolicyModelMarshaller)XmlPolicyModelMarshaller.getXmlMarshaller(true);
                    pm.marshal(sourceModel, (Object)writer);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(new ByteArrayInputStream(baos.toByteArray()));
                    Element claimsEle = (Element)doc.getElementsByTagNameNS("*", CLAIMS).item(0);
                    this.claims = new ClaimsImpl(ClaimsImpl.fromElement(claimsEle));
                    writer.close();
                }
                catch (Exception e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
        }
        return this.claims;
    }

    private void copy(RequestSecurityTokenTemplate rstt) {
        this.setTokenType(rstt.getTokenType());
        this.setKeyType(rstt.getKeyType());
        this.setKeySize(rstt.getKeySize());
        this.setSignWith(rstt.getSignWith());
        this.setEncryptWith(rstt.getEncryptWith());
        this.setSignatureAlgorithm(rstt.getSignatureAlgorithm());
        this.setEncryptionAlgorithm(rstt.getEncryptionAlgorithm());
        this.setCanonicalizationAlgorithm(rstt.getCanonicalizationAlgorithm());
    }

    private void copy(RequestSecurityTokenTemplate rstt, SecondaryIssuedTokenParametersImpl sitp) {
        sitp.setTokenType(rstt.getTokenType());
        sitp.setKeyType(rstt.getKeyType());
        sitp.setKeySize(rstt.getKeySize());
        sitp.setSignWith(rstt.getSignWith());
        sitp.setEncryptWith(rstt.getEncryptWith());
        sitp.setSignatureAlgorithm(rstt.getSignatureAlgorithm());
        sitp.setEncryptionAlgorithm(rstt.getEncryptionAlgorithm());
        sitp.setCanonicalizationAlgorithm(rstt.getCanonicalizationAlgorithm());
    }
}

