/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.policy;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.fastinfoset.FastInfosetFeature;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.encoding.policy.EncodingConstants;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.ModelConfiguratorProvider;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;

public class FastInfosetModelConfiguratorProvider
implements ModelConfiguratorProvider {
    public static final QName enabled = new QName("enabled");

    public void configure(@NotNull WSDLModel model, @NotNull PolicyMap policyMap) throws PolicyException {
        assert (model != null);
        assert (policyMap != null);
        for (WSDLService service : model.getServices().values()) {
            for (WSDLPort port : service.getPorts()) {
                PolicyMapKey key = PolicyMap.createWsdlEndpointScopeKey((QName)service.getName(), (QName)port.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(key);
                if (null == policy || !policy.contains(EncodingConstants.OPTIMIZED_FI_SERIALIZATION_ASSERTION)) continue;
                for (AssertionSet assertionSet : policy) {
                    for (PolicyAssertion assertion : assertionSet) {
                        if (!EncodingConstants.OPTIMIZED_FI_SERIALIZATION_ASSERTION.equals(assertion.getName())) continue;
                        String value = assertion.getAttributeValue(enabled);
                        boolean isFastInfosetEnabled = Boolean.valueOf(value.trim());
                        port.addFeature((WebServiceFeature)new FastInfosetFeature(isFastInfosetEnabled));
                    }
                }
            }
        }
    }
}

