/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.coordinator;

import com.sun.istack.NotNull;
import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.ws.tx.common.ActivityIdentifier;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.coordinator.CoordinationContext200410;
import com.sun.xml.ws.tx.coordinator.CoordinationContextInterface;
import com.sun.xml.ws.tx.coordinator.LocalizationMessages;
import com.sun.xml.ws.tx.coordinator.RegistrationManager;
import com.sun.xml.ws.tx.webservice.member.coord.CreateCoordinationContextType;
import java.util.UUID;
import java.util.logging.Level;
import javax.xml.ws.EndpointReference;

public class ContextFactory {
    private static String activityId;
    private static TxLogger logger;

    public static CoordinationContextInterface createContext(@NotNull String coordType, long expires) {
        if (logger.isLogging(Level.FINER)) {
            logger.entering("ContextFactory.createContext: coordType=" + coordType + " expires=" + expires);
        }
        if (!"http://schemas.xmlsoap.org/ws/2004/10/wsat".equals(coordType)) {
            if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06".equals(coordType)) {
                throw new UnsupportedOperationException(LocalizationMessages.OASIS_UNSUPPORTED_3000());
            }
            throw new UnsupportedOperationException(LocalizationMessages.UNRECOGNIZED_COORDINATION_TYPE_3001(coordType));
        }
        CoordinationContext200410 context = new CoordinationContext200410();
        context.setCoordinationType(coordType);
        context.setExpires(expires);
        activityId = UUID.randomUUID().toString();
        context.setIdentifier("uuid:WSCOOR-SUN-" + activityId);
        context.setRegistrationService(RegistrationManager.newRegistrationEPR(new ActivityIdentifier(context.getIdentifier()), expires));
        if (logger.isLogging(Level.FINER)) {
            logger.exiting("ContextFactory.createContext: created context for activity id: " + context.getIdentifier());
        }
        return context;
    }

    public static CoordinationContextInterface createContext(@NotNull CreateCoordinationContextType contextRequest) {
        return ContextFactory.createContext(contextRequest.getCoordinationType(), contextRequest.getExpires().getValue());
    }

    static CoordinationContextInterface createTestContext(String coordType, long expires) {
        if (!"http://schemas.xmlsoap.org/ws/2004/10/wsat".equals(coordType)) {
            if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06".equals(coordType)) {
                throw new UnsupportedOperationException(LocalizationMessages.OASIS_UNSUPPORTED_3000());
            }
            throw new UnsupportedOperationException(LocalizationMessages.UNRECOGNIZED_COORDINATION_TYPE_3001(coordType));
        }
        CoordinationContext200410 context = new CoordinationContext200410();
        context.setCoordinationType(coordType);
        context.setExpires(expires);
        activityId = UUID.randomUUID().toString();
        context.setIdentifier("uuid:WSCOOR-SUN-" + activityId);
        context.setRegistrationService((EndpointReference)new MemberSubmissionEndpointReference());
        return context;
    }

    static {
        logger = TxLogger.getCoordLogger(ContextFactory.class);
    }
}

