/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.saml;

import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.saml.Action;
import com.sun.xml.wss.saml.Advice;
import com.sun.xml.wss.saml.AnyType;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.AssertionIDRef;
import com.sun.xml.wss.saml.AssertionIDReference;
import com.sun.xml.wss.saml.Attribute;
import com.sun.xml.wss.saml.AttributeDesignator;
import com.sun.xml.wss.saml.AttributeStatement;
import com.sun.xml.wss.saml.AudienceRestriction;
import com.sun.xml.wss.saml.AudienceRestrictionCondition;
import com.sun.xml.wss.saml.AuthenticationStatement;
import com.sun.xml.wss.saml.AuthnContext;
import com.sun.xml.wss.saml.AuthnDecisionStatement;
import com.sun.xml.wss.saml.AuthnStatement;
import com.sun.xml.wss.saml.AuthorityBinding;
import com.sun.xml.wss.saml.AuthorizationDecisionStatement;
import com.sun.xml.wss.saml.Conditions;
import com.sun.xml.wss.saml.DoNotCacheCondition;
import com.sun.xml.wss.saml.Evidence;
import com.sun.xml.wss.saml.KeyInfoConfirmationData;
import com.sun.xml.wss.saml.NameID;
import com.sun.xml.wss.saml.NameIdentifier;
import com.sun.xml.wss.saml.OneTimeUse;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.Subject;
import com.sun.xml.wss.saml.SubjectConfirmation;
import com.sun.xml.wss.saml.SubjectConfirmationData;
import com.sun.xml.wss.saml.SubjectLocality;
import com.sun.xml.wss.saml.impl.SAMLAssertion1_1FactoryImpl;
import com.sun.xml.wss.saml.impl.SAMLAssertion2_1FactoryImpl;
import com.sun.xml.wss.saml.impl.SAMLAssertion2_2FactoryImpl;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;

public abstract class SAMLAssertionFactory {
    public static final String SAML1_1 = "Saml1.1";
    public static final String SAML2_0 = "Saml2.0";
    public static String SAML_VER_CHECK = null;

    protected SAMLAssertionFactory() {
    }

    public static SAMLAssertionFactory newInstance(String samlVersion) throws XWSSecurityException {
        if (samlVersion.intern() == SAML1_1) {
            SAML_VER_CHECK = SAML1_1;
            if (System.getProperty("com.sun.xml.wss.saml.binding.jaxb") != null) {
                return new SAMLAssertion1_1FactoryImpl();
            }
            return new SAMLAssertion2_1FactoryImpl();
        }
        if (samlVersion.intern() == SAML2_0 && System.getProperty("com.sun.xml.wss.saml.binding.jaxb") == null) {
            SAML_VER_CHECK = SAML2_0;
            return new SAMLAssertion2_2FactoryImpl();
        }
        throw new XWSSecurityException("Unsupported SAML Version");
    }

    public abstract Action createAction(String var1, String var2) throws SAMLException;

    public abstract Advice createAdvice(List var1, List var2, List var3) throws SAMLException;

    public abstract AnyType createAnyType() throws SAMLException;

    public abstract Assertion createAssertion(String var1, String var2, GregorianCalendar var3, Conditions var4, Advice var5, List var6) throws SAMLException;

    public abstract Assertion createAssertion(String var1, NameID var2, GregorianCalendar var3, Conditions var4, Advice var5, Subject var6, List var7) throws SAMLException;

    public abstract Assertion createAssertion(Element var1) throws SAMLException;

    public abstract Assertion createAssertion(XMLStreamReader var1) throws SAMLException;

    public abstract AssertionIDReference createAssertionIDReference() throws SAMLException;

    public abstract AssertionIDRef createAssertionIDRef() throws SAMLException;

    public abstract AssertionIDReference createAssertionIDReference(String var1) throws SAMLException;

    public abstract AssertionIDRef createAssertionIDRef(String var1) throws SAMLException;

    public abstract Attribute createAttribute(String var1, String var2, List var3) throws SAMLException;

    public abstract Attribute createAttribute(String var1, List var2) throws SAMLException;

    public abstract AttributeDesignator createAttributeDesignator(String var1, String var2) throws SAMLException;

    public abstract AttributeStatement createAttributeStatement(Subject var1, List var2) throws SAMLException;

    public abstract AttributeStatement createAttributeStatement(List var1) throws SAMLException;

    public abstract AudienceRestrictionCondition createAudienceRestrictionCondition(List var1) throws SAMLException;

    public abstract AudienceRestriction createAudienceRestriction(List var1) throws SAMLException;

    public abstract AuthenticationStatement createAuthenticationStatement(String var1, GregorianCalendar var2, Subject var3, SubjectLocality var4, List var5) throws SAMLException;

    public abstract AuthnStatement createAuthnStatement(GregorianCalendar var1, SubjectLocality var2, AuthnContext var3) throws SAMLException;

    public abstract AuthorityBinding createAuthorityBinding(QName var1, String var2, String var3) throws SAMLException;

    public abstract AuthnContext createAuthnContext() throws SAMLException;

    public abstract AuthnContext createAuthnContext(String var1, String var2) throws SAMLException;

    public abstract AuthorizationDecisionStatement createAuthorizationDecisionStatement(Subject var1, String var2, String var3, List var4, Evidence var5) throws SAMLException;

    public abstract AuthnDecisionStatement createAuthnDecisionStatement(String var1, String var2, List var3, Evidence var4) throws SAMLException;

    public abstract Conditions createConditions() throws SAMLException;

    public abstract Conditions createConditions(GregorianCalendar var1, GregorianCalendar var2, List var3, List var4, List var5) throws SAMLException;

    public abstract Conditions createConditions(GregorianCalendar var1, GregorianCalendar var2, List var3, List var4, List var5, List var6) throws SAMLException;

    public abstract DoNotCacheCondition createDoNotCacheCondition() throws SAMLException;

    public abstract OneTimeUse createOneTimeUse() throws SAMLException;

    public abstract Evidence createEvidence(List var1, List var2) throws SAMLException;

    public abstract NameIdentifier createNameIdentifier(String var1, String var2, String var3) throws SAMLException;

    public abstract NameID createNameID(String var1, String var2, String var3) throws SAMLException;

    public abstract Subject createSubject(NameIdentifier var1, SubjectConfirmation var2) throws SAMLException;

    public abstract Subject createSubject(NameID var1, SubjectConfirmation var2) throws SAMLException;

    public abstract SubjectConfirmation createSubjectConfirmation(String var1) throws SAMLException;

    public abstract SubjectConfirmation createSubjectConfirmation(NameID var1, String var2) throws SAMLException;

    public abstract SubjectConfirmation createSubjectConfirmation(List var1, SubjectConfirmationData var2, KeyInfo var3) throws SAMLException;

    public abstract SubjectConfirmation createSubjectConfirmation(List var1, Element var2, Element var3) throws SAMLException;

    public abstract SubjectConfirmation createSubjectConfirmation(NameID var1, SubjectConfirmationData var2, String var3) throws SAMLException;

    public abstract SubjectConfirmation createSubjectConfirmation(NameID var1, KeyInfoConfirmationData var2, String var3) throws SAMLException;

    public abstract SubjectConfirmationData createSubjectConfirmationData(String var1, String var2, GregorianCalendar var3, GregorianCalendar var4, String var5, Element var6) throws SAMLException;

    public abstract SubjectConfirmationData createSubjectConfirmationData(String var1, String var2, GregorianCalendar var3, GregorianCalendar var4, String var5, KeyInfo var6) throws SAMLException;

    public abstract KeyInfoConfirmationData createKeyInfoConfirmationData(Element var1) throws SAMLException;

    public abstract SubjectLocality createSubjectLocality() throws SAMLException;

    public abstract SubjectLocality createSubjectLocality(String var1, String var2) throws SAMLException;
}

