/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.logging;

import com.swoval.logging.DefaultLogger;
import com.swoval.logging.Logger;
import java.io.IOException;
import java.io.OutputStream;

public class Loggers {
    private static Logger global = null;
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger() {
        Object object = lock;
        synchronized (object) {
            if (global == null) {
                Level level = Level.fromString(System.getProperty("swoval.log.level", "error"));
                global = DefaultLogger.get(System.getProperty("swoval.logger"));
                if (global == null) {
                    global = new LoggerImpl(level, System.out, System.err, Level.ERROR);
                }
            }
            return global;
        }
    }

    public static boolean shouldLog(Logger logger, Level level) {
        return logger.getLevel().compareTo(level) <= 0;
    }

    private static class LoggerImpl
    implements Logger {
        private final Level level;
        private final OutputStream infoStream;
        private final OutputStream errorStream;
        private final Level errorLevel;

        LoggerImpl(Level level, OutputStream outputStream, OutputStream outputStream2, Level level2) {
            this.level = level;
            this.infoStream = outputStream;
            this.errorStream = outputStream2;
            this.errorLevel = level2;
        }

        @Override
        public Level getLevel() {
            return this.level;
        }

        @Override
        public void verbose(String string) {
            OutputStream outputStream = this.errorLevel == Level.VERBOSE ? this.errorStream : this.infoStream;
            try {
                outputStream.write(string.getBytes());
                outputStream.write(10);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void debug(String string) {
            OutputStream outputStream = this.errorLevel.compareTo(Level.DEBUG) < 0 ? this.errorStream : this.infoStream;
            try {
                outputStream.write(string.getBytes());
                outputStream.write(10);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void info(String string) {
            OutputStream outputStream = this.errorLevel.compareTo(Level.INFO) < 0 ? this.errorStream : this.infoStream;
            try {
                outputStream.write(string.getBytes());
                outputStream.write(10);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void warn(String string) {
            OutputStream outputStream = this.errorLevel.compareTo(Level.WARN) < 0 ? this.errorStream : this.infoStream;
            try {
                outputStream.write(string.getBytes());
                outputStream.write(10);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void error(String string) {
            OutputStream outputStream = this.errorLevel.compareTo(Level.ERROR) < 0 ? this.errorStream : this.infoStream;
            try {
                outputStream.write(string.getBytes());
                outputStream.write(10);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static abstract class Level
    implements Comparable<Level> {
        public static final Level DEBUG = new Level(){

            @Override
            public int compareTo(Level level) {
                return level == VERBOSE ? 1 : (level == DEBUG ? 0 : -1);
            }

            public String toString() {
                return "DEBUG";
            }
        };
        public static final Level INFO = new Level(){

            @Override
            public int compareTo(Level level) {
                return level == INFO ? 0 : (level == DEBUG || level == VERBOSE ? 1 : -1);
            }

            public String toString() {
                return "INFO";
            }
        };
        public static final Level WARN = new Level(){

            @Override
            public int compareTo(Level level) {
                return level == WARN ? 0 : (level == DEBUG || level == INFO || level == VERBOSE ? 1 : -1);
            }

            public String toString() {
                return "WARN";
            }
        };
        public static final Level ERROR = new Level(){

            @Override
            public int compareTo(Level level) {
                return level == ERROR ? 0 : 1;
            }

            public String toString() {
                return "ERROR";
            }
        };
        public static final Level VERBOSE = new Level(){

            @Override
            public int compareTo(Level level) {
                return level == VERBOSE ? 0 : -1;
            }

            public String toString() {
                return "VERBOSE";
            }
        };

        Level() {
        }

        public static Level fromString(String string) {
            switch (string.toLowerCase()) {
                case "verbose": {
                    return VERBOSE;
                }
                case "debug": {
                    return DEBUG;
                }
                case "info": {
                    return INFO;
                }
                case "warn": {
                    return WARN;
                }
            }
            return ERROR;
        }
    }
}

