/*
 * Decompiled with CFR 0.152.
 */
package com.swrve.ratelimitedlogger;

import com.swrve.ratelimitedlogger.LogWithPatternAndLevel;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class Registry {
    private static final Logger logger = LoggerFactory.getLogger(Registry.class);
    private final ConcurrentHashMap<Duration, ConcurrentHashMap<LogWithPatternAndLevel, Boolean>> registry = new ConcurrentHashMap();
    private final ThreadFactory threadFactory = new ThreadFactory(){
        final AtomicLong count = new AtomicLong(0L);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName(String.format(Locale.ROOT, "RateLimitedLogRegistry-%d", this.count.getAndIncrement()));
            thread.setDaemon(true);
            return thread;
        }
    };
    private final ScheduledExecutorService resetScheduler = Executors.newScheduledThreadPool(1, this.threadFactory);

    Registry() {
    }

    synchronized void register(LogWithPatternAndLevel log, Duration period) {
        boolean needToScheduleReset = false;
        ConcurrentHashMap<LogWithPatternAndLevel, Boolean> logLinesForPeriod = this.registry.get(period);
        if (logLinesForPeriod == null) {
            needToScheduleReset = true;
            logLinesForPeriod = new ConcurrentHashMap();
            this.registry.put(period, logLinesForPeriod);
        } else if (logLinesForPeriod.get(log) != null) {
            return;
        }
        logLinesForPeriod.put(log, Boolean.TRUE);
        if (needToScheduleReset) {
            ConcurrentHashMap<LogWithPatternAndLevel, Boolean> finalLogLinesForPeriod = logLinesForPeriod;
            this.resetScheduler.scheduleWithFixedDelay(() -> {
                try {
                    this.resetAllCounters(finalLogLinesForPeriod);
                }
                catch (Exception e) {
                    logger.warn("failed to reset counters: " + e, (Throwable)e);
                }
            }, period.toMillis(), period.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private void resetAllCounters(ConcurrentHashMap<LogWithPatternAndLevel, Boolean> logLinesForPeriod) {
        for (LogWithPatternAndLevel log : logLinesForPeriod.keySet()) {
            log.periodicReset();
        }
    }

    synchronized void flush() {
        for (Map.Entry<Duration, ConcurrentHashMap<LogWithPatternAndLevel, Boolean>> entry : this.registry.entrySet()) {
            ConcurrentHashMap<LogWithPatternAndLevel, Boolean> logLinesForPeriod = entry.getValue();
            this.resetAllCounters(logLinesForPeriod);
            logLinesForPeriod.clear();
        }
    }
}

